/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.impl;

import org.apache.flink.runtime.execution.ExecutionListener;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.RuntimeEnvironment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.profiling.impl.TaskManagerProfilerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentListenerImpl
implements ExecutionListener {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentListenerImpl.class);
    private final TaskManagerProfilerImpl taskManagerProfiler;
    private final RuntimeEnvironment environment;

    public EnvironmentListenerImpl(TaskManagerProfilerImpl taskManagerProfiler, RuntimeEnvironment environment) {
        this.taskManagerProfiler = taskManagerProfiler;
        this.environment = environment;
    }

    @Override
    public void executionStateChanged(JobID jobID, JobVertexID vertexId, int subtaskIndex, ExecutionAttemptID executionId, ExecutionState newExecutionState, String optionalMessage) {
        switch (newExecutionState) {
            case RUNNING: {
                this.taskManagerProfiler.registerMainThreadForCPUProfiling(this.environment, this.environment.getExecutingThread(), vertexId, subtaskIndex, executionId);
                break;
            }
            case FINISHED: 
            case CANCELING: 
            case CANCELED: 
            case FAILED: {
                this.taskManagerProfiler.unregisterMainThreadFromCPUProfiling(this.environment, this.environment.getExecutingThread());
                break;
            }
            default: {
                LOG.error(String.format("Unexpected state transition to %s for vertex %s (%d) attempt %s", new Object[]{newExecutionState, vertexId, subtaskIndex, executionId}));
            }
        }
    }
}

