/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.security.MessageDigest;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.shaded.com.google.common.io.Files;
import org.apache.flink.util.InstantiationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlobServerConnection
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(BlobServerConnection.class);
    private final Socket clientSocket;
    private final BlobServer blobServer;

    BlobServerConnection(Socket clientSocket, BlobServer blobServer) {
        super("BLOB connection for " + clientSocket.getRemoteSocketAddress().toString());
        this.setDaemon(true);
        if (blobServer == null) {
            throw new NullPointerException();
        }
        this.clientSocket = clientSocket;
        this.blobServer = blobServer;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void close() {
        BlobUtils.closeSilently(this.clientSocket, LOG);
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get(InputStream inputStream, OutputStream outputStream, byte[] buf) throws IOException {
        File blobFile;
        try {
            int contentAddressable = inputStream.read();
            if (contentAddressable < 0) {
                throw new EOFException("Premature end of GET request");
            }
            if (contentAddressable == 1) {
                byte[] jidBytes = new byte[16];
                BlobUtils.readFully(inputStream, jidBytes, 0, 16, "JobID");
                JobID jobID = JobID.fromByteArray((byte[])jidBytes);
                String key = BlobServerConnection.readKey(buf, inputStream);
                blobFile = this.blobServer.getStorageLocation(jobID, key);
            } else if (contentAddressable == 0) {
                BlobKey key = BlobKey.readFromInputStream(inputStream);
                blobFile = this.blobServer.getStorageLocation(key);
            } else {
                throw new IOException("Unknown type of BLOB addressing.");
            }
            if (!blobFile.exists()) {
                throw new IOException("Cannot find required BLOB at " + blobFile.getAbsolutePath());
            }
            if (blobFile.length() > Integer.MAX_VALUE) {
                throw new IOException("BLOB size exceeds the maximum size (2 GB).");
            }
            outputStream.write(0);
        }
        catch (Throwable t) {
            LOG.error("GET operation failed", t);
            try {
                BlobServerConnection.writeErrorToStream(outputStream, t);
            }
            catch (IOException key) {
                // empty catch block
            }
            this.clientSocket.close();
            return;
        }
        try {
            int blobLen = (int)blobFile.length();
            BlobUtils.writeLength(blobLen, outputStream);
            FileInputStream fis = new FileInputStream(blobFile);
            try {
                int read;
                for (int bytesRemaining = blobLen; bytesRemaining > 0; bytesRemaining -= read) {
                    read = fis.read(buf);
                    if (read < 0) {
                        throw new IOException("Premature end of BLOB file stream for " + blobFile.getAbsolutePath());
                    }
                    outputStream.write(buf, 0, read);
                }
            }
            finally {
                fis.close();
            }
        }
        catch (SocketException e) {
            LOG.debug("Socket connection closed", (Throwable)e);
        }
        catch (Throwable t) {
            LOG.error("GET operation failed", t);
            this.clientSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(InputStream inputStream, OutputStream outputStream, byte[] buf) throws IOException {
        JobID jobID = null;
        String key = null;
        MessageDigest md = null;
        File incomingFile = null;
        FileOutputStream fos = null;
        try {
            int bytesExpected;
            int contentAddressable = inputStream.read();
            if (contentAddressable < 0) {
                throw new EOFException("Premature end of PUT request");
            }
            if (contentAddressable == 1) {
                byte[] jidBytes = new byte[16];
                BlobUtils.readFully(inputStream, jidBytes, 0, 16, "JobID");
                jobID = JobID.fromByteArray((byte[])jidBytes);
                key = BlobServerConnection.readKey(buf, inputStream);
            } else if (contentAddressable == 0) {
                md = BlobUtils.createMessageDigest();
            } else {
                throw new IOException("Unknown type of BLOB addressing.");
            }
            if (LOG.isDebugEnabled()) {
                if (contentAddressable == 1) {
                    LOG.debug(String.format("Received PUT request for BLOB under %s / \"%s\"", jobID, key));
                } else {
                    LOG.debug("Received PUT request for content addressable BLOB");
                }
            }
            incomingFile = this.blobServer.createTemporaryFilename();
            fos = new FileOutputStream(incomingFile);
            while ((bytesExpected = BlobUtils.readLength(inputStream)) != -1) {
                if (bytesExpected > 65536) {
                    throw new IOException("Unexpected number of incoming bytes: " + bytesExpected);
                }
                BlobUtils.readFully(inputStream, buf, 0, bytesExpected, "buffer");
                fos.write(buf, 0, bytesExpected);
                if (md == null) continue;
                md.update(buf, 0, bytesExpected);
            }
            fos.close();
            if (contentAddressable == 1) {
                File storageFile = this.blobServer.getStorageLocation(jobID, key);
                Files.move(incomingFile, storageFile);
                incomingFile = null;
                outputStream.write(0);
            } else {
                BlobKey blobKey = new BlobKey(md.digest());
                File storageFile = this.blobServer.getStorageLocation(blobKey);
                Files.move(incomingFile, storageFile);
                incomingFile = null;
                outputStream.write(0);
                blobKey.writeToOutputStream(outputStream);
            }
        }
        catch (SocketException e) {
            LOG.debug("Socket connection closed", (Throwable)e);
        }
        catch (Throwable t) {
            LOG.error("PUT operation failed", t);
            try {
                BlobServerConnection.writeErrorToStream(outputStream, t);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.clientSocket.close();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable t) {
                    LOG.warn("Cannot close stream to BLOB staging file", t);
                }
            }
            if (incomingFile != null && !incomingFile.delete()) {
                LOG.warn("Cannot delete BLOB server staging file " + incomingFile.getAbsolutePath());
            }
        }
    }

    private void delete(InputStream inputStream, OutputStream outputStream, byte[] buf) throws IOException {
        try {
            int type = inputStream.read();
            if (type < 0) {
                throw new EOFException("Premature end of DELETE request");
            }
            if (type == 0) {
                BlobKey key = BlobKey.readFromInputStream(inputStream);
                File blobFile = this.blobServer.getStorageLocation(key);
                if (blobFile.exists() && !blobFile.delete()) {
                    throw new IOException("Cannot delete BLOB file " + blobFile.getAbsolutePath());
                }
            } else if (type == 1) {
                byte[] jidBytes = new byte[16];
                BlobUtils.readFully(inputStream, jidBytes, 0, 16, "JobID");
                JobID jobID = JobID.fromByteArray((byte[])jidBytes);
                String key = BlobServerConnection.readKey(buf, inputStream);
                File blobFile = this.blobServer.getStorageLocation(jobID, key);
                if (blobFile.exists() && !blobFile.delete()) {
                    throw new IOException("Cannot delete BLOB file " + blobFile.getAbsolutePath());
                }
            } else if (type == 2) {
                byte[] jidBytes = new byte[16];
                BlobUtils.readFully(inputStream, jidBytes, 0, 16, "JobID");
                JobID jobID = JobID.fromByteArray((byte[])jidBytes);
                this.blobServer.deleteJobDirectory(jobID);
            } else {
                throw new IOException("Unrecognized addressing type: " + type);
            }
            outputStream.write(0);
        }
        catch (Throwable t) {
            LOG.error("DELETE operation failed", t);
            try {
                BlobServerConnection.writeErrorToStream(outputStream, t);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.clientSocket.close();
        }
    }

    private static String readKey(byte[] buf, InputStream inputStream) throws IOException {
        int keyLength = BlobUtils.readLength(inputStream);
        if (keyLength > 64) {
            throw new IOException("Unexpected key length " + keyLength);
        }
        BlobUtils.readFully(inputStream, buf, 0, keyLength, "BlobKey");
        return new String(buf, 0, keyLength, BlobUtils.DEFAULT_CHARSET);
    }

    private static void writeErrorToStream(OutputStream out, Throwable t) throws IOException {
        byte[] bytes = InstantiationUtil.serializeObject((Object)t);
        out.write(1);
        BlobUtils.writeLength(bytes.length, out);
        out.write(bytes);
    }
}

