/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.broadcast;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.runtime.broadcast.BroadcastVariableKey;
import org.apache.flink.runtime.broadcast.BroadcastVariableMaterialization;
import org.apache.flink.runtime.broadcast.MaterializationExpiredException;
import org.apache.flink.runtime.io.network.api.reader.MutableReader;
import org.apache.flink.runtime.operators.RegularPactTask;

public class BroadcastVariableManager {
    private final ConcurrentHashMap<BroadcastVariableKey, BroadcastVariableMaterialization<?, ?>> variables = new ConcurrentHashMap(16);

    public <T> BroadcastVariableMaterialization<T, ?> materializeBroadcastVariable(String name, int superstep, RegularPactTask<?, ?> holder, MutableReader<?> reader, TypeSerializerFactory<T> serializerFactory) throws IOException {
        BroadcastVariableKey key = new BroadcastVariableKey(holder.getEnvironment().getJobVertexId(), name, superstep);
        while (true) {
            BroadcastVariableMaterialization newMat;
            BroadcastVariableMaterialization previous;
            BroadcastVariableMaterialization materialization = (previous = this.variables.putIfAbsent(key, newMat = new BroadcastVariableMaterialization(key))) == null ? newMat : previous;
            try {
                materialization.materializeVariable(reader, serializerFactory, holder);
                return materialization;
            }
            catch (MaterializationExpiredException e) {
                boolean replaceSuccessful = false;
                try {
                    replaceSuccessful = this.variables.replace(key, materialization, newMat);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!replaceSuccessful) continue;
                try {
                    newMat.materializeVariable(reader, serializerFactory, holder);
                    return newMat;
                }
                catch (MaterializationExpiredException materializationExpiredException) {
                    continue;
                }
            }
            break;
        }
    }

    public void releaseReference(String name, int superstep, RegularPactTask<?, ?> referenceHolder) {
        BroadcastVariableKey key = new BroadcastVariableKey(referenceHolder.getEnvironment().getJobVertexId(), name, superstep);
        this.releaseReference(key, referenceHolder);
    }

    public void releaseReference(BroadcastVariableKey key, RegularPactTask<?, ?> referenceHolder) {
        BroadcastVariableMaterialization<?, ?> mat = this.variables.get(key);
        if (mat.decrementReference(referenceHolder)) {
            this.variables.remove(key, mat);
        }
    }

    public void releaseAllReferencesFromTask(RegularPactTask<?, ?> referenceHolder) {
        for (Map.Entry<BroadcastVariableKey, BroadcastVariableMaterialization<?, ?>> entry : this.variables.entrySet()) {
            BroadcastVariableMaterialization<?, ?> mat = entry.getValue();
            if (!mat.decrementReferenceIfHeld(referenceHolder)) continue;
            this.variables.remove(entry.getKey(), mat);
        }
    }

    public int getNumberOfVariablesWithReferences() {
        return this.variables.size();
    }
}

