/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import akka.actor.UntypedActor;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.messages.ExecutionGraphMessages;

public class CheckpointCoordinatorDeActivator
extends UntypedActor {
    private final CheckpointCoordinator coordinator;
    private final long interval;

    public CheckpointCoordinatorDeActivator(CheckpointCoordinator coordinator, long interval) {
        this.coordinator = coordinator;
        this.interval = interval;
    }

    public void onReceive(Object message) {
        if (message instanceof ExecutionGraphMessages.JobStatusChanged) {
            JobStatus status = ((ExecutionGraphMessages.JobStatusChanged)message).newJobStatus();
            if (status == JobStatus.RUNNING) {
                this.coordinator.startPeriodicCheckpointScheduler(this.interval);
            } else {
                this.coordinator.stopPeriodicCheckpointScheduler();
            }
        }
    }
}

