/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.actor.Status;
import akka.actor.Terminated;
import akka.actor.UntypedActor;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.messages.ExecutionGraphMessages;
import org.apache.flink.runtime.messages.JobClientMessages;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.slf4j.Logger;

public class JobClientActor
extends UntypedActor {
    private final ActorRef jobManager;
    private final Logger logger;
    private final boolean sysoutUpdates;
    private ActorRef submitter;

    public JobClientActor(ActorRef jobManager, Logger logger, boolean sysoutUpdates) {
        if (jobManager == null || logger == null) {
            throw new NullPointerException();
        }
        this.jobManager = jobManager;
        this.logger = logger;
        this.sysoutUpdates = sysoutUpdates;
    }

    public void onReceive(Object message) {
        if (message instanceof ExecutionGraphMessages.ExecutionStateChanged) {
            this.logAndPrintMessage(message);
        } else if (message instanceof ExecutionGraphMessages.JobStatusChanged) {
            this.logAndPrintMessage(message);
        } else if (message instanceof JobClientMessages.SubmitJobAndWait) {
            if (this.submitter == null) {
                JobGraph jobGraph = ((JobClientMessages.SubmitJobAndWait)message).jobGraph();
                if (jobGraph == null) {
                    this.logger.error("Received null JobGraph");
                    this.sender().tell((Object)new Status.Failure((Throwable)new Exception("JobGraph is null")), this.getSelf());
                } else {
                    this.logger.info("Sending message to JobManager {} to submit job {} ({}) and wait for progress", new Object[]{this.jobManager.path().toString(), jobGraph.getName(), jobGraph.getJobID()});
                    this.submitter = this.getSender();
                    this.jobManager.tell((Object)new JobManagerMessages.SubmitJob(jobGraph, true), this.getSelf());
                    this.getContext().watch(this.jobManager);
                }
            } else {
                String msg = "Received repeated 'SubmitJobAndWait'";
                this.logger.error(msg);
                this.getSender().tell((Object)new Status.Failure((Throwable)new Exception(msg)), ActorRef.noSender());
                this.getContext().unwatch(this.jobManager);
                this.getSelf().tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
            }
        } else if (message instanceof JobManagerMessages.JobResultSuccess) {
            this.logger.debug("Received JobResultSuccess message from JobManager");
            if (this.submitter != null) {
                this.submitter.tell(message, this.getSelf());
            }
            this.getContext().unwatch(this.jobManager);
            this.getSelf().tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
        } else if (message instanceof Status.Success) {
            this.logger.info("Job was successfully submitted to the JobManager");
        } else if (message instanceof Status.Failure) {
            this.logger.debug("Received failure from JobManager", ((Status.Failure)message).cause());
            if (this.submitter != null) {
                this.submitter.tell(message, this.sender());
            }
        } else if (message instanceof Terminated) {
            ActorRef target = ((Terminated)message).getActor();
            if (this.jobManager.equals((Object)target)) {
                String msg = "Lost connection to JobManager " + this.jobManager.path();
                this.logger.info(msg);
                this.submitter.tell((Object)new Status.Failure((Throwable)new Exception(msg)), this.getSelf());
            } else {
                this.logger.error("Received 'Terminated' for unknown actor " + target);
            }
        } else {
            this.logger.error("JobClient received unknown message: " + message);
        }
    }

    private void logAndPrintMessage(Object message) {
        this.logger.info(message.toString());
        if (this.sysoutUpdates) {
            System.out.println(message.toString());
        }
    }
}

