/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceConnectionInfo
implements IOReadableWritable,
Comparable<InstanceConnectionInfo>,
Serializable {
    private static final long serialVersionUID = -8254407801276350716L;
    private static final Logger LOG = LoggerFactory.getLogger(InstanceConnectionInfo.class);
    private InetAddress inetAddress;
    private int dataPort;
    private String fqdnHostName;
    private String hostName;

    public InstanceConnectionInfo(InetAddress inetAddress, int dataPort) {
        if (inetAddress == null) {
            throw new IllegalArgumentException("Argument inetAddress must not be null");
        }
        if (dataPort <= 0) {
            throw new IllegalArgumentException("Argument dataPort must be greater than zero");
        }
        this.dataPort = dataPort;
        this.inetAddress = inetAddress;
        try {
            this.fqdnHostName = this.inetAddress.getCanonicalHostName();
        }
        catch (Throwable t) {
            LOG.warn("Unable to determine the canonical hostname. Input split assignment (such as for HDFS files) may be non-local when the canonical hostname is missing.");
            LOG.debug("getCanonicalHostName() Exception:", t);
            this.fqdnHostName = this.inetAddress.getHostAddress();
        }
        if (this.fqdnHostName.equals(this.inetAddress.getHostAddress())) {
            this.hostName = this.fqdnHostName;
            LOG.warn("No hostname could be resolved for the IP address {}, using IP address as host name. Local input split assignment (such as for HDFS files) may be impacted.", (Object)this.inetAddress.getHostAddress());
        } else {
            this.hostName = NetUtils.getHostnameFromFQDN((String)this.fqdnHostName);
        }
    }

    public InstanceConnectionInfo() {
    }

    public int dataPort() {
        return this.dataPort;
    }

    public InetAddress address() {
        return this.inetAddress;
    }

    public String getFQDNHostname() {
        return this.fqdnHostName;
    }

    public String getHostname() {
        return this.hostName;
    }

    public String getInetAdress() {
        return this.inetAddress.toString();
    }

    public void read(DataInputView in) throws IOException {
        int addr_length = in.readInt();
        byte[] address = new byte[addr_length];
        in.readFully(address);
        this.dataPort = in.readInt();
        this.fqdnHostName = StringUtils.readNullableString((DataInputView)in);
        this.hostName = StringUtils.readNullableString((DataInputView)in);
        try {
            this.inetAddress = InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            throw new IOException("This lookup should never fail.", e);
        }
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.inetAddress.getAddress().length);
        out.write(this.inetAddress.getAddress());
        out.writeInt(this.dataPort);
        StringUtils.writeNullableString((String)this.fqdnHostName, (DataOutputView)out);
        StringUtils.writeNullableString((String)this.hostName, (DataOutputView)out);
    }

    public String toString() {
        return this.getFQDNHostname() + " (dataPort=" + this.dataPort + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof InstanceConnectionInfo) {
            InstanceConnectionInfo other = (InstanceConnectionInfo)obj;
            return this.dataPort == other.dataPort && this.inetAddress.equals(other.inetAddress);
        }
        return false;
    }

    public int hashCode() {
        return this.inetAddress.hashCode() + 17 * this.dataPort;
    }

    @Override
    public int compareTo(InstanceConnectionInfo o) {
        byte[] otherAddress;
        byte[] thisAddress = this.inetAddress.getAddress();
        if (thisAddress.length < (otherAddress = o.inetAddress.getAddress()).length) {
            return -1;
        }
        if (thisAddress.length > otherAddress.length) {
            return 1;
        }
        for (int i = 0; i < thisAddress.length; ++i) {
            byte tb = thisAddress[i];
            byte ob = otherAddress[i];
            if (tb < ob) {
                return -1;
            }
            if (tb <= ob) continue;
            return 1;
        }
        if (this.dataPort < o.dataPort) {
            return -1;
        }
        if (this.dataPort > o.dataPort) {
            return 1;
        }
        return 0;
    }
}

