/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.IOException;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.memorymanager.AbstractPagedOutputView;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class FileChannelOutputView
extends AbstractPagedOutputView {
    private final BlockChannelWriter<MemorySegment> writer;
    private final MemoryManager memManager;
    private final List<MemorySegment> memory;
    private int numBlocksWritten;
    private int bytesInLatestSegment;

    public FileChannelOutputView(BlockChannelWriter<MemorySegment> writer, MemoryManager memManager, List<MemorySegment> memory, int segmentSize) throws IOException {
        super(segmentSize, 0);
        Preconditions.checkNotNull(writer);
        Preconditions.checkNotNull(memManager);
        Preconditions.checkNotNull(memory);
        Preconditions.checkArgument(!writer.isClosed());
        this.writer = writer;
        this.memManager = memManager;
        this.memory = memory;
        for (MemorySegment next : memory) {
            writer.getReturnQueue().add(next);
        }
        this.advance();
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void closeAndDelete() throws IOException {
        this.close(true);
    }

    private void close(boolean delete) throws IOException {
        try {
            MemorySegment current = this.getCurrentSegment();
            if (current != null) {
                this.writeSegment(current, this.getCurrentPositionInSegment());
            }
            this.clear();
            if (delete) {
                this.writer.closeAndDelete();
            } else {
                this.writer.close();
            }
        }
        finally {
            this.memManager.release(this.memory);
        }
    }

    public int getBlockCount() {
        return this.numBlocksWritten;
    }

    public int getBytesInLatestSegment() {
        return this.bytesInLatestSegment;
    }

    public long getWriteOffset() {
        return (long)this.numBlocksWritten * (long)this.segmentSize + (long)this.getCurrentPositionInSegment();
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current, int posInSegment) throws IOException {
        if (current != null) {
            this.writeSegment(current, posInSegment);
        }
        return this.writer.getNextReturnedBlock();
    }

    private void writeSegment(MemorySegment segment, int writePosition) throws IOException {
        this.writer.writeBlock(segment);
        ++this.numBlocksWritten;
        this.bytesInLatestSegment = writePosition;
    }
}

