/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;
import org.apache.flink.runtime.io.network.buffer.Buffer;

final class BufferReadRequest
implements ReadRequest {
    private final AsynchronousFileIOChannel<Buffer, ReadRequest> channel;
    private final Buffer buffer;
    private final AtomicBoolean hasReachedEndOfFile;

    protected BufferReadRequest(AsynchronousFileIOChannel<Buffer, ReadRequest> targetChannel, Buffer buffer, AtomicBoolean hasReachedEndOfFile) {
        this.channel = targetChannel;
        this.buffer = buffer;
        this.hasReachedEndOfFile = hasReachedEndOfFile;
    }

    @Override
    public void read() throws IOException {
        FileChannel fileChannel = this.channel.fileChannel;
        if (fileChannel.size() - fileChannel.position() > 0L) {
            ByteBuffer header = ByteBuffer.allocateDirect(8);
            fileChannel.read(header);
            header.flip();
            boolean isBuffer = header.getInt() == 1;
            int size = header.getInt();
            if (size > this.buffer.getMemorySegment().size()) {
                throw new IllegalStateException("Buffer is too small for data: " + this.buffer.getMemorySegment().size() + " bytes available, but " + size + " needed. This is most likely due to an serialized event, which is larger than the buffer size.");
            }
            this.buffer.setSize(size);
            fileChannel.read(this.buffer.getNioBuffer());
            if (!isBuffer) {
                this.buffer.tagAsEvent();
            }
            this.hasReachedEndOfFile.set(fileChannel.size() - fileChannel.position() == 0L);
        } else {
            this.hasReachedEndOfFile.set(true);
        }
    }

    @Override
    public void requestDone(IOException error) {
        this.channel.handleProcessedBuffer(this.buffer, error);
    }
}

