/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.ArrayDeque;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.util.event.NotificationListener;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelinedSubpartition
extends ResultSubpartition {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinedSubpartition.class);
    private boolean isFinished;
    private boolean isReleased;
    private NotificationListener registeredListener;
    private PipelinedSubpartitionView readView;
    final ArrayDeque<Buffer> buffers = new ArrayDeque();

    PipelinedSubpartition(int index, ResultPartition parent) {
        super(index, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Buffer buffer) {
        NotificationListener listener;
        Preconditions.checkNotNull(buffer);
        ArrayDeque<Buffer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.isReleased || this.isFinished) {
                return false;
            }
            this.buffers.add(buffer);
            this.updateStatistics(buffer);
            listener = this.registeredListener;
            this.registeredListener = null;
        }
        if (listener != null) {
            listener.onNotification();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        NotificationListener listener;
        ArrayDeque<Buffer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.isReleased || this.isFinished) {
                return;
            }
            Buffer buffer = EventSerializer.toBuffer(EndOfPartitionEvent.INSTANCE);
            this.buffers.add(buffer);
            this.updateStatistics(buffer);
            this.isFinished = true;
            LOG.debug("Finished {}.", (Object)this);
            listener = this.registeredListener;
            this.registeredListener = null;
        }
        if (listener != null) {
            listener.onNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        NotificationListener listener;
        PipelinedSubpartitionView view;
        ArrayDeque<Buffer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            Buffer buffer;
            if (this.isReleased) {
                return;
            }
            while ((buffer = this.buffers.poll()) != null) {
                if (buffer.isRecycled()) continue;
                buffer.recycle();
            }
            view = this.readView;
            this.readView = null;
            listener = this.registeredListener;
            this.registeredListener = null;
            this.isReleased = true;
            LOG.debug("Released {}.", (Object)this);
        }
        if (view != null) {
            view.releaseAllResources();
        }
        if (listener != null) {
            listener.onNotification();
        }
    }

    @Override
    public int releaseMemory() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PipelinedSubpartitionView createReadView(BufferProvider bufferProvider) {
        ArrayDeque<Buffer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.readView != null) {
                throw new IllegalStateException("Subpartition " + this.index + " of " + this.parent.getPartitionId() + " is being or already has been " + "consumed, but pipelined subpartitions can only be consumed once.");
            }
            this.readView = new PipelinedSubpartitionView(this);
            LOG.debug("Created read view for subpartition {} of partition {}.", (Object)this.index, (Object)this.parent.getPartitionId());
            return this.readView;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayDeque<Buffer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            return String.format("PipelinedSubpartition [number of buffers: %d (%d bytes), finished? %s, read view? %s]", this.getTotalNumberOfBuffers(), this.getTotalNumberOfBytes(), this.isFinished, this.readView != null);
        }
    }

    boolean registerListener(NotificationListener listener) {
        ArrayDeque<Buffer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (!this.buffers.isEmpty() || this.isReleased) {
                return false;
            }
            if (this.registeredListener == null) {
                this.registeredListener = listener;
                return true;
            }
            throw new IllegalStateException("Already registered listener.");
        }
    }
}

