/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;

public abstract class ResultSubpartition {
    protected final int index;
    protected final ResultPartition parent;
    private int totalNumberOfBuffers;
    private long totalNumberOfBytes;

    public ResultSubpartition(int index, ResultPartition parent) {
        this.index = index;
        this.parent = parent;
    }

    protected void updateStatistics(Buffer buffer) {
        ++this.totalNumberOfBuffers;
        this.totalNumberOfBytes += (long)buffer.getSize();
    }

    protected int getTotalNumberOfBuffers() {
        return this.totalNumberOfBuffers;
    }

    protected long getTotalNumberOfBytes() {
        return this.totalNumberOfBytes;
    }

    protected void onConsumedSubpartition() {
        this.parent.onConsumedSubpartition(this.index);
    }

    protected Throwable getFailureCause() {
        return this.parent.getFailureCause();
    }

    public abstract boolean add(Buffer var1) throws IOException;

    public abstract void finish() throws IOException;

    public abstract void release() throws IOException;

    public abstract ResultSubpartitionView createReadView(BufferProvider var1) throws IOException;

    abstract int releaseMemory() throws IOException;
}

