/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.runtime.event.task.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.util.event.EventListener;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.com.google.common.collect.Maps;
import org.apache.flink.shaded.com.google.common.collect.Sets;

public class UnionInputGate
implements InputGate {
    private final InputGate[] inputGates;
    private final Set<InputGate> inputGatesWithRemainingData;
    private final InputGateListener inputGateListener;
    private final int totalNumberOfInputChannels;
    private final Map<InputGate, Integer> inputGateToIndexOffsetMap;
    private boolean requestedPartitionsFlag;

    public UnionInputGate(InputGate ... inputGates) {
        this.inputGates = Preconditions.checkNotNull(inputGates);
        Preconditions.checkArgument(inputGates.length > 1, "Union input gate should union at least two input gates.");
        this.inputGateToIndexOffsetMap = Maps.newHashMapWithExpectedSize(inputGates.length);
        this.inputGatesWithRemainingData = Sets.newHashSetWithExpectedSize(inputGates.length);
        int currentNumberOfInputChannels = 0;
        for (InputGate inputGate : inputGates) {
            this.inputGateToIndexOffsetMap.put(Preconditions.checkNotNull(inputGate), currentNumberOfInputChannels);
            this.inputGatesWithRemainingData.add(inputGate);
            currentNumberOfInputChannels += inputGate.getNumberOfInputChannels();
        }
        this.totalNumberOfInputChannels = currentNumberOfInputChannels;
        this.inputGateListener = new InputGateListener(inputGates, this);
    }

    @Override
    public int getNumberOfInputChannels() {
        return this.totalNumberOfInputChannels;
    }

    @Override
    public boolean isFinished() {
        for (InputGate inputGate : this.inputGates) {
            if (inputGate.isFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void requestPartitions() throws IOException, InterruptedException {
        if (!this.requestedPartitionsFlag) {
            for (InputGate inputGate : this.inputGates) {
                inputGate.requestPartitions();
            }
            this.requestedPartitionsFlag = true;
        }
    }

    @Override
    public BufferOrEvent getNextBufferOrEvent() throws IOException, InterruptedException {
        if (this.inputGatesWithRemainingData.isEmpty()) {
            return null;
        }
        this.requestPartitions();
        InputGate inputGate = this.inputGateListener.getNextInputGateToReadFrom();
        BufferOrEvent bufferOrEvent = inputGate.getNextBufferOrEvent();
        if (bufferOrEvent.isEvent() && bufferOrEvent.getEvent().getClass() == EndOfPartitionEvent.class && inputGate.isFinished() && !this.inputGatesWithRemainingData.remove(inputGate)) {
            throw new IllegalStateException("Couldn't find input gate in set of remaining input gates.");
        }
        int channelIndexOffset = this.inputGateToIndexOffsetMap.get(inputGate);
        bufferOrEvent.setChannelIndex(channelIndexOffset + bufferOrEvent.getChannelIndex());
        return bufferOrEvent;
    }

    @Override
    public void sendTaskEvent(TaskEvent event) throws IOException {
        for (InputGate inputGate : this.inputGates) {
            inputGate.sendTaskEvent(event);
        }
    }

    @Override
    public void registerListener(EventListener<InputGate> listener) {
        this.inputGateListener.registerListener(listener);
    }

    private static class InputGateListener
    implements EventListener<InputGate> {
        private final UnionInputGate unionInputGate;
        private final BlockingQueue<InputGate> inputGatesWithData = new LinkedBlockingQueue<InputGate>();
        private final List<EventListener<InputGate>> registeredListeners = new CopyOnWriteArrayList<EventListener<InputGate>>();

        public InputGateListener(InputGate[] inputGates, UnionInputGate unionInputGate) {
            for (InputGate inputGate : inputGates) {
                inputGate.registerListener(this);
            }
            this.unionInputGate = unionInputGate;
        }

        @Override
        public void onEvent(InputGate inputGate) {
            this.inputGatesWithData.add(inputGate);
            for (int i = 0; i < this.registeredListeners.size(); ++i) {
                this.registeredListeners.get(i).onEvent(this.unionInputGate);
            }
        }

        InputGate getNextInputGateToReadFrom() throws InterruptedException {
            return this.inputGatesWithData.take();
        }

        public void registerListener(EventListener<InputGate> listener) {
            this.registeredListeners.add(Preconditions.checkNotNull(listener));
        }
    }
}

