/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import akka.actor.ActorNotFound;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Props$;
import com.typesafe.config.Config;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.StreamingMode;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManagerCliOptions;
import org.apache.flink.runtime.jobmanager.JobManagerMode;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.jobmanager.accumulators.AccumulatorManager;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.web.WebInfoServer;
import org.apache.flink.runtime.process.ProcessReaper;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.jboss.netty.channel.ChannelException;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.Tuple8;
import scala.Tuple9;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scopt.OptionParser;
import scopt.Read$;

public final class JobManager$ {
    public static final JobManager$ MODULE$;
    private final Logger LOG;
    private final int STARTUP_FAILURE_RETURN_CODE;
    private final int RUNTIME_FAILURE_RETURN_CODE;
    private final String JOB_MANAGER_NAME;
    private final String ARCHIVE_NAME;

    static {
        new JobManager$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public int STARTUP_FAILURE_RETURN_CODE() {
        return this.STARTUP_FAILURE_RETURN_CODE;
    }

    public int RUNTIME_FAILURE_RETURN_CODE() {
        return this.RUNTIME_FAILURE_RETURN_CODE;
    }

    public String JOB_MANAGER_NAME() {
        return this.JOB_MANAGER_NAME;
    }

    public String ARCHIVE_NAME() {
        return this.ARCHIVE_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        Tuple5 tuple5;
        EnvironmentInformation.logEnvironmentInfo(this.LOG().logger(), "JobManager", args);
        EnvironmentInformation.checkJavaVersion();
        Tuple5 tuple52 = this.liftedTree1$1(args);
        if (tuple52 == null) throw new MatchError((Object)tuple52);
        Configuration configuration = (Configuration)tuple52._1();
        JobManagerMode executionMode = (JobManagerMode)((Object)tuple52._2());
        StreamingMode streamingMode = (StreamingMode)((Object)tuple52._3());
        String listeningHost = (String)tuple52._4();
        int listeningPort = BoxesRunTime.unboxToInt((Object)tuple52._5());
        if (configuration == null) throw new MatchError((Object)tuple52);
        Configuration configuration2 = configuration;
        if (executionMode == null) throw new MatchError((Object)tuple52);
        JobManagerMode jobManagerMode = executionMode;
        if (streamingMode == null) throw new MatchError((Object)tuple52);
        StreamingMode streamingMode2 = streamingMode;
        if (listeningHost == null) throw new MatchError((Object)tuple52);
        String string = listeningHost;
        int n = listeningPort;
        Tuple5 tuple53 = tuple5 = new Tuple5((Object)configuration2, (Object)jobManagerMode, (Object)streamingMode2, (Object)string, (Object)BoxesRunTime.boxToInteger((int)n));
        Configuration configuration3 = (Configuration)tuple53._1();
        JobManagerMode executionMode2 = (JobManagerMode)((Object)tuple53._2());
        StreamingMode streamingMode3 = (StreamingMode)((Object)tuple53._3());
        String listeningHost2 = (String)tuple53._4();
        int listeningPort2 = BoxesRunTime.unboxToInt((Object)tuple53._5());
        if (listeningHost2 == null) {
            String message = "Config parameter 'jobmanager.rpc.address' is missing (hostname/address to bind JobManager to).";
            this.LOG().error((Function0)new Serializable(message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
        if (listeningPort2 <= 0 || listeningPort2 >= 65536) {
            String message = "Config parameter 'jobmanager.rpc.port' is invalid, it must be great than 0 and less than 65536.";
            this.LOG().error((Function0)new Serializable(message){
                public static final long serialVersionUID = 0L;
                private final String message$2;

                public final String apply() {
                    return this.message$2;
                }
                {
                    this.message$2 = message$2;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
        try {
            if (SecurityUtils.isSecurityEnabled()) {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Security is enabled. Starting secure JobManager.";
                    }
                });
                SecurityUtils.runSecured(new SecurityUtils.FlinkSecuredRunner<BoxedUnit>(configuration3, executionMode2, streamingMode3, listeningHost2, listeningPort2){
                    private final Configuration configuration$1;
                    private final JobManagerMode executionMode$1;
                    private final StreamingMode streamingMode$1;
                    private final String listeningHost$1;
                    private final int listeningPort$1;

                    public void run() {
                        JobManager$.MODULE$.runJobManager(this.configuration$1, this.executionMode$1, this.streamingMode$1, this.listeningHost$1, this.listeningPort$1);
                    }
                    {
                        this.configuration$1 = configuration$1;
                        this.executionMode$1 = executionMode$1;
                        this.streamingMode$1 = streamingMode$1;
                        this.listeningHost$1 = listeningHost$1;
                        this.listeningPort$1 = listeningPort$1;
                    }
                });
                return;
            } else {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Security is not enabled. Starting non-authenticated JobManager.";
                    }
                });
                this.runJobManager(configuration3, executionMode2, streamingMode3, listeningHost2, listeningPort2);
            }
            return;
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Failed to run JobManager.";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$8;

                public final Throwable apply() {
                    return this.t$8;
                }
                {
                    this.t$8 = t$8;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public void runJobManager(Configuration configuration, JobManagerMode executionMode, StreamingMode streamingMode, String listeningAddress, int listeningPort) {
        Tuple2<ActorRef, ActorRef> tuple2;
        block11: {
            ActorSystem jobManagerSystem;
            block12: {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting JobManager";
                    }
                });
                this.LOG().info((Function0)new Serializable(listeningAddress, listeningPort){
                    public static final long serialVersionUID = 0L;
                    private final String listeningAddress$1;
                    private final int listeningPort$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting JobManager actor system at ", ":", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listeningAddress$1, BoxesRunTime.boxToInteger((int)this.listeningPort$2)}));
                    }
                    {
                        this.listeningAddress$1 = listeningAddress$1;
                        this.listeningPort$2 = listeningPort$2;
                    }
                });
                Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(configuration, (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)listeningAddress, (Object)BoxesRunTime.boxToInteger((int)listeningPort))));
                if (this.LOG().isDebugEnabled()) {
                    this.LOG().debug((Function0)new Serializable(akkaConfig){
                        public static final long serialVersionUID = 0L;
                        private final Config akkaConfig$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Using akka configuration\n ").append((Object)this.akkaConfig$1).toString();
                        }
                        {
                            this.akkaConfig$1 = akkaConfig$1;
                        }
                    });
                }
                jobManagerSystem = AkkaUtils$.MODULE$.createActorSystem(akkaConfig);
                try {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple22;
                    this.LOG().info((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Starting JobManager actor";
                        }
                    });
                    tuple2 = this.startJobManagerActors(configuration, jobManagerSystem, streamingMode);
                    if (tuple2 == null) break block11;
                    ActorRef jobManager = (ActorRef)tuple2._1();
                    ActorRef archiver = (ActorRef)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)jobManager, (Object)archiver);
                    ActorRef jobManager2 = (ActorRef)tuple23._1();
                    ActorRef archiver2 = (ActorRef)tuple23._2();
                    this.LOG().debug((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Starting JobManager process reaper";
                        }
                    });
                    jobManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobManager2, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "JobManager_Process_Reaper");
                    JobManagerMode jobManagerMode = executionMode;
                    JobManagerMode jobManagerMode2 = JobManagerMode.LOCAL;
                    if (!(jobManagerMode != null ? !((Object)((Object)jobManagerMode)).equals((Object)jobManagerMode2) : jobManagerMode2 != null)) {
                        this.LOG().info((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Starting embedded TaskManager for JobManager's LOCAL execution mode";
                            }
                        });
                        ActorRef taskManagerActor = TaskManager$.MODULE$.startTaskManagerComponentsAndActor(configuration, jobManagerSystem, listeningAddress, (Option<String>)new Some((Object)TaskManager$.MODULE$.TASK_MANAGER_NAME()), (Option<String>)new Some((Object)jobManager2.path().toString()), true, streamingMode, TaskManager.class);
                        this.LOG().debug((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Starting TaskManager process reaper";
                            }
                        });
                        boxedUnit = jobManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerActor, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "TaskManager_Process_Reaper");
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    if (configuration.getInteger("jobmanager.web.port", 0) == -1) break block12;
                    this.LOG().info((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Starting JobManger web frontend";
                        }
                    });
                    WebInfoServer webServer = new WebInfoServer(configuration, jobManager2, archiver2);
                    webServer.start();
                }
                catch (Throwable throwable) {
                    this.LOG().error((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Error while starting up JobManager";
                        }
                    }, (Function0)new Serializable(throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable t$9;

                        public final Throwable apply() {
                            return this.t$9;
                        }
                        {
                            this.t$9 = t$9;
                        }
                    });
                    try {
                        void var7_7;
                        var7_7.shutdown();
                    }
                    catch (Throwable throwable2) {
                        this.LOG().warn((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Could not cleanly shut down actor system";
                            }
                        }, (Function0)new Serializable(throwable2){
                            public static final long serialVersionUID = 0L;
                            private final Throwable tt$2;

                            public final Throwable apply() {
                                return this.tt$2;
                            }
                            {
                                this.tt$2 = tt$2;
                            }
                        });
                    }
                    throw throwable;
                }
            }
            jobManagerSystem.awaitTermination();
            return;
        }
        throw new MatchError(tuple2);
        catch (Throwable throwable) {
            Throwable cause;
            if (throwable instanceof ChannelException && (cause = throwable.getCause()) != null && throwable.getCause() instanceof BindException) {
                String address = new StringBuilder().append((Object)listeningAddress).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)listeningPort)).toString();
                throw new Exception(new StringBuilder().append((Object)"Unable to create JobManager at address ").append((Object)address).append((Object)" - ").append((Object)cause.getMessage()).toString(), throwable);
            }
            throw new Exception("Could not create JobManager actor system", throwable);
        }
    }

    public Tuple5<Configuration, JobManagerMode, StreamingMode, String, Object> parseArgs(String[] args) {
        OptionParser<JobManagerCliOptions> parser = new OptionParser<JobManagerCliOptions>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Flink JobManager"}));
                this.opt("configDir", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                        conf.setConfigDir(arg);
                        return conf;
                    }
                }).text("The configuration directory.");
                this.opt("executionMode", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                        conf.setJobManagerMode(arg);
                        return conf;
                    }
                }).text("The execution mode of the JobManager (CLUSTER / LOCAL)");
                this.opt("streamingMode", Read$.MODULE$.stringRead()).optional().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                        conf.setStreamingMode(arg);
                        return conf;
                    }
                }).text("The streaming mode of the JobManager (STREAMING / BATCH)");
            }
        };
        JobManagerCliOptions config = (JobManagerCliOptions)parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new JobManagerCliOptions()).getOrElse((Function0)new Serializable(args, (OptionParser)parser){
            public static final long serialVersionUID = 0L;
            private final String[] args$2;
            private final OptionParser parser$1;

            public final Nothing$ apply() {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid command line agruments: ", ". Usage: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.args$2).mkString(" "), this.parser$1.usage()})));
            }
            {
                this.args$2 = args$2;
                this.parser$1 = parser$1;
            }
        });
        String configDir = config.getConfigDir();
        if (configDir == null) {
            throw new Exception("Missing parameter '--configDir'");
        }
        if (config.getJobManagerMode() == null) {
            throw new Exception("Missing parameter '--executionMode'");
        }
        this.LOG().info((Function0)new Serializable(configDir){
            public static final long serialVersionUID = 0L;
            private final String configDir$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Loading configuration from ").append((Object)this.configDir$1).toString();
            }
            {
                this.configDir$1 = configDir$1;
            }
        });
        GlobalConfiguration.loadConfiguration((String)configDir);
        Configuration configuration = GlobalConfiguration.getConfiguration();
        if (new File(configDir).isDirectory()) {
            configuration.setString("flink.base.dir.path", new StringBuilder().append((Object)configDir).append((Object)"/..").toString());
        }
        String hostname = configuration.getString("jobmanager.rpc.address", null);
        int port = configuration.getInteger("jobmanager.rpc.port", 6123);
        return new Tuple5((Object)configuration, (Object)config.getJobManagerMode(), (Object)config.getStreamingMode(), (Object)hostname, (Object)BoxesRunTime.boxToInteger((int)port));
    }

    /*
     * WARNING - void declaration
     */
    public Tuple9<InstanceManager, Scheduler, BlobLibraryCacheManager, Props, AccumulatorManager, Object, Object, FiniteDuration, Object> createJobManagerComponents(Configuration configuration) {
        long delayBetweenRetries;
        FiniteDuration timeout = AkkaUtils$.MODULE$.getTimeout(configuration);
        int archiveCount = configuration.getInteger("jobmanager.web.history", 5);
        long cleanupInterval = configuration.getLong("library-cache-manager.cleanup.interval", 3600L) * 1000L;
        int executionRetries = configuration.getInteger("execution-retries.default", 0);
        String pauseString = configuration.getString("akka.watch.heartbeat.pause", ConfigConstants.DEFAULT_AKKA_ASK_TIMEOUT);
        String delayString = configuration.getString("execution-retries.delay", pauseString);
        try {
            delayBetweenRetries = Duration$.MODULE$.apply(delayString).toMillis();
        }
        catch (NumberFormatException numberFormatException) {
            void var7_6;
            throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config value for ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"execution-retries.delay"}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Value must be a valid duration (such as 100 milli or 1 min)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var7_6}))).toString());
        }
        Props archiveProps = Props$.MODULE$.apply(MemoryArchivist.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)archiveCount)}));
        AccumulatorManager accumulatorManager = new AccumulatorManager(Math.min(1, archiveCount));
        BlobServer blobServer = null;
        InstanceManager instanceManager = null;
        Scheduler scheduler = null;
        BlobLibraryCacheManager libraryCacheManager = null;
        try {
            blobServer = new BlobServer(configuration);
            instanceManager = new InstanceManager();
            scheduler = new Scheduler();
            libraryCacheManager = new BlobLibraryCacheManager(blobServer, cleanupInterval);
            instanceManager.addInstanceListener(scheduler);
        }
        catch (Throwable throwable) {
            void var13_11;
            void var14_12;
            void var15_13;
            void var16_14;
            if (var16_14 != null) {
                var16_14.shutdown();
            }
            if (var15_13 != null) {
                var15_13.shutdown();
            }
            if (var14_12 != null) {
                var14_12.shutdown();
            }
            if (var13_11 != null) {
                var13_11.shutdown();
            }
            throw throwable;
        }
        return new Tuple9((Object)instanceManager, (Object)scheduler, (Object)libraryCacheManager, (Object)archiveProps, (Object)accumulatorManager, (Object)BoxesRunTime.boxToInteger((int)executionRetries), (Object)BoxesRunTime.boxToLong((long)delayBetweenRetries), (Object)timeout, (Object)BoxesRunTime.boxToInteger((int)archiveCount));
    }

    public Tuple2<ActorRef, ActorRef> startJobManagerActors(Configuration configuration, ActorSystem actorSystem, StreamingMode streamingMode) {
        return this.startJobManagerActors(configuration, actorSystem, (Option<String>)new Some((Object)this.JOB_MANAGER_NAME()), (Option<String>)new Some((Object)this.ARCHIVE_NAME()), streamingMode);
    }

    public Tuple2<ActorRef, ActorRef> startJobManagerActors(Configuration configuration, ActorSystem actorSystem, Option<String> jobMangerActorName, Option<String> archiverActorName, StreamingMode streamingMode) {
        Tuple9<InstanceManager, Scheduler, BlobLibraryCacheManager, Props, AccumulatorManager, Object, Object, FiniteDuration, Object> tuple9;
        block2: {
            Option<String> option;
            block5: {
                Option<String> option2;
                block8: {
                    ActorRef actorRef;
                    ActorRef archiver;
                    block7: {
                        Props jobManagerProps;
                        block6: {
                            ActorRef actorRef2;
                            FiniteDuration timeout;
                            long delayBetweenRetries;
                            int executionRetries;
                            AccumulatorManager accumulatorManager;
                            BlobLibraryCacheManager libraryCacheManager;
                            Scheduler scheduler;
                            InstanceManager instanceManager;
                            block4: {
                                Props archiveProps;
                                block3: {
                                    Tuple8 tuple8;
                                    tuple9 = this.createJobManagerComponents(configuration);
                                    if (tuple9 == null) break block2;
                                    InstanceManager instanceManager2 = (InstanceManager)tuple9._1();
                                    Scheduler scheduler2 = (Scheduler)tuple9._2();
                                    BlobLibraryCacheManager libraryCacheManager2 = (BlobLibraryCacheManager)tuple9._3();
                                    Props archiveProps2 = (Props)tuple9._4();
                                    AccumulatorManager accumulatorManager2 = (AccumulatorManager)tuple9._5();
                                    int executionRetries2 = BoxesRunTime.unboxToInt((Object)tuple9._6());
                                    long delayBetweenRetries2 = BoxesRunTime.unboxToLong((Object)tuple9._7());
                                    FiniteDuration timeout2 = (FiniteDuration)tuple9._8();
                                    Tuple8 tuple82 = tuple8 = new Tuple8((Object)instanceManager2, (Object)scheduler2, (Object)libraryCacheManager2, (Object)archiveProps2, (Object)accumulatorManager2, (Object)BoxesRunTime.boxToInteger((int)executionRetries2), (Object)BoxesRunTime.boxToLong((long)delayBetweenRetries2), (Object)timeout2);
                                    instanceManager = (InstanceManager)tuple82._1();
                                    scheduler = (Scheduler)tuple82._2();
                                    libraryCacheManager = (BlobLibraryCacheManager)tuple82._3();
                                    archiveProps = (Props)tuple82._4();
                                    accumulatorManager = (AccumulatorManager)tuple82._5();
                                    executionRetries = BoxesRunTime.unboxToInt((Object)tuple82._6());
                                    delayBetweenRetries = BoxesRunTime.unboxToLong((Object)tuple82._7());
                                    timeout = (FiniteDuration)tuple82._8();
                                    option = archiverActorName;
                                    if (!(option instanceof Some)) break block3;
                                    Some some = (Some)option;
                                    String actorName = (String)some.x();
                                    actorRef2 = actorSystem.actorOf(archiveProps, actorName);
                                    break block4;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<String> option3 = option;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                                actorRef2 = actorSystem.actorOf(archiveProps);
                            }
                            archiver = actorRef2;
                            jobManagerProps = Props$.MODULE$.apply(JobManager.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configuration, instanceManager, scheduler, libraryCacheManager, archiver, accumulatorManager, BoxesRunTime.boxToInteger((int)executionRetries), BoxesRunTime.boxToLong((long)delayBetweenRetries), timeout, streamingMode}));
                            option2 = jobMangerActorName;
                            if (!(option2 instanceof Some)) break block6;
                            Some some = (Some)option2;
                            String actorName = (String)some.x();
                            actorRef = actorSystem.actorOf(jobManagerProps, actorName);
                            break block7;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<String> option4 = option2;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block8;
                        actorRef = actorSystem.actorOf(jobManagerProps);
                    }
                    ActorRef jobManager = actorRef;
                    return new Tuple2((Object)jobManager, (Object)archiver);
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        throw new MatchError(tuple9);
    }

    public ActorRef startActor(Props props, ActorSystem actorSystem) {
        return actorSystem.actorOf(props, this.JOB_MANAGER_NAME());
    }

    public String getRemoteJobManagerAkkaURL(InetSocketAddress address) {
        String hostPort = new StringBuilder().append((Object)address.getAddress().getHostAddress()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)address.getPort())).toString();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.tcp://flink@", "/user/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostPort, this.JOB_MANAGER_NAME()}));
    }

    public String getLocalJobManagerAkkaURL() {
        return new StringBuilder().append((Object)"akka://flink/user/").append((Object)this.JOB_MANAGER_NAME()).toString();
    }

    public Future<ActorRef> getJobManagerRemoteReferenceFuture(InetSocketAddress address, ActorSystem system, FiniteDuration timeout) {
        return AkkaUtils$.MODULE$.getReference(this.getRemoteJobManagerAkkaURL(address), system, timeout);
    }

    public ActorRef getJobManagerRemoteReference(String jobManagerUrl, ActorSystem system, FiniteDuration timeout) throws IOException {
        try {
            Future<ActorRef> future = AkkaUtils$.MODULE$.getReference(jobManagerUrl, system, timeout);
            return (ActorRef)Await$.MODULE$.result(future, (Duration)timeout);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ActorNotFound ? true : throwable2 instanceof TimeoutException;
            if (bl) {
                throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JobManager at ", " not reachable. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobManagerUrl}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please make sure that the JobManager is running and its port is reachable."})).s((Seq)Nil$.MODULE$)).toString(), throwable2);
            }
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                throw new IOException(new StringBuilder().append((Object)"Could not connect to JobManager at ").append((Object)jobManagerUrl).toString(), iOException);
            }
            throw throwable;
        }
    }

    public ActorRef getJobManagerRemoteReference(InetSocketAddress address, ActorSystem system, FiniteDuration timeout) throws IOException {
        String jmAddress = this.getRemoteJobManagerAkkaURL(address);
        return this.getJobManagerRemoteReference(jmAddress, system, timeout);
    }

    public ActorRef getJobManagerRemoteReference(InetSocketAddress address, ActorSystem system, Configuration config) throws IOException {
        FiniteDuration timeout = AkkaUtils$.MODULE$.getLookupTimeout(config);
        return this.getJobManagerRemoteReference(address, system, timeout);
    }

    private final Tuple5 liftedTree1$1(String[] args$1) {
        Tuple5<Configuration, JobManagerMode, StreamingMode, String, Object> tuple5;
        try {
            tuple5 = this.parseArgs(args$1);
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$7;

                public final String apply() {
                    return this.t$7.getMessage();
                }
                {
                    this.t$7 = t$7;
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$7;

                public final Throwable apply() {
                    return this.t$7;
                }
                {
                    this.t$7 = t$7;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            tuple5 = null;
        }
        return tuple5;
    }

    private JobManager$() {
        MODULE$ = this;
        this.LOG = Logger$.MODULE$.apply(JobManager.class);
        this.STARTUP_FAILURE_RETURN_CODE = 1;
        this.RUNTIME_FAILURE_RETURN_CODE = 2;
        this.JOB_MANAGER_NAME = "jobmanager";
        this.ARCHIVE_NAME = "archive";
    }
}

