/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.util.StringUtils;

public class JsonFactory {
    public static String toJson(ExecutionVertex vertex) {
        StringBuilder json = new StringBuilder("");
        json.append("{");
        json.append("\"vertexid\": \"" + (Object)((Object)vertex.getCurrentExecutionAttempt().getAttemptId()) + "\",");
        json.append("\"vertexname\": \"" + StringUtils.escapeHtml((String)vertex.getSimpleName()) + "\",");
        json.append("\"vertexstatus\": \"" + (Object)((Object)vertex.getExecutionState()) + "\",");
        InstanceConnectionInfo location = vertex.getCurrentAssignedResourceLocation();
        String instanceName = location == null ? "(null)" : location.getFQDNHostname();
        json.append("\"vertexinstancename\": \"" + instanceName + "\"");
        json.append("}");
        return json.toString();
    }

    public static String toJson(ExecutionJobVertex jobVertex) {
        StringBuilder json = new StringBuilder("");
        json.append("{");
        json.append("\"groupvertexid\": \"" + (Object)((Object)jobVertex.getJobVertexId()) + "\",");
        json.append("\"groupvertexname\": \"" + StringUtils.escapeHtml((String)jobVertex.getJobVertex().getName()) + "\",");
        json.append("\"numberofgroupmembers\": " + jobVertex.getParallelism() + ",");
        json.append("\"groupmembers\": [");
        HashMap<ExecutionState, Integer> stateCounts = new HashMap<ExecutionState, Integer>();
        for (ExecutionState state : ExecutionState.values()) {
            stateCounts.put(state, 0);
        }
        ExecutionVertex[] vertices = jobVertex.getTaskVertices();
        for (int j = 0; j < vertices.length; ++j) {
            ExecutionVertex vertex = vertices[j];
            json.append(JsonFactory.toJson(vertex));
            if (j != vertices.length - 1) {
                json.append(",");
            }
            int count = (Integer)stateCounts.get((Object)vertex.getExecutionState()) + 1;
            stateCounts.put(vertex.getExecutionState(), count);
        }
        json.append("],");
        json.append("\"backwardEdges\": [");
        List<IntermediateResult> inputs = jobVertex.getInputs();
        for (int inputNumber = 0; inputNumber < inputs.size(); ++inputNumber) {
            ExecutionJobVertex input = inputs.get(inputNumber).getProducer();
            json.append("{");
            json.append("\"groupvertexid\": \"" + (Object)((Object)input.getJobVertexId()) + "\",");
            json.append("\"groupvertexname\": \"" + StringUtils.escapeHtml((String)jobVertex.getJobVertex().getName()) + "\"");
            json.append("}");
            if (inputNumber == inputs.size() - 1) continue;
            json.append(",");
        }
        json.append("]");
        for (Map.Entry stateCount : stateCounts.entrySet()) {
            json.append(",\"" + stateCount.getKey() + "\": " + stateCount.getValue());
        }
        json.append("}");
        return json.toString();
    }
}

