/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.web;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.messages.TaskManagerMessages;
import org.apache.flink.util.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class SetupInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 3704963598772630435L;
    private static final Logger LOG = LoggerFactory.getLogger(SetupInfoServlet.class);
    private final Configuration configuration;
    private final ActorRef jobmanager;
    private final FiniteDuration timeout;
    private static final Comparator<Instance> INSTANCE_SORTER = new Comparator<Instance>(){

        @Override
        public int compare(Instance o1, Instance o2) {
            return o1.getInstanceConnectionInfo().compareTo(o2.getInstanceConnectionInfo());
        }
    };

    public SetupInfoServlet(Configuration conf, ActorRef jm, FiniteDuration timeout) {
        this.configuration = conf;
        this.jobmanager = jm;
        this.timeout = timeout;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(200);
        resp.setContentType("application/json");
        if ("globalC".equals(req.getParameter("get"))) {
            this.writeGlobalConfiguration(resp);
        } else if ("taskmanagers".equals(req.getParameter("get"))) {
            this.writeTaskmanagers(resp);
        } else if ("stackTrace".equals(req.getParameter("get"))) {
            String instanceId = req.getParameter("instanceID");
            this.writeStackTraceOfTaskManager(instanceId, resp);
        }
    }

    private void writeGlobalConfiguration(HttpServletResponse resp) throws IOException {
        Set keys = this.configuration.keySet();
        ArrayList list = new ArrayList(keys);
        Collections.sort(list);
        JSONObject obj = new JSONObject();
        for (String k : list) {
            try {
                obj.put(k, (Object)this.configuration.getString(k, ""));
            }
            catch (JSONException e) {
                LOG.warn("Json object creation failed", (Throwable)e);
            }
        }
        PrintWriter w = resp.getWriter();
        w.write(obj.toString());
    }

    private void writeTaskmanagers(HttpServletResponse resp) throws IOException {
        Future response = Patterns.ask((ActorRef)this.jobmanager, (Object)JobManagerMessages.getRequestRegisteredTaskManagers(), (Timeout)new Timeout(this.timeout));
        Object obj = null;
        try {
            obj = Await.result((Awaitable)response, (Duration)this.timeout);
        }
        catch (Exception ex) {
            throw new IOException("Could not retrieve all registered task managers from the job manager.", ex);
        }
        if (!(obj instanceof JobManagerMessages.RegisteredTaskManagers)) {
            throw new RuntimeException("RequestRegisteredTaskManagers should return a response of type RegisteredTaskManagers. Instead the respone is of type " + obj.getClass() + ".");
        }
        ArrayList<Instance> instances = new ArrayList<Instance>(((JobManagerMessages.RegisteredTaskManagers)obj).asJavaCollection());
        Collections.sort(instances, INSTANCE_SORTER);
        JSONObject jsonObj = new JSONObject();
        JSONArray array = new JSONArray();
        for (Instance instance : instances) {
            JSONObject objInner = new JSONObject();
            long time = new Date().getTime() - instance.getLastHeartBeat();
            try {
                objInner.put("inetAdress", (Object)instance.getInstanceConnectionInfo().getInetAdress());
                objInner.put("ipcPort", (Object)instance.getTaskManager().path().address().hostPort());
                objInner.put("dataPort", instance.getInstanceConnectionInfo().dataPort());
                objInner.put("timeSinceLastHeartbeat", time / 1000L);
                objInner.put("slotsNumber", instance.getTotalNumberOfSlots());
                objInner.put("freeSlots", instance.getNumberOfAvailableSlots());
                objInner.put("cpuCores", instance.getResources().getNumberOfCPUCores());
                objInner.put("physicalMemory", instance.getResources().getSizeOfPhysicalMemory() >>> 20);
                objInner.put("freeMemory", instance.getResources().getSizeOfJvmHeap() >>> 20);
                objInner.put("managedMemory", instance.getResources().getSizeOfManagedMemory() >>> 20);
                objInner.put("instanceID", (Object)instance.getId());
                byte[] report = instance.getLastMetricsReport();
                if (report != null) {
                    objInner.put("metrics", (Object)new JSONObject(new String(report, "utf-8")));
                }
                array.put((Object)objInner);
            }
            catch (JSONException e) {
                LOG.warn("Json object creation failed", (Throwable)e);
            }
        }
        try {
            jsonObj.put("taskmanagers", (Object)array);
        }
        catch (JSONException e) {
            LOG.warn("Json object creation failed", (Throwable)e);
        }
        PrintWriter w = resp.getWriter();
        w.write(jsonObj.toString());
    }

    private void writeStackTraceOfTaskManager(String instanceIdStr, HttpServletResponse resp) throws IOException {
        InstanceID instanceID = new InstanceID(StringUtils.hexStringToByte((String)instanceIdStr));
        TaskManagerMessages.StackTrace message = null;
        Exception exception = null;
        Future response = Patterns.ask((ActorRef)this.jobmanager, (Object)new JobManagerMessages.RequestStackTrace(instanceID), (Timeout)new Timeout(this.timeout));
        try {
            message = (TaskManagerMessages.StackTrace)Await.result((Awaitable)response, (Duration)this.timeout);
        }
        catch (Exception ex) {
            exception = ex;
        }
        JSONObject obj = new JSONObject();
        try {
            if (message != null) {
                obj.put("stackTrace", (Object)message.stackTrace());
            } else if (exception != null) {
                obj.put("errorMessage", (Object)exception.getMessage());
            }
        }
        catch (JSONException e) {
            LOG.warn("Json object creation failed", (Throwable)e);
        }
        PrintWriter writer = resp.getWriter();
        writer.write(obj.toString());
    }
}

