/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.pattern.Patterns$;
import akka.pattern.package$;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import java.net.InetAddress;
import java.util.List;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.StreamingMode;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.client.JobClient;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.client.SerializedJobExecutionResult;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.messages.TaskManagerMessages$NotifyWhenRegisteredAtJobManager$;
import org.apache.flink.runtime.minicluster.FlinkMiniCluster$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tec!B\u0001\u0003\u0003\u0003i!\u0001\u0005$mS:\\W*\u001b8j\u00072,8\u000f^3s\u0015\t\u0019A!A\u0006nS:L7\r\\;ti\u0016\u0014(BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011)\u0019!C\u0001-\u0005\tRo]3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003]\u0001\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0004\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\ta\u0012DA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\t=\u0001\u0011\t\u0011)A\u0005/\u0005\u0011Ro]3s\u0007>tg-[4ve\u0006$\u0018n\u001c8!\u0011!\u0001\u0003A!b\u0001\n\u0003\t\u0013!E:j]\u001edW-Q2u_J\u001c\u0016p\u001d;f[V\t!\u0005\u0005\u0002\u0010G%\u0011A\u0005\u0005\u0002\b\u0005>|G.Z1o\u0011!1\u0003A!A!\u0002\u0013\u0011\u0013AE:j]\u001edW-Q2u_J\u001c\u0016p\u001d;f[\u0002B\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!K\u0001\u000egR\u0014X-Y7j]\u001elu\u000eZ3\u0016\u0003)\u0002\"a\u000b\u0017\u000e\u0003\u0011I!!\f\u0003\u0003\u001bM#(/Z1nS:<Wj\u001c3f\u0011!y\u0003A!A!\u0002\u0013Q\u0013AD:ue\u0016\fW.\u001b8h\u001b>$W\r\t\u0005\u0006c\u0001!\tAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM*dg\u000e\t\u0003i\u0001i\u0011A\u0001\u0005\u0006+A\u0002\ra\u0006\u0005\u0006AA\u0002\rA\t\u0005\u0006QA\u0002\rA\u000b\u0005\u0006c\u0001!\t!\u000f\u000b\u0004giZ\u0004\"B\u000b9\u0001\u00049\u0002\"\u0002\u00119\u0001\u0004\u0011\u0003bB\u001f\u0001\u0005\u0004%\tBP\u0001\u0004\u0019>;U#A \u0011\u0005\u0001\u001bU\"A!\u000b\u0005\tS\u0011!B:mMRR\u0017B\u0001#B\u0005\u0019aunZ4fe\"1a\t\u0001Q\u0001\n}\nA\u0001T(HA!9\u0001\n\u0001b\u0001\n\u0003I\u0015\u0001\u00035pgRt\u0017-\\3\u0016\u0003)\u0003\"a\u0013)\u000e\u00031S!!\u0014(\u0002\t1\fgn\u001a\u0006\u0002\u001f\u0006!!.\u0019<b\u0013\t\tFJ\u0001\u0004TiJLgn\u001a\u0005\u0007'\u0002\u0001\u000b\u0011\u0002&\u0002\u0013!|7\u000f\u001e8b[\u0016\u0004\u0003bB+\u0001\u0005\u0004%\tAV\u0001\bi&lWm\\;u+\u00059\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003!!WO]1uS>t'B\u0001/\u0011\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003=f\u0013aBR5oSR,G)\u001e:bi&|g\u000e\u0003\u0004a\u0001\u0001\u0006IaV\u0001\ti&lWm\\;uA!9!\u0004\u0001b\u0001\n\u00031\u0002BB2\u0001A\u0003%q#\u0001\bd_:4\u0017nZ;sCRLwN\u001c\u0011\t\u000f\u0015\u0004\u0001\u0019!C\u0001M\u0006)\"n\u001c2NC:\fw-\u001a:BGR|'oU=ti\u0016lW#A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017!B1di>\u0014(\"\u00017\u0002\t\u0005\\7.Y\u0005\u0003]&\u00141\"Q2u_J\u001c\u0016p\u001d;f[\"9\u0001\u000f\u0001a\u0001\n\u0003\t\u0018!\u00076pE6\u000bg.Y4fe\u0006\u001bGo\u001c:TsN$X-\\0%KF$\"A];\u0011\u0005=\u0019\u0018B\u0001;\u0011\u0005\u0011)f.\u001b;\t\u000fY|\u0017\u0011!a\u0001O\u0006\u0019\u0001\u0010J\u0019\t\ra\u0004\u0001\u0015)\u0003h\u0003YQwNY'b]\u0006<WM]!di>\u00148+_:uK6\u0004\u0003b\u0002>\u0001\u0001\u0004%\ta_\u0001\u0010U>\u0014W*\u00198bO\u0016\u0014\u0018i\u0019;peV\tA\u0010\u0005\u0002i{&\u0011a0\u001b\u0002\t\u0003\u000e$xN\u001d*fM\"I\u0011\u0011\u0001\u0001A\u0002\u0013\u0005\u00111A\u0001\u0014U>\u0014W*\u00198bO\u0016\u0014\u0018i\u0019;pe~#S-\u001d\u000b\u0004e\u0006\u0015\u0001b\u0002<\u0000\u0003\u0003\u0005\r\u0001 \u0005\b\u0003\u0013\u0001\u0001\u0015)\u0003}\u0003AQwNY'b]\u0006<WM]!di>\u0014\b\u0005C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001\u0002\u0010\u0005ya.^7UCN\\W*\u00198bO\u0016\u00148/\u0006\u0002\u0002\u0012A\u0019q\"a\u0005\n\u0007\u0005U\u0001CA\u0002J]RD\u0001\"!\u0007\u0001A\u0003%\u0011\u0011C\u0001\u0011]VlG+Y:l\u001b\u0006t\u0017mZ3sg\u0002B\u0001B\u001e\u0001\u0002B\u0003%\u0011Q\u0004\t\b\u001f\u0005}\u00111EA\u001a\u0013\r\t\t\u0003\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b\u0005\u0015\u0012qF4\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u00055\u0002#\u0001\u0006d_2dWm\u0019;j_:LA!!\r\u0002(\tQ\u0011J\u001c3fq\u0016$7+Z9\u0011\u000b\u0005\u0015\u0012q\u0006?\t\u0013\u0005]\u0002\u00011A\u0005\u0002\u0005e\u0012a\u0006;bg.l\u0015M\\1hKJ\f5\r^8s'f\u001cH/Z7t+\t\t\u0019\u0003C\u0005\u0002>\u0001\u0001\r\u0011\"\u0001\u0002@\u0005YB/Y:l\u001b\u0006t\u0017mZ3s\u0003\u000e$xN]*zgR,Wn]0%KF$2A]A!\u0011%1\u00181HA\u0001\u0002\u0004\t\u0019\u0003\u0003\u0005\u0002F\u0001\u0001\u000b\u0015BA\u0012\u0003a!\u0018m]6NC:\fw-\u001a:BGR|'oU=ti\u0016l7\u000f\t\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0001\u0003\u0017\n\u0011\u0003^1tW6\u000bg.Y4fe\u0006\u001bGo\u001c:t+\t\t\u0019\u0004C\u0005\u0002P\u0001\u0001\r\u0011\"\u0001\u0002R\u0005)B/Y:l\u001b\u0006t\u0017mZ3s\u0003\u000e$xN]:`I\u0015\fHc\u0001:\u0002T!Ia/!\u0014\u0002\u0002\u0003\u0007\u00111\u0007\u0005\t\u0003/\u0002\u0001\u0015)\u0003\u00024\u0005\u0011B/Y:l\u001b\u0006t\u0017mZ3s\u0003\u000e$xN]:!\u0011\u001d\tY\u0006\u0001D\u0001\u0003;\nQcZ3oKJ\fG/Z\"p]\u001aLw-\u001e:bi&|g\u000eF\u0002\u0018\u0003?Ba!FA-\u0001\u00049\u0002bBA2\u0001\u0019\u0005\u0011QM\u0001\u0010gR\f'\u000f\u001e&pE6\u000bg.Y4feR\u0019A0a\u001a\t\u000f\u0005%\u0014\u0011\ra\u0001O\u000611/_:uK6Dq!!\u001c\u0001\r\u0003\ty'\u0001\tti\u0006\u0014H\u000fV1tW6\u000bg.Y4feR)A0!\u001d\u0002v!A\u00111OA6\u0001\u0004\t\t\"A\u0003j]\u0012,\u0007\u0010C\u0004\u0002j\u0005-\u0004\u0019A4\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|\u00059r-\u001a;K_\nl\u0015M\\1hKJ\f5n[1D_:4\u0017nZ\u000b\u0003\u0003{\u0002B!a \u0002\u000e6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0004d_:4\u0017n\u001a\u0006\u0005\u0003\u000f\u000bI)\u0001\u0005usB,7/\u00194f\u0015\t\tY)A\u0002d_6LA!a$\u0002\u0002\n11i\u001c8gS\u001eDq!a%\u0001\t\u0003\t)*\u0001\u000eti\u0006\u0014HOS8c\u001b\u0006t\u0017mZ3s\u0003\u000e$xN]*zgR,W\u000eF\u0001h\u0011\u001d\tI\n\u0001C\u0001\u00037\u000b\u0001dZ3u)\u0006\u001c8.T1oC\u001e,'/Q6lC\u000e{gNZ5h)\u0011\ti(!(\t\u0011\u0005M\u0014q\u0013a\u0001\u0003#Aq!!)\u0001\t\u0003\t\u0019+A\u000eti\u0006\u0014H\u000fV1tW6\u000bg.Y4fe\u0006\u001bGo\u001c:TsN$X-\u001c\u000b\u0004O\u0006\u0015\u0006\u0002CA:\u0003?\u0003\r!!\u0005\t\r\u0005%\u0006\u0001\"\u0001|\u000359W\r\u001e&pE6\u000bg.Y4fe\"9\u0011Q\u0016\u0001\u0005\u0002\u0005-\u0013aD4fiR\u000b7o['b]\u0006<WM]:\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\u0006)r-\u001a;UCN\\W*\u00198bO\u0016\u00148/Q:KCZ\fWCAA[!\u0015\t9,!0}\u001b\t\tILC\u0002\u0002<:\u000bA!\u001e;jY&!\u0011qXA]\u0005\u0011a\u0015n\u001d;\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\u0006!1\u000f^8q)\u0005\u0011\bbBAe\u0001\u0011\u0005\u0011QY\u0001\tg\",H\u000fZ8x]\"9\u0011Q\u001a\u0001\u0005\u0002\u0005\u0015\u0017\u0001E1xC&$H+\u001a:nS:\fG/[8o\u0011\u001d\t\t\u000e\u0001C\u0001\u0003\u000b\f\u0011e^1ji\u001a{'\u000fV1tW6\u000bg.Y4feN$vNQ3SK\u001eL7\u000f^3sK\u0012Dq!!6\u0001\t\u0003\t9.\u0001\ttk\nl\u0017\u000e\u001e&pE\u0006sGmV1jiR1\u0011\u0011\\As\u0003k\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0004\u0003?$\u0011AB2mS\u0016tG/\u0003\u0003\u0002d\u0006u'\u0001H*fe&\fG.\u001b>fI*{'-\u0012=fGV$\u0018n\u001c8SKN,H\u000e\u001e\u0005\t\u0003O\f\u0019\u000e1\u0001\u0002j\u0006A!n\u001c2He\u0006\u0004\b\u000e\u0005\u0003\u0002l\u0006EXBAAw\u0015\r\ty\u000fB\u0001\tU>\u0014wM]1qQ&!\u00111_Aw\u0005!QuNY$sCBD\u0007bBA|\u0003'\u0004\rAI\u0001\raJLg\u000e^+qI\u0006$Xm\u001d\u0015\u0007\u0003'\fYPa\b\u0011\u000b=\tiP!\u0001\n\u0007\u0005}\bC\u0001\u0004uQJ|wo\u001d\t\u0005\u0005\u0007\u0011)\u0001\u0004\u0001\u0005\u000f\t\u001d\u0001A1\u0001\u0003\n\t\tA+\u0005\u0003\u0003\f\tE\u0001cA\b\u0003\u000e%\u0019!q\u0002\t\u0003\u000f9{G\u000f[5oOB!!1\u0003B\r\u001d\ry!QC\u0005\u0004\u0005/\u0001\u0012a\u00029bG.\fw-Z\u0005\u0005\u00057\u0011iBA\u0005UQJ|w/\u00192mK*\u0019!q\u0003\t$\u0005\t\u0005\u0002\u0003BAn\u0005GIAA!\n\u0002^\n)\"j\u001c2Fq\u0016\u001cW\u000f^5p]\u0016C8-\u001a9uS>t\u0007bBAk\u0001\u0011\u0005!\u0011\u0006\u000b\t\u00033\u0014YC!\f\u00030!A\u0011q\u001dB\u0014\u0001\u0004\tI\u000fC\u0004\u0002x\n\u001d\u0002\u0019\u0001\u0012\t\rU\u00139\u00031\u0001XQ\u0019\u00119Ca\r\u0003 A)q\"!@\u00036A!!1\u0001B\u001c\t\u001d\u00119\u0001\u0001b\u0001\u0005\u0013AqAa\u000f\u0001\t\u0003\u0011i$A\ttk\nl\u0017\u000e\u001e&pE\u0012+G/Y2iK\u0012$BAa\u0010\u0003PA!!\u0011\tB&\u001b\t\u0011\u0019E\u0003\u0003\u0003F\t\u001d\u0013AB2p[6|gNC\u0002\u0003J\u0019\t1!\u00199j\u0013\u0011\u0011iEa\u0011\u0003'){'mU;c[&\u001c8/[8o%\u0016\u001cX\u000f\u001c;\t\u0011\u0005\u001d(\u0011\ba\u0001\u0003SDcA!\u000f\u0003T\t}\u0001#B\b\u0002~\nU\u0003\u0003\u0002B\u0002\u0005/\"qAa\u0002\u0001\u0005\u0004\u0011I\u0001")
public abstract class FlinkMiniCluster {
    private final Configuration userConfiguration;
    private final boolean singleActorSystem;
    private final StreamingMode streamingMode;
    private final Logger LOG;
    private final String hostname;
    private final FiniteDuration timeout;
    private final Configuration configuration;
    private ActorSystem jobManagerActorSystem;
    private ActorRef jobManagerActor;
    private final int numTaskManagers;
    private final Tuple2<IndexedSeq<ActorSystem>, IndexedSeq<ActorRef>> x$1;
    private IndexedSeq<ActorSystem> taskManagerActorSystems;
    private IndexedSeq<ActorRef> taskManagerActors;

    public Configuration userConfiguration() {
        return this.userConfiguration;
    }

    public boolean singleActorSystem() {
        return this.singleActorSystem;
    }

    public StreamingMode streamingMode() {
        return this.streamingMode;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public String hostname() {
        return this.hostname;
    }

    public FiniteDuration timeout() {
        return this.timeout;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public ActorSystem jobManagerActorSystem() {
        return this.jobManagerActorSystem;
    }

    public void jobManagerActorSystem_$eq(ActorSystem x$1) {
        this.jobManagerActorSystem = x$1;
    }

    public ActorRef jobManagerActor() {
        return this.jobManagerActor;
    }

    public void jobManagerActor_$eq(ActorRef x$1) {
        this.jobManagerActor = x$1;
    }

    public int numTaskManagers() {
        return this.numTaskManagers;
    }

    public IndexedSeq<ActorSystem> taskManagerActorSystems() {
        return this.taskManagerActorSystems;
    }

    public void taskManagerActorSystems_$eq(IndexedSeq<ActorSystem> x$1) {
        this.taskManagerActorSystems = x$1;
    }

    public IndexedSeq<ActorRef> taskManagerActors() {
        return this.taskManagerActors;
    }

    public void taskManagerActors_$eq(IndexedSeq<ActorRef> x$1) {
        this.taskManagerActors = x$1;
    }

    public abstract Configuration generateConfiguration(Configuration var1);

    public abstract ActorRef startJobManager(ActorSystem var1);

    public abstract ActorRef startTaskManager(int var1, ActorSystem var2);

    public Config getJobManagerAkkaConfig() {
        Config config;
        if (this.singleActorSystem()) {
            config = AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)None$.MODULE$);
        } else {
            int port = this.configuration().getInteger("jobmanager.rpc.port", 6123);
            config = AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)this.hostname(), (Object)BoxesRunTime.boxToInteger((int)port))));
        }
        return config;
    }

    public ActorSystem startJobManagerActorSystem() {
        Config config = this.getJobManagerAkkaConfig();
        return AkkaUtils$.MODULE$.createActorSystem(config);
    }

    public Config getTaskManagerAkkaConfig(int index) {
        int port = this.configuration().getInteger("taskmanager.rpc.port", 0);
        int resolvedPort = port != 0 ? port + index : port;
        return AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)this.hostname(), (Object)BoxesRunTime.boxToInteger((int)resolvedPort))));
    }

    public ActorSystem startTaskManagerActorSystem(int index) {
        Config config = this.getTaskManagerAkkaConfig(index);
        return AkkaUtils$.MODULE$.createActorSystem(config);
    }

    public ActorRef getJobManager() {
        return this.jobManagerActor();
    }

    public IndexedSeq<ActorRef> getTaskManagers() {
        return this.taskManagerActors();
    }

    public List<ActorRef> getTaskManagersAsJava() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.taskManagerActors()).asJava();
    }

    public void stop() {
        this.LOG().info("Stopping FlinkMiniCluster.");
        this.shutdown();
        this.awaitTermination();
    }

    public void shutdown() {
        IndexedSeq futures = (IndexedSeq)this.taskManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkMiniCluster $outer;

            public final Future<Boolean> apply(ActorRef x$2) {
                return Patterns$.MODULE$.gracefulStop(x$2, this.$outer.timeout());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Future future = Patterns$.MODULE$.gracefulStop(this.jobManagerActor(), this.timeout());
        ExecutionContext executionContext = AkkaUtils$.MODULE$.globalExecutionContext();
        Future future2 = future;
        Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures.$plus$colon((Object)future2, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom(), executionContext), (Duration)this.timeout());
        if (!this.singleActorSystem()) {
            this.taskManagerActorSystems().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ActorSystem x$4) {
                    x$4.shutdown();
                }
            });
        }
        this.jobManagerActorSystem().shutdown();
    }

    public void awaitTermination() {
        this.jobManagerActorSystem().awaitTermination();
        this.taskManagerActorSystems().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ActorSystem x$5) {
                x$5.awaitTermination();
            }
        });
    }

    public void waitForTaskManagersToBeRegistered() {
        ExecutionContext executionContext = AkkaUtils$.MODULE$.globalExecutionContext();
        IndexedSeq futures = (IndexedSeq)this.taskManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkMiniCluster $outer;

            public final Future<Object> apply(ActorRef taskManager) {
                return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(taskManager), (Object)TaskManagerMessages$NotifyWhenRegisteredAtJobManager$.MODULE$, Timeout$.MODULE$.durationToTimeout(this.$outer.timeout()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, IndexedSeq$.MODULE$.canBuildFrom(), executionContext), (Duration)this.timeout());
    }

    public SerializedJobExecutionResult submitJobAndWait(JobGraph jobGraph, boolean printUpdates) throws JobExecutionException {
        return this.submitJobAndWait(jobGraph, printUpdates, this.timeout());
    }

    public SerializedJobExecutionResult submitJobAndWait(JobGraph jobGraph, boolean printUpdates, FiniteDuration timeout) throws JobExecutionException {
        ActorSystem clientActorSystem = this.singleActorSystem() ? this.jobManagerActorSystem() : JobClient.startJobClientActorSystem(this.configuration());
        return JobClient.submitJobAndWait(clientActorSystem, this.jobManagerActor(), jobGraph, timeout, printUpdates);
    }

    public JobSubmissionResult submitJobDetached(JobGraph jobGraph) throws JobExecutionException {
        JobClient.submitJobDetached(this.jobManagerActor(), jobGraph, this.timeout());
        return new JobSubmissionResult(jobGraph.getJobID());
    }

    public FlinkMiniCluster(Configuration userConfiguration, boolean singleActorSystem, StreamingMode streamingMode) {
        this.userConfiguration = userConfiguration;
        this.singleActorSystem = singleActorSystem;
        this.streamingMode = streamingMode;
        this.LOG = LoggerFactory.getLogger(FlinkMiniCluster.class);
        this.hostname = InetAddress.getByName("localhost").getHostAddress();
        this.timeout = AkkaUtils$.MODULE$.getTimeout(userConfiguration);
        this.configuration = this.generateConfiguration(userConfiguration);
        this.jobManagerActorSystem = this.startJobManagerActorSystem();
        this.jobManagerActor = this.startJobManager(this.jobManagerActorSystem());
        this.numTaskManagers = this.configuration().getInteger("localinstancemanager.numtaskmanager", 1);
        Tuple2 tuple2 = ((GenericTraversableTemplate)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numTaskManagers()).map((Function1)new $anonfun$1(this), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            IndexedSeq taskManagerActorSystems = (IndexedSeq)tuple2._1();
            IndexedSeq taskManagerActors = (IndexedSeq)tuple2._2();
            this.x$1 = tuple22 = new Tuple2((Object)taskManagerActorSystems, (Object)taskManagerActors);
            this.taskManagerActorSystems = (IndexedSeq)this.x$1._1();
            this.taskManagerActors = (IndexedSeq)this.x$1._2();
            this.waitForTaskManagersToBeRegistered();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public FlinkMiniCluster(Configuration userConfiguration, boolean singleActorSystem) {
        this(userConfiguration, singleActorSystem, StreamingMode.BATCH_ONLY);
    }
}

