/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import java.lang.reflect.Method;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.StreamingMode;
import org.apache.flink.runtime.client.JobClient;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.jobmanager.JobManager$;
import org.apache.flink.runtime.jobmanager.web.WebInfoServer;
import org.apache.flink.runtime.minicluster.FlinkMiniCluster;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster$;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.util.EnvironmentInformation;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u00015\u0011Q\u0003T8dC24E.\u001b8l\u001b&t\u0017n\u00117vgR,'O\u0003\u0002\u0004\t\u0005YQ.\u001b8jG2,8\u000f^3s\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0011\r2Lgn['j]&\u001cE.^:uKJD\u0011b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001\u0006\u000e\u0002#U\u001cXM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\u0007\f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0013\t\u0019\u0002\u0003C\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001eG\u0005\t2/\u001b8hY\u0016\f5\r^8s'f\u001cH/Z7\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\u000f\t{w\u000e\\3b]&\u0011A\u0004\u0005\u0005\nK\u0001\u0011\t\u0011)A\u0005M)\nQb\u001d;sK\u0006l\u0017N\\4N_\u0012,\u0007CA\u0014)\u001b\u0005!\u0011BA\u0015\u0005\u00055\u0019FO]3b[&tw-T8eK&\u0011Q\u0005\u0005\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\t9z\u0003'\r\t\u0003\u001f\u0001AQaE\u0016A\u0002QAQ\u0001H\u0016A\u0002uAQ!J\u0016A\u0002\u0019BQ\u0001\f\u0001\u0005\u0002M\"2A\f\u001b6\u0011\u0015\u0019\"\u00071\u0001\u0015\u0011\u0015a\"\u00071\u0001\u001e\u0011\u0015a\u0003\u0001\"\u00018)\tq\u0003\bC\u0003\u0014m\u0001\u0007A\u0003C\u0004;\u0001\t\u0007I\u0011A\u001e\u0002))|'m\u00117jK:$\u0018i\u0019;peNK8\u000f^3n+\u0005a\u0004CA\u001fC\u001b\u0005q$BA A\u0003\u0015\t7\r^8s\u0015\u0005\t\u0015\u0001B1lW\u0006L!a\u0011 \u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002\u001f\u0002+)|'m\u00117jK:$\u0018i\u0019;peNK8\u000f^3nA!)q\t\u0001C!\u0011\u0006)r-\u001a8fe\u0006$XmQ8oM&<WO]1uS>tGC\u0001\u000bJ\u0011\u0015\u0019b\t1\u0001\u0015\u0011\u0015Y\u0005\u0001\"\u0011M\u0003=\u0019H/\u0019:u\u0015>\u0014W*\u00198bO\u0016\u0014HCA'Q!\tid*\u0003\u0002P}\tA\u0011i\u0019;peJ+g\rC\u0003R\u0015\u0002\u0007A(\u0001\u0004tsN$X-\u001c\u0005\u0006'\u0002!\t\u0005V\u0001\u0011gR\f'\u000f\u001e+bg.l\u0015M\\1hKJ$2!T+[\u0011\u00151&\u000b1\u0001X\u0003\u0015Ig\u000eZ3y!\tq\u0002,\u0003\u0002Z?\t\u0019\u0011J\u001c;\t\u000bE\u0013\u0006\u0019\u0001\u001f\t\u000bq\u0003A\u0011A\u001e\u0002/\u001d,GOS8c\u00072LWM\u001c;BGR|'oU=ti\u0016l\u0007\"\u00020\u0001\t\u0003y\u0016\u0001F4fi*{'-T1oC\u001e,'O\u0015)D!>\u0014H/F\u0001X\u0011\u0015\t\u0007\u0001\"\u0011c\u0003!\u0019\b.\u001e;e_^tG#A2\u0011\u0005y!\u0017BA3 \u0005\u0011)f.\u001b;\t\u000b\u001d\u0004A\u0011\t2\u0002!\u0005<\u0018-\u001b;UKJl\u0017N\\1uS>t\u0007\"B5\u0001\t\u0003Q\u0017!G5oSRL\u0017\r\\5{K&{ei\u001c:nCR\u001cE.Y:tKN$\"aY6\t\u000b]A\u0007\u0019\u0001\u000b\t\u000b5\u0004A\u0011\u00018\u0002\u0013M,G/T3n_JLHCA2p\u0011\u0015\u0001H\u000e1\u0001\u0015\u0003\u0019\u0019wN\u001c4jO\")!\u000f\u0001C\u0001g\u0006\u0001r-\u001a;D_:4\u0017nZ;sCRLwN\\\u000b\u0002)!)Q\u000f\u0001C\u0001g\u0006\u0001r-\u001a;EK\u001a\fW\u000f\u001c;D_:4\u0017nZ\u0004\u0006o\nA\t\u0001_\u0001\u0016\u0019>\u001c\u0017\r\u001c$mS:\\W*\u001b8j\u00072,8\u000f^3s!\ty\u0011PB\u0003\u0002\u0005!\u0005!p\u0005\u0002zwB\u0011a\u0004`\u0005\u0003{~\u0011a!\u00118z%\u00164\u0007\"\u0002\u0017z\t\u0003yH#\u0001=\t\u0013\u0005\r\u0011P1A\u0005\u0002\u0005\u0015\u0011a\u0001'P\u000fV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\u0006\u0002\u000bMdg\r\u000e6\n\t\u0005E\u00111\u0002\u0002\u0007\u0019><w-\u001a:\t\u0011\u0005U\u0011\u0010)A\u0005\u0003\u000f\tA\u0001T(HA!9\u0011\u0011D=\u0005\u0002\u0005m\u0011\u0001B7bS:$2aYA\u000f\u0011!\ty\"a\u0006A\u0002\u0005\u0005\u0012\u0001B1sON\u0004RAHA\u0012\u0003OI1!!\n \u0005\u0015\t%O]1z!\u0011\tI#a\f\u000f\u0007y\tY#C\u0002\u0002.}\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0019\u0003g\u0011aa\u0015;sS:<'bAA\u0017?\u0001")
public class LocalFlinkMiniCluster
extends FlinkMiniCluster {
    private final ActorSystem jobClientActorSystem = super.singleActorSystem() ? this.jobManagerActorSystem() : JobClient.startJobClientActorSystem(this.configuration());

    public static void main(String[] stringArray) {
        LocalFlinkMiniCluster$.MODULE$.main(stringArray);
    }

    public ActorSystem jobClientActorSystem() {
        return this.jobClientActorSystem;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Configuration generateConfiguration(Configuration userConfiguration) {
        void var2_2;
        Configuration config = this.getDefaultConfig();
        config.addAll(userConfiguration);
        this.setMemory(config);
        this.initializeIOFormatClasses(config);
        return var2_2;
    }

    @Override
    public ActorRef startJobManager(ActorSystem system) {
        Configuration config = this.configuration().clone();
        Tuple2<ActorRef, ActorRef> tuple2 = JobManager$.MODULE$.startJobManagerActors(config, system, super.streamingMode());
        if (tuple2 != null) {
            Tuple2 tuple22;
            ActorRef jobManager = (ActorRef)tuple2._1();
            ActorRef archiver = (ActorRef)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)jobManager, (Object)archiver);
            ActorRef jobManager2 = (ActorRef)tuple23._1();
            ActorRef archiver2 = (ActorRef)tuple23._2();
            if (config.getBoolean("localinstancemanager.start-webserver", false)) {
                WebInfoServer webServer = new WebInfoServer(this.configuration(), jobManager2, archiver2);
                webServer.start();
            }
            return jobManager2;
        }
        throw new MatchError(tuple2);
    }

    @Override
    public ActorRef startTaskManager(int index, ActorSystem system) {
        Configuration config = this.configuration().clone();
        int rpcPort = config.getInteger("taskmanager.rpc.port", 0);
        int dataPort = config.getInteger("taskmanager.data.port", 0);
        if (rpcPort > 0) {
            config.setInteger("taskmanager.rpc.port", rpcPort + index);
        }
        if (dataPort > 0) {
            config.setInteger("taskmanager.data.port", dataPort + index);
        }
        boolean localExecution = this.numTaskManagers() == 1;
        String taskManagerActorName = super.singleActorSystem() ? new StringBuilder().append((Object)TaskManager$.MODULE$.TASK_MANAGER_NAME()).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : TaskManager$.MODULE$.TASK_MANAGER_NAME();
        None$ jobManagerPath = super.singleActorSystem() ? new Some((Object)this.jobManagerActor().path().toString()) : None$.MODULE$;
        return TaskManager$.MODULE$.startTaskManagerComponentsAndActor(config, system, this.hostname(), (Option<String>)new Some((Object)taskManagerActorName), (Option<String>)jobManagerPath, localExecution, super.streamingMode(), TaskManager.class);
    }

    public ActorSystem getJobClientActorSystem() {
        return this.jobClientActorSystem();
    }

    public int getJobManagerRPCPort() {
        int n;
        if (this.jobManagerActorSystem() instanceof ExtendedActorSystem) {
            int n2;
            ExtendedActorSystem extActor = (ExtendedActorSystem)this.jobManagerActorSystem();
            Option option = extActor.provider().getDefaultAddress().port();
            if (option instanceof Some) {
                Some some = (Some)option;
                n2 = BoxesRunTime.unboxToInt((Object)some.get());
            } else {
                n2 = -1;
            }
            n = n2;
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (!super.singleActorSystem()) {
            this.jobClientActorSystem().shutdown();
        }
    }

    @Override
    public void awaitTermination() {
        if (!super.singleActorSystem()) {
            this.jobClientActorSystem().awaitTermination();
        }
        super.awaitTermination();
    }

    public void initializeIOFormatClasses(Configuration configuration) {
        try {
            Method om = FileOutputFormat.class.getDeclaredMethod("initDefaultsFromConfiguration", Configuration.class);
            om.setAccessible(true);
            om.invoke(null, configuration);
        }
        catch (Exception exception) {
            this.LOG().error("Cannot (re) initialize the globally loaded defaults. Some classes might not follow the specified default behaviour.");
        }
    }

    public void setMemory(Configuration config) {
        if (config.getInteger("taskmanager.memory.size", -1) == -1) {
            int bufferSizeNew = config.getInteger("taskmanager.memory.segment-size", -1);
            int bufferSizeOld = config.getInteger("taskmanager.network.bufferSizeInBytes", -1);
            int bufferSize = bufferSizeNew != -1 ? bufferSizeNew : (bufferSizeOld == -1 ? 32768 : bufferSizeOld);
            long bufferMem = config.getLong("taskmanager.network.numberOfBuffers", 2048L) * (long)bufferSize;
            int numTaskManager = config.getInteger("localinstancemanager.numtaskmanager", 1);
            float memoryFraction = config.getFloat("taskmanager.memory.fraction", 0.7f);
            long memorySize = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
            memorySize /= (long)(numTaskManager + 1);
            memorySize -= bufferMem;
            memorySize = (long)((double)memorySize * (double)memoryFraction);
            config.setLong("taskmanager.memory.size", memorySize >>>= 20);
        }
    }

    public Configuration getConfiguration() {
        return super.userConfiguration();
    }

    /*
     * WARNING - void declaration
     */
    public Configuration getDefaultConfig() {
        void var1_1;
        Configuration config = new Configuration();
        config.setString("jobmanager.rpc.address", this.hostname());
        config.setInteger("localinstancemanager.numtaskmanager", 1);
        config.setInteger(NettyConfig.NUM_THREADS_CLIENT, 1);
        config.setInteger(NettyConfig.NUM_THREADS_SERVER, 2);
        return var1_1;
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration, boolean singleActorSystem, StreamingMode streamingMode) {
        super(userConfiguration, singleActorSystem, streamingMode);
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration, boolean singleActorSystem) {
        this(userConfiguration, singleActorSystem, StreamingMode.BATCH_ONLY);
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration) {
        this(userConfiguration, true);
    }
}

