/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.PactDriver;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.util.NonReusingMutableToRegularIteratorWrapper;
import org.apache.flink.runtime.util.ReusingMutableToRegularIteratorWrapper;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllGroupReduceDriver<IT, OT>
implements PactDriver<GroupReduceFunction<IT, OT>, OT> {
    private static final Logger LOG = LoggerFactory.getLogger(AllGroupReduceDriver.class);
    private PactTaskContext<GroupReduceFunction<IT, OT>, OT> taskContext;
    private MutableObjectIterator<IT> input;
    private TypeSerializer<IT> serializer;
    private DriverStrategy strategy;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(PactTaskContext<GroupReduceFunction<IT, OT>, OT> context) {
        this.taskContext = context;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<GroupReduceFunction<IT, OT>> getStubType() {
        Class<GroupReduceFunction> clazz = GroupReduceFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 0;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        this.strategy = config.getDriverStrategy();
        switch (this.strategy) {
            case ALL_GROUP_REDUCE_COMBINE: {
                if (!(this.taskContext.getStub() instanceof GroupCombineFunction)) {
                    throw new Exception("Using combiner on a UDF that does not implement the combiner interface " + GroupCombineFunction.class.getName());
                }
            }
            case ALL_GROUP_REDUCE: 
            case ALL_GROUP_COMBINE: {
                break;
            }
            default: {
                throw new Exception("Unrecognized driver strategy for AllGroupReduce driver: " + this.strategy.name());
            }
        }
        this.serializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.input = this.taskContext.getInput(0);
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("AllGroupReduceDriver object reuse: " + (this.objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.taskContext.formatLogString("AllGroupReduceDriver preprocessing done. Running Reducer code."));
        }
        if (this.objectReuseEnabled) {
            ReusingMutableToRegularIteratorWrapper<IT> inIter = new ReusingMutableToRegularIteratorWrapper<IT>(this.input, this.serializer);
            if (!inIter.hasNext()) return;
            if (this.strategy == DriverStrategy.ALL_GROUP_REDUCE) {
                GroupReduceFunction<IT, OT> reducer = this.taskContext.getStub();
                Collector<OT> output = this.taskContext.getOutputCollector();
                reducer.reduce(inIter, output);
                return;
            } else {
                if (this.strategy != DriverStrategy.ALL_GROUP_REDUCE_COMBINE && this.strategy != DriverStrategy.ALL_GROUP_COMBINE) throw new Exception("The strategy " + (Object)((Object)this.strategy) + " is unknown to this driver.");
                GroupCombineFunction combiner = (GroupCombineFunction)this.taskContext.getStub();
                Collector<OT> output = this.taskContext.getOutputCollector();
                combiner.combine(inIter, output);
            }
            return;
        } else {
            NonReusingMutableToRegularIteratorWrapper<IT> inIter = new NonReusingMutableToRegularIteratorWrapper<IT>(this.input, this.serializer);
            if (!inIter.hasNext()) return;
            if (this.strategy == DriverStrategy.ALL_GROUP_REDUCE) {
                GroupReduceFunction<IT, OT> reducer = this.taskContext.getStub();
                Collector<OT> output = this.taskContext.getOutputCollector();
                reducer.reduce(inIter, output);
                return;
            } else {
                if (this.strategy != DriverStrategy.ALL_GROUP_REDUCE_COMBINE && this.strategy != DriverStrategy.ALL_GROUP_COMBINE) throw new Exception("The strategy " + (Object)((Object)this.strategy) + " is unknown to this driver.");
                GroupCombineFunction combiner = (GroupCombineFunction)this.taskContext.getStub();
                Collector<OT> output = this.taskContext.getOutputCollector();
                combiner.combine(inIter, output);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
    }
}

