/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.PactDriver;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.sort.NonReusingSortMergeCoGroupIterator;
import org.apache.flink.runtime.operators.sort.ReusingSortMergeCoGroupIterator;
import org.apache.flink.runtime.operators.util.CoGroupTaskIterator;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoGroupDriver<IT1, IT2, OT>
implements PactDriver<CoGroupFunction<IT1, IT2, OT>, OT> {
    private static final Logger LOG = LoggerFactory.getLogger(CoGroupDriver.class);
    private PactTaskContext<CoGroupFunction<IT1, IT2, OT>, OT> taskContext;
    private CoGroupTaskIterator<IT1, IT2> coGroupIterator;
    private volatile boolean running;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(PactTaskContext<CoGroupFunction<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 2;
    }

    @Override
    public Class<CoGroupFunction<IT1, IT2, OT>> getStubType() {
        Class<CoGroupFunction> clazz = CoGroupFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 2;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        if (config.getDriverStrategy() != DriverStrategy.CO_GROUP) {
            throw new Exception("Unrecognized driver strategy for CoGoup driver: " + config.getDriverStrategy().name());
        }
        MutableObjectIterator in1 = this.taskContext.getInput(0);
        MutableObjectIterator in2 = this.taskContext.getInput(1);
        TypeSerializer serializer1 = this.taskContext.getInputSerializer(0).getSerializer();
        TypeSerializer serializer2 = this.taskContext.getInputSerializer(1).getSerializer();
        TypeComparator groupComparator1 = this.taskContext.getDriverComparator(0);
        TypeComparator groupComparator2 = this.taskContext.getDriverComparator(1);
        TypePairComparatorFactory pairComparatorFactory = config.getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        if (pairComparatorFactory == null) {
            throw new Exception("Missing pair comparator factory for CoGroup driver");
        }
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("CoGroupDriver object reuse: " + (this.objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
        }
        this.coGroupIterator = this.objectReuseEnabled ? new ReusingSortMergeCoGroupIterator(in1, in2, serializer1, groupComparator1, serializer2, groupComparator2, pairComparatorFactory.createComparator12(groupComparator1, groupComparator2)) : new NonReusingSortMergeCoGroupIterator(in1, in2, serializer1, groupComparator1, serializer2, groupComparator2, pairComparatorFactory.createComparator12(groupComparator1, groupComparator2));
        this.coGroupIterator.open();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.taskContext.formatLogString("CoGroup task iterator ready."));
        }
    }

    @Override
    public void run() throws Exception {
        CoGroupFunction<IT1, IT2, OT> coGroupStub = this.taskContext.getStub();
        Collector<OT> collector = this.taskContext.getOutputCollector();
        CoGroupTaskIterator<IT1, IT2> coGroupIterator = this.coGroupIterator;
        while (this.running && coGroupIterator.next()) {
            coGroupStub.coGroup(coGroupIterator.getValues1(), coGroupIterator.getValues2(), collector);
        }
    }

    @Override
    public void cleanup() throws Exception {
        if (this.coGroupIterator != null) {
            this.coGroupIterator.close();
            this.coGroupIterator = null;
        }
    }

    @Override
    public void cancel() throws Exception {
        this.running = false;
        this.cleanup();
    }
}

