/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.PactDriver;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.hash.NonReusingBuildFirstHashMatchIterator;
import org.apache.flink.runtime.operators.hash.NonReusingBuildSecondHashMatchIterator;
import org.apache.flink.runtime.operators.hash.ReusingBuildFirstHashMatchIterator;
import org.apache.flink.runtime.operators.hash.ReusingBuildSecondHashMatchIterator;
import org.apache.flink.runtime.operators.sort.NonReusingMergeMatchIterator;
import org.apache.flink.runtime.operators.sort.ReusingMergeMatchIterator;
import org.apache.flink.runtime.operators.util.JoinTaskIterator;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchDriver<IT1, IT2, OT>
implements PactDriver<FlatJoinFunction<IT1, IT2, OT>, OT> {
    protected static final Logger LOG = LoggerFactory.getLogger(MatchDriver.class);
    protected PactTaskContext<FlatJoinFunction<IT1, IT2, OT>, OT> taskContext;
    private volatile JoinTaskIterator<IT1, IT2, OT> matchIterator;
    protected volatile boolean running;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(PactTaskContext<FlatJoinFunction<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 2;
    }

    @Override
    public Class<FlatJoinFunction<IT1, IT2, OT>> getStubType() {
        Class<FlatJoinFunction> clazz = FlatJoinFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 2;
    }

    @Override
    public void prepare() throws Exception {
        block14: {
            TypePairComparatorFactory pairComparatorFactory;
            TypeComparator comparator2;
            TypeComparator comparator1;
            TypeSerializer serializer2;
            TypeSerializer serializer1;
            MutableObjectIterator in2;
            MutableObjectIterator in1;
            DriverStrategy ls;
            int numPages;
            double fractionAvailableMemory;
            IOManager ioManager;
            MemoryManager memoryManager;
            block13: {
                TaskConfig config = this.taskContext.getTaskConfig();
                memoryManager = this.taskContext.getMemoryManager();
                ioManager = this.taskContext.getIOManager();
                fractionAvailableMemory = config.getRelativeMemoryDriver();
                numPages = memoryManager.computeNumberOfPages(fractionAvailableMemory);
                ls = config.getDriverStrategy();
                in1 = this.taskContext.getInput(0);
                in2 = this.taskContext.getInput(1);
                serializer1 = this.taskContext.getInputSerializer(0).getSerializer();
                serializer2 = this.taskContext.getInputSerializer(1).getSerializer();
                comparator1 = this.taskContext.getDriverComparator(0);
                comparator2 = this.taskContext.getDriverComparator(1);
                pairComparatorFactory = config.getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
                if (pairComparatorFactory == null) {
                    throw new Exception("Missing pair comparator factory for Match driver");
                }
                ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
                this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("MatchDriver object reuse: " + (this.objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
                }
                if (!this.objectReuseEnabled) break block13;
                switch (ls) {
                    case MERGE: {
                        this.matchIterator = new ReusingMergeMatchIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, numPages, this.taskContext.getOwningNepheleTask());
                        break block14;
                    }
                    case HYBRIDHASH_BUILD_FIRST: {
                        this.matchIterator = new ReusingBuildFirstHashMatchIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator21(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getOwningNepheleTask(), fractionAvailableMemory);
                        break block14;
                    }
                    case HYBRIDHASH_BUILD_SECOND: {
                        this.matchIterator = new ReusingBuildSecondHashMatchIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getOwningNepheleTask(), fractionAvailableMemory);
                        break block14;
                    }
                    default: {
                        throw new Exception("Unsupported driver strategy for Match driver: " + ls.name());
                    }
                }
            }
            switch (ls) {
                case MERGE: {
                    this.matchIterator = new NonReusingMergeMatchIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, numPages, this.taskContext.getOwningNepheleTask());
                    break;
                }
                case HYBRIDHASH_BUILD_FIRST: {
                    this.matchIterator = new NonReusingBuildFirstHashMatchIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator21(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getOwningNepheleTask(), fractionAvailableMemory);
                    break;
                }
                case HYBRIDHASH_BUILD_SECOND: {
                    this.matchIterator = new NonReusingBuildSecondHashMatchIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getOwningNepheleTask(), fractionAvailableMemory);
                    break;
                }
                default: {
                    throw new Exception("Unsupported driver strategy for Match driver: " + ls.name());
                }
            }
        }
        this.matchIterator.open();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.taskContext.formatLogString("Match task iterator ready."));
        }
    }

    @Override
    public void run() throws Exception {
        FlatJoinFunction<IT1, IT2, OT> matchStub = this.taskContext.getStub();
        Collector<OT> collector = this.taskContext.getOutputCollector();
        JoinTaskIterator<IT1, IT2, OT> matchIterator = this.matchIterator;
        while (this.running && matchIterator.callWithNextKey(matchStub, collector)) {
        }
    }

    @Override
    public void cleanup() throws Exception {
        if (this.matchIterator != null) {
            this.matchIterator.close();
            this.matchIterator = null;
        }
    }

    @Override
    public void cancel() {
        this.running = false;
        if (this.matchIterator != null) {
            this.matchIterator.abort();
        }
    }
}

