/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.ChannelWriterOutputView;
import org.apache.flink.runtime.memorymanager.AbstractPagedInputView;
import org.apache.flink.runtime.memorymanager.AbstractPagedOutputView;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.LargeRecordHandler;
import org.apache.flink.util.MutableObjectIterator;

public final class FixedLengthRecordSorter<T>
implements InMemorySorter<T> {
    private static final int MIN_REQUIRED_BUFFERS = 3;
    private final byte[] swapBuffer;
    private final TypeSerializer<T> serializer;
    private final TypeComparator<T> comparator;
    private final SingleSegmentOutputView outView;
    private final SingleSegmentInputView inView;
    private MemorySegment currentSortBufferSegment;
    private int currentSortBufferOffset;
    private final ArrayList<MemorySegment> freeMemory;
    private final ArrayList<MemorySegment> sortBuffer;
    private long sortBufferBytes;
    private int numRecords;
    private final int numKeyBytes;
    private final int recordSize;
    private final int recordsPerSegment;
    private final int lastEntryOffset;
    private final int segmentSize;
    private final int totalNumBuffers;
    private final boolean useNormKeyUninverted;
    private final T recordInstance;

    public FixedLengthRecordSorter(TypeSerializer<T> serializer, TypeComparator<T> comparator, List<MemorySegment> memory) {
        if (serializer == null || comparator == null || memory == null) {
            throw new NullPointerException();
        }
        this.serializer = serializer;
        this.comparator = comparator;
        this.useNormKeyUninverted = !comparator.invertNormalizedKey();
        this.totalNumBuffers = memory.size();
        if (this.totalNumBuffers < 3) {
            throw new IllegalArgumentException("Normalized-Key sorter requires at least 3 memory buffers.");
        }
        this.segmentSize = memory.get(0).size();
        this.recordSize = serializer.getLength();
        this.numKeyBytes = this.comparator.getNormalizeKeyLen();
        if (this.recordSize <= 0) {
            throw new IllegalArgumentException("This sorter works only for fixed-length data types.");
        }
        if (this.recordSize > this.segmentSize) {
            throw new IllegalArgumentException("This sorter works only for record lengths below the memory segment size.");
        }
        if (!comparator.supportsSerializationWithKeyNormalization()) {
            throw new IllegalArgumentException("This sorter requires a comparator that supports serialization with key normalization.");
        }
        this.recordsPerSegment = this.segmentSize / this.recordSize;
        this.lastEntryOffset = (this.recordsPerSegment - 1) * this.recordSize;
        this.swapBuffer = new byte[this.recordSize];
        if (memory instanceof ArrayList) {
            this.freeMemory = (ArrayList)memory;
        } else {
            this.freeMemory = new ArrayList(memory.size());
            this.freeMemory.addAll(memory);
        }
        this.sortBuffer = new ArrayList(16);
        this.outView = new SingleSegmentOutputView(this.segmentSize);
        this.inView = new SingleSegmentInputView(this.lastEntryOffset + this.recordSize);
        this.currentSortBufferSegment = this.nextMemorySegment();
        this.sortBuffer.add(this.currentSortBufferSegment);
        this.outView.set(this.currentSortBufferSegment);
        this.recordInstance = this.serializer.createInstance();
    }

    @Override
    public void reset() {
        this.numRecords = 0;
        this.currentSortBufferOffset = 0;
        this.sortBufferBytes = 0L;
        this.freeMemory.addAll(this.sortBuffer);
        this.sortBuffer.clear();
        this.currentSortBufferSegment = this.nextMemorySegment();
        this.sortBuffer.add(this.currentSortBufferSegment);
        this.outView.set(this.currentSortBufferSegment);
    }

    @Override
    public boolean isEmpty() {
        return this.numRecords == 0;
    }

    @Override
    public List<MemorySegment> dispose() {
        this.freeMemory.addAll(this.sortBuffer);
        this.sortBuffer.clear();
        return this.freeMemory;
    }

    @Override
    public long getCapacity() {
        return (long)this.totalNumBuffers * (long)this.segmentSize;
    }

    @Override
    public long getOccupancy() {
        return this.sortBufferBytes;
    }

    @Override
    public long getNumRecordBytes() {
        return this.sortBufferBytes;
    }

    @Override
    public T getRecord(T reuse, int logicalPosition) throws IOException {
        int buffer = logicalPosition / this.recordsPerSegment;
        int inBuffer = logicalPosition % this.recordsPerSegment * this.recordSize;
        this.inView.set(this.sortBuffer.get(buffer), inBuffer);
        return (T)this.comparator.readWithKeyDenormalization(reuse, (DataInputView)this.inView);
    }

    @Override
    public boolean write(T record) throws IOException {
        if (this.currentSortBufferOffset > this.lastEntryOffset) {
            if (this.memoryAvailable()) {
                this.currentSortBufferSegment = this.nextMemorySegment();
                this.sortBuffer.add(this.currentSortBufferSegment);
                this.outView.set(this.currentSortBufferSegment);
                this.currentSortBufferOffset = 0;
                this.sortBufferBytes += (long)this.segmentSize;
            } else {
                return false;
            }
        }
        try {
            this.comparator.writeWithKeyNormalization(record, (DataOutputView)this.outView);
            ++this.numRecords;
            this.currentSortBufferOffset += this.recordSize;
            return true;
        }
        catch (EOFException eofex) {
            throw new IOException("Error: Serialization consumes more bytes than announced by the serializer.");
        }
    }

    private final boolean memoryAvailable() {
        return !this.freeMemory.isEmpty();
    }

    private final MemorySegment nextMemorySegment() {
        return this.freeMemory.remove(this.freeMemory.size() - 1);
    }

    @Override
    public int compare(int i, int j) {
        int bufferNumI = i / this.recordsPerSegment;
        int segmentOffsetI = i % this.recordsPerSegment * this.recordSize;
        int bufferNumJ = j / this.recordsPerSegment;
        int segmentOffsetJ = j % this.recordsPerSegment * this.recordSize;
        MemorySegment segI = this.sortBuffer.get(bufferNumI);
        MemorySegment segJ = this.sortBuffer.get(bufferNumJ);
        int val = MemorySegment.compare((MemorySegment)segI, (MemorySegment)segJ, (int)segmentOffsetI, (int)segmentOffsetJ, (int)this.numKeyBytes);
        return this.useNormKeyUninverted ? val : -val;
    }

    @Override
    public void swap(int i, int j) {
        int bufferNumI = i / this.recordsPerSegment;
        int segmentOffsetI = i % this.recordsPerSegment * this.recordSize;
        int bufferNumJ = j / this.recordsPerSegment;
        int segmentOffsetJ = j % this.recordsPerSegment * this.recordSize;
        MemorySegment segI = this.sortBuffer.get(bufferNumI);
        MemorySegment segJ = this.sortBuffer.get(bufferNumJ);
        MemorySegment.swapBytes((MemorySegment)segI, (MemorySegment)segJ, (byte[])this.swapBuffer, (int)segmentOffsetI, (int)segmentOffsetJ, (int)this.recordSize);
    }

    @Override
    public int size() {
        return this.numRecords;
    }

    @Override
    public final MutableObjectIterator<T> getIterator() {
        final SingleSegmentInputView startIn = new SingleSegmentInputView(this.recordsPerSegment * this.recordSize);
        startIn.set(this.sortBuffer.get(0), 0);
        return new MutableObjectIterator<T>(){
            private final SingleSegmentInputView in;
            private final TypeComparator<T> comp;
            private final int numTotal;
            private final int numPerSegment;
            private int currentTotal;
            private int currentInSegment;
            private int currentSegmentIndex;
            {
                this.in = startIn;
                this.comp = FixedLengthRecordSorter.this.comparator;
                this.numTotal = FixedLengthRecordSorter.this.size();
                this.numPerSegment = FixedLengthRecordSorter.this.recordsPerSegment;
                this.currentTotal = 0;
                this.currentInSegment = 0;
                this.currentSegmentIndex = 0;
            }

            public T next(T reuse) {
                if (this.currentTotal < this.numTotal) {
                    if (this.currentInSegment >= this.numPerSegment) {
                        this.currentInSegment = 0;
                        ++this.currentSegmentIndex;
                        this.in.set((MemorySegment)FixedLengthRecordSorter.this.sortBuffer.get(this.currentSegmentIndex), 0);
                    }
                    ++this.currentTotal;
                    ++this.currentInSegment;
                    try {
                        return this.comp.readWithKeyDenormalization(reuse, (DataInputView)this.in);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                return null;
            }

            public T next() {
                if (this.currentTotal < this.numTotal) {
                    if (this.currentInSegment >= this.numPerSegment) {
                        this.currentInSegment = 0;
                        ++this.currentSegmentIndex;
                        this.in.set((MemorySegment)FixedLengthRecordSorter.this.sortBuffer.get(this.currentSegmentIndex), 0);
                    }
                    ++this.currentTotal;
                    ++this.currentInSegment;
                    try {
                        return this.comp.readWithKeyDenormalization(FixedLengthRecordSorter.this.serializer.createInstance(), (DataInputView)this.in);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public void writeToOutput(ChannelWriterOutputView output) throws IOException {
        TypeComparator<T> comparator = this.comparator;
        TypeSerializer<T> serializer = this.serializer;
        Object record = this.recordInstance;
        SingleSegmentInputView inView = this.inView;
        int recordsPerSegment = this.recordsPerSegment;
        int recordsLeft = this.numRecords;
        int currentMemSeg = 0;
        while (recordsLeft > 0) {
            MemorySegment currentIndexSegment = this.sortBuffer.get(currentMemSeg++);
            inView.set(currentIndexSegment, 0);
            if (recordsLeft >= recordsPerSegment) {
                for (int numInMemSeg = 0; numInMemSeg < recordsPerSegment; ++numInMemSeg) {
                    record = comparator.readWithKeyDenormalization(record, (DataInputView)inView);
                    serializer.serialize(record, (DataOutputView)output);
                }
                recordsLeft -= recordsPerSegment;
                continue;
            }
            while (recordsLeft > 0) {
                record = comparator.readWithKeyDenormalization(record, (DataInputView)inView);
                serializer.serialize(record, (DataOutputView)output);
                --recordsLeft;
            }
        }
    }

    @Override
    public void writeToOutput(ChannelWriterOutputView output, LargeRecordHandler<T> largeRecordsOutput) throws IOException {
        this.writeToOutput(output);
    }

    @Override
    public void writeToOutput(ChannelWriterOutputView output, int start, int num) throws IOException {
        TypeComparator<T> comparator = this.comparator;
        TypeSerializer<T> serializer = this.serializer;
        Object record = this.recordInstance;
        SingleSegmentInputView inView = this.inView;
        int recordsPerSegment = this.recordsPerSegment;
        int currentMemSeg = start / recordsPerSegment;
        int offset = start % recordsPerSegment * this.recordSize;
        while (num > 0) {
            MemorySegment currentIndexSegment = this.sortBuffer.get(currentMemSeg++);
            inView.set(currentIndexSegment, offset);
            if (num >= recordsPerSegment && offset == 0) {
                for (int numInMemSeg = 0; numInMemSeg < recordsPerSegment; ++numInMemSeg) {
                    record = comparator.readWithKeyDenormalization(record, (DataInputView)inView);
                    serializer.serialize(record, (DataOutputView)output);
                }
                num -= recordsPerSegment;
                continue;
            }
            while (num > 0) {
                record = comparator.readWithKeyDenormalization(record, (DataInputView)inView);
                serializer.serialize(record, (DataOutputView)output);
                --num;
            }
        }
    }

    private static final class SingleSegmentInputView
    extends AbstractPagedInputView {
        private final int limit;

        SingleSegmentInputView(int limit) {
            super(0);
            this.limit = limit;
        }

        protected void set(MemorySegment segment, int offset) {
            this.seekInput(segment, offset, this.limit);
        }

        @Override
        protected MemorySegment nextSegment(MemorySegment current) throws EOFException {
            throw new EOFException();
        }

        @Override
        protected int getLimitForSegment(MemorySegment segment) {
            return this.limit;
        }
    }

    private static final class SingleSegmentOutputView
    extends AbstractPagedOutputView {
        SingleSegmentOutputView(int segmentSize) {
            super(segmentSize, 0);
        }

        void set(MemorySegment segment) {
            this.seekOutput(segment, 0);
        }

        @Override
        protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws IOException {
            throw new EOFException();
        }
    }
}

