/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.ByteStreamStateHandle;
import org.apache.flink.runtime.state.StateHandleProvider;
import org.apache.flink.util.StringUtils;

public class FileStateHandle
extends ByteStreamStateHandle {
    private static final long serialVersionUID = 1L;
    private String pathString;

    public FileStateHandle(Serializable state, String folder) {
        super(state);
        this.pathString = folder + "/" + this.randomString();
    }

    @Override
    protected OutputStream getOutputStream() throws IOException, URISyntaxException {
        return FileSystem.get((URI)new URI(this.pathString)).create(new Path(this.pathString), true);
    }

    @Override
    protected InputStream getInputStream() throws IOException, URISyntaxException {
        return FileSystem.get((URI)new URI(this.pathString)).open(new Path(this.pathString));
    }

    private String randomString() {
        byte[] bytes = new byte[20];
        new Random().nextBytes(bytes);
        return StringUtils.byteToHexString((byte[])bytes);
    }

    @Override
    public void discardState() throws Exception {
        FileSystem.get((URI)new URI(this.pathString)).delete(new Path(this.pathString), false);
    }

    public static StateHandleProvider<Serializable> createProvider(String checkpointDir) {
        return new FileStateHandleProvider(checkpointDir);
    }

    private static class FileStateHandleProvider
    implements StateHandleProvider<Serializable> {
        private static final long serialVersionUID = 3496670017955260518L;
        private String path;

        public FileStateHandleProvider(String path) {
            this.path = path;
        }

        public FileStateHandle createStateHandle(Serializable state) {
            return new FileStateHandle(state, this.path);
        }
    }
}

