/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.InstantiationUtil;

public class TaskExecutionState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JobID jobID;
    private final ExecutionAttemptID executionId;
    private final ExecutionState executionState;
    private final byte[] serializedError;
    private transient Throwable cachedError;

    public TaskExecutionState(JobID jobID, ExecutionAttemptID executionId, ExecutionState executionState) {
        this(jobID, executionId, executionState, null);
    }

    public TaskExecutionState(JobID jobID, ExecutionAttemptID executionId, ExecutionState executionState, Throwable error) {
        if (jobID == null || executionId == null || executionState == null) {
            throw new NullPointerException();
        }
        this.jobID = jobID;
        this.executionId = executionId;
        this.executionState = executionState;
        this.cachedError = error;
        if (error != null) {
            byte[] serializedError;
            try {
                serializedError = InstantiationUtil.serializeObject((Object)error);
            }
            catch (Throwable t) {
                try {
                    this.cachedError = new Exception(ExceptionUtils.stringifyException((Throwable)error));
                    serializedError = InstantiationUtil.serializeObject((Object)this.cachedError);
                }
                catch (Throwable tt) {
                    try {
                        this.cachedError = new Exception("Cause is a '" + error.getClass().getName() + "' (failed to serialize or stringify)");
                        serializedError = InstantiationUtil.serializeObject((Object)this.cachedError);
                    }
                    catch (Throwable ttt) {
                        this.cachedError = null;
                        serializedError = null;
                    }
                }
            }
            this.serializedError = serializedError;
        } else {
            this.serializedError = null;
        }
    }

    public Throwable getError(ClassLoader usercodeClassloader) {
        if (this.serializedError == null) {
            return null;
        }
        if (this.cachedError == null) {
            try {
                this.cachedError = (Throwable)InstantiationUtil.deserializeObject((byte[])this.serializedError, (ClassLoader)usercodeClassloader);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while deserializing the attached exception", e);
            }
        }
        return this.cachedError;
    }

    public ExecutionAttemptID getID() {
        return this.executionId;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaskExecutionState) {
            TaskExecutionState other = (TaskExecutionState)obj;
            return other.jobID.equals((Object)this.jobID) && other.executionId.equals((Object)this.executionId) && other.executionState == this.executionState && (other.serializedError == null ? this.serializedError == null : this.serializedError != null && Arrays.equals(this.serializedError, other.serializedError));
        }
        return false;
    }

    public int hashCode() {
        return this.jobID.hashCode() + this.executionId.hashCode() + this.executionState.ordinal();
    }

    public String toString() {
        Object[] objectArray = new Object[4];
        objectArray[0] = this.jobID;
        objectArray[1] = this.executionId;
        objectArray[2] = this.executionState;
        objectArray[3] = this.cachedError == null ? (this.serializedError == null ? "(null)" : "(serialized)") : this.cachedError.getClass().getName() + ": " + this.cachedError.getMessage();
        return String.format("TaskState jobId=%s, executionId=%s, state=%s, error=%s", objectArray);
    }
}

