/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import akka.actor.ActorNotFound;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Props$;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.sun.management.OperatingSystemMXBean;
import com.typesafe.config.Config;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.StreamingMode;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.jobmanager.JobManager$;
import org.apache.flink.runtime.memorymanager.DefaultMemoryManager;
import org.apache.flink.runtime.net.NetUtils;
import org.apache.flink.runtime.process.ProcessReaper;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskmanager.MemoryLogger;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration$;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManagerCliOptions;
import org.apache.flink.runtime.taskmanager.TaskManagerConfiguration;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.MathUtils;
import org.jboss.netty.channel.ChannelException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scopt.OptionParser;
import scopt.Read$;

public final class TaskManager$ {
    public static final TaskManager$ MODULE$;
    private final Logger LOG;
    private final int STARTUP_FAILURE_RETURN_CODE;
    private final int RUNTIME_FAILURE_RETURN_CODE;
    private final String TASK_MANAGER_NAME;
    private final long MAX_STARTUP_CONNECT_TIME;
    private final long STARTUP_CONNECT_LOG_SUPPRESS;
    private final FiniteDuration INITIAL_REGISTRATION_TIMEOUT;
    private final FiniteDuration MAX_REGISTRATION_TIMEOUT;
    private final FiniteDuration DELAY_AFTER_REFUSED_REGISTRATION;
    private final FiniteDuration HEARTBEAT_INTERVAL;

    static {
        new TaskManager$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public int STARTUP_FAILURE_RETURN_CODE() {
        return this.STARTUP_FAILURE_RETURN_CODE;
    }

    public int RUNTIME_FAILURE_RETURN_CODE() {
        return this.RUNTIME_FAILURE_RETURN_CODE;
    }

    public String TASK_MANAGER_NAME() {
        return this.TASK_MANAGER_NAME;
    }

    public long MAX_STARTUP_CONNECT_TIME() {
        return this.MAX_STARTUP_CONNECT_TIME;
    }

    public long STARTUP_CONNECT_LOG_SUPPRESS() {
        return this.STARTUP_CONNECT_LOG_SUPPRESS;
    }

    public FiniteDuration INITIAL_REGISTRATION_TIMEOUT() {
        return this.INITIAL_REGISTRATION_TIMEOUT;
    }

    public FiniteDuration MAX_REGISTRATION_TIMEOUT() {
        return this.MAX_REGISTRATION_TIMEOUT;
    }

    public FiniteDuration DELAY_AFTER_REFUSED_REGISTRATION() {
        return this.DELAY_AFTER_REFUSED_REGISTRATION;
    }

    public FiniteDuration HEARTBEAT_INTERVAL() {
        return this.HEARTBEAT_INTERVAL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        Tuple2 tuple2;
        EnvironmentInformation.logEnvironmentInfo(this.LOG().logger(), "TaskManager", args);
        EnvironmentInformation.checkJavaVersion();
        Tuple2 tuple22 = this.liftedTree1$1(args);
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        Configuration configuration = (Configuration)tuple22._1();
        StreamingMode mode = (StreamingMode)((Object)tuple22._2());
        if (configuration == null) throw new MatchError((Object)tuple22);
        Configuration configuration2 = configuration;
        if (mode == null) throw new MatchError((Object)tuple22);
        StreamingMode streamingMode = mode;
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)configuration2, (Object)streamingMode);
        Configuration configuration3 = (Configuration)tuple23._1();
        StreamingMode mode2 = (StreamingMode)((Object)tuple23._2());
        try {
            if (SecurityUtils.isSecurityEnabled()) {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Security is enabled. Starting secure TaskManager.";
                    }
                });
                SecurityUtils.runSecured(new SecurityUtils.FlinkSecuredRunner<BoxedUnit>(configuration3, mode2){
                    private final Configuration configuration$2;
                    private final StreamingMode mode$1;

                    public void run() {
                        TaskManager$.MODULE$.selectNetworkInterfaceAndRunTaskManager(this.configuration$2, this.mode$1, TaskManager.class);
                    }
                    {
                        this.configuration$2 = configuration$2;
                        this.mode$1 = mode$1;
                    }
                });
                return;
            } else {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Security is not enabled. Starting non-authenticated TaskManager.";
                    }
                });
                this.selectNetworkInterfaceAndRunTaskManager(configuration3, mode2, TaskManager.class);
            }
            return;
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Failed to run TaskManager.";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$10;

                public final Throwable apply() {
                    return this.t$10;
                }
                {
                    this.t$10 = t$10;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
    }

    public Tuple2<Configuration, StreamingMode> parseArgsAndLoadConfig(String[] args) throws Exception {
        Configuration conf;
        OptionParser<TaskManagerCliOptions> parser = new OptionParser<TaskManagerCliOptions>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Flink TaskManager"}));
                this.opt("configDir", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TaskManagerCliOptions apply(String param, TaskManagerCliOptions conf) {
                        conf.setConfigDir(param);
                        return conf;
                    }
                }).text("Specify configuration directory.");
                this.opt("streamingMode", Read$.MODULE$.stringRead()).optional().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TaskManagerCliOptions apply(String param, TaskManagerCliOptions conf) {
                        conf.setMode(param);
                        return conf;
                    }
                }).text("The streaming mode of the JobManager (STREAMING / BATCH)");
            }
        };
        TaskManagerCliOptions cliConfig = (TaskManagerCliOptions)parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new TaskManagerCliOptions()).getOrElse((Function0)new Serializable(args, (OptionParser)parser){
            public static final long serialVersionUID = 0L;
            private final String[] args$2;
            private final OptionParser parser$1;

            public final Nothing$ apply() {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid command line agruments: ", ". Usage: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.args$2).mkString(" "), this.parser$1.usage()})));
            }
            {
                this.args$2 = args$2;
                this.parser$1 = parser$1;
            }
        });
        try {
            this.LOG().info((Function0)new Serializable(cliConfig){
                public static final long serialVersionUID = 0L;
                private final TaskManagerCliOptions cliConfig$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Loading configuration from ").append((Object)this.cliConfig$1.getConfigDir()).toString();
                }
                {
                    this.cliConfig$1 = cliConfig$1;
                }
            });
            GlobalConfiguration.loadConfiguration((String)cliConfig.getConfigDir());
            conf = GlobalConfiguration.getConfiguration();
        }
        catch (Exception exception) {
            throw new Exception("Could not load configuration", exception);
        }
        return new Tuple2((Object)conf, (Object)cliConfig.getMode());
    }

    public void selectNetworkInterfaceAndRunTaskManager(Configuration configuration, StreamingMode streamingMode, Class<? extends TaskManager> taskManagerClass) throws Exception {
        Tuple2<String, Object> tuple2 = this.org$apache$flink$runtime$taskmanager$TaskManager$$getAndCheckJobManagerAddress(configuration);
        if (tuple2 != null) {
            int jobManagerPort;
            int jobManagerPort2;
            String jobManagerHostname = (String)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)jobManagerHostname, (Object)BoxesRunTime.boxToInteger((int)(jobManagerPort2 = tuple2._2$mcI$sp())));
            Tuple2 tuple23 = tuple22;
            String jobManagerHostname2 = (String)tuple23._1();
            Tuple2<String, Object> tuple24 = this.selectNetworkInterfaceAndPort(configuration, jobManagerHostname2, jobManagerPort = tuple23._2$mcI$sp());
            if (tuple24 != null) {
                Tuple2 tuple25;
                String taskManagerHostname = (String)tuple24._1();
                int actorSystemPort = tuple24._2$mcI$sp();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)taskManagerHostname, (Object)BoxesRunTime.boxToInteger((int)actorSystemPort));
                String taskManagerHostname2 = (String)tuple26._1();
                int actorSystemPort2 = tuple26._2$mcI$sp();
                this.runTaskManager(taskManagerHostname2, actorSystemPort2, configuration, streamingMode, taskManagerClass);
                return;
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple2<String, Object> selectNetworkInterfaceAndPort(Configuration configuration, String jobManagerHostname, int jobManagerPort) throws IOException, IllegalConfigurationException {
        ObjectRef taskManagerHostname = new ObjectRef((Object)configuration.getString("taskmanager.hostname", null));
        if ((String)taskManagerHostname.elem == null) {
            InetAddress taskManagerAddress;
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Trying to select the network interface and address to use by connecting to the configured JobManager.";
                }
            });
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaskManager will try to connect for ", " seconds before "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)TaskManager$.MODULE$.MAX_STARTUP_CONNECT_TIME())}))).append((Object)"falling back to heuristics").toString();
                }
            });
            InetSocketAddress jobManagerAddress = new InetSocketAddress(jobManagerHostname, jobManagerPort);
            try {
                taskManagerAddress = NetUtils.findConnectingAddress(jobManagerAddress, this.MAX_STARTUP_CONNECT_TIME(), this.STARTUP_CONNECT_LOG_SUPPRESS());
                taskManagerHostname.elem = taskManagerAddress.getHostName();
            }
            catch (Throwable throwable) {
                void var5_5;
                throw new IOException(new StringBuilder().append((Object)"TaskManager cannot find a network interface that can communicate with the JobManager (").append((Object)var5_5).append((Object)")").toString(), throwable);
            }
            this.LOG().info((Function0)new Serializable(taskManagerHostname, taskManagerAddress){
                public static final long serialVersionUID = 0L;
                private final ObjectRef taskManagerHostname$2;
                private final InetAddress taskManagerAddress$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaskManager will use hostname/address '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.taskManagerHostname$2.elem}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") for communication."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskManagerAddress$1.getHostAddress()}))).toString();
                }
                {
                    this.taskManagerHostname$2 = taskManagerHostname$2;
                    this.taskManagerAddress$1 = taskManagerAddress$1;
                }
            });
        } else {
            this.LOG().info((Function0)new Serializable(taskManagerHostname){
                public static final long serialVersionUID = 0L;
                private final ObjectRef taskManagerHostname$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using configured hostname/address for TaskManager: ").append((Object)((String)this.taskManagerHostname$2.elem)).toString();
                }
                {
                    this.taskManagerHostname$2 = taskManagerHostname$2;
                }
            });
        }
        int actorSystemPort = configuration.getInteger("taskmanager.rpc.port", 0);
        if (actorSystemPort >= 0 && actorSystemPort <= 65535) {
            return new Tuple2((Object)((String)taskManagerHostname.elem), (Object)BoxesRunTime.boxToInteger((int)actorSystemPort));
        }
        throw new IllegalConfigurationException(new StringBuilder().append((Object)"Invalid value for 'taskmanager.rpc.port' (port for the TaskManager actor system) : ").append((Object)BoxesRunTime.boxToInteger((int)actorSystemPort)).append((Object)" - Leave config parameter empty or use 0 to let the system choose a port automatically.").toString());
    }

    public void runTaskManager(String taskManagerHostname, int actorSystemPort, Configuration configuration, StreamingMode streamingMode) throws Exception {
        this.runTaskManager(taskManagerHostname, actorSystemPort, configuration, streamingMode, TaskManager.class);
    }

    public void runTaskManager(String taskManagerHostname, int actorSystemPort, Configuration configuration, StreamingMode streamingMode, Class<? extends TaskManager> taskManagerClass) throws Exception {
        ActorSystem taskManagerSystem;
        this.LOG().info((Function0)new Serializable(streamingMode){
            public static final long serialVersionUID = 0L;
            private final StreamingMode streamingMode$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting TaskManager in streaming mode ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.streamingMode$1}));
            }
            {
                this.streamingMode$1 = streamingMode$1;
            }
        });
        this.LOG().info((Function0)new Serializable(taskManagerHostname, actorSystemPort){
            public static final long serialVersionUID = 0L;
            private final String taskManagerHostname$1;
            private final int actorSystemPort$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting TaskManager actor system at ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskManagerHostname$1, BoxesRunTime.boxToInteger((int)this.actorSystemPort$1)}));
            }
            {
                this.taskManagerHostname$1 = taskManagerHostname$1;
                this.actorSystemPort$1 = actorSystemPort$1;
            }
        });
        try {
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(configuration, (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)taskManagerHostname, (Object)BoxesRunTime.boxToInteger((int)actorSystemPort))));
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug((Function0)new Serializable(akkaConfig){
                    public static final long serialVersionUID = 0L;
                    private final Config akkaConfig$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Using akka configuration\n ").append((Object)this.akkaConfig$1).toString();
                    }
                    {
                        this.akkaConfig$1 = akkaConfig$1;
                    }
                });
            }
            taskManagerSystem = AkkaUtils$.MODULE$.createActorSystem(akkaConfig);
        }
        catch (Throwable throwable) {
            Throwable cause;
            if (throwable instanceof ChannelException && (cause = throwable.getCause()) != null && throwable.getCause() instanceof BindException) {
                String address = new StringBuilder().append((Object)taskManagerHostname).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)actorSystemPort)).toString();
                throw new IOException(new StringBuilder().append((Object)"Unable to bind TaskManager actor system to address ").append((Object)address).append((Object)" - ").append((Object)cause.getMessage()).toString(), throwable);
            }
            throw new Exception("Could not create TaskManager actor system", throwable);
        }
        try {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting TaskManager actor";
                }
            });
            ActorRef taskManager = this.startTaskManagerComponentsAndActor(configuration, taskManagerSystem, taskManagerHostname, (Option<String>)new Some((Object)this.TASK_MANAGER_NAME()), (Option<String>)None$.MODULE$, false, streamingMode, taskManagerClass);
            this.LOG().debug((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting TaskManager process reaper";
                }
            });
            taskManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManager, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "TaskManager_Process_Reaper");
            if (this.LOG().isInfoEnabled() && configuration.getBoolean("taskmanager.debug.memory.startLogThread", false)) {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting periodic memory usage logger";
                    }
                });
                long interval = configuration.getLong("taskmanager.debug.memory.logIntervalMs", 5000L);
                MemoryLogger logger = new MemoryLogger(this.LOG().logger(), interval, taskManagerSystem);
                logger.start();
            }
            taskManagerSystem.awaitTermination();
            return;
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while starting up taskManager";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$11;

                public final Throwable apply() {
                    return this.t$11;
                }
                {
                    this.t$11 = t$11;
                }
            });
            try {
                taskManagerSystem.shutdown();
            }
            catch (Throwable throwable2) {
                this.LOG().warn((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Could not cleanly shut down actor system";
                    }
                }, (Function0)new Serializable(throwable2){
                    public static final long serialVersionUID = 0L;
                    private final Throwable tt$1;

                    public final Throwable apply() {
                        return this.tt$1;
                    }
                    {
                        this.tt$1 = tt$1;
                    }
                });
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ActorRef startTaskManagerComponentsAndActor(Configuration configuration, ActorSystem actorSystem, String taskManagerHostname, Option<String> taskManagerActorName, Option<String> jobManagerPath, boolean localTaskManagerCommunication, StreamingMode streamingMode, Class<? extends TaskManager> taskManagerClass) throws IllegalConfigurationException, IOException, Exception {
        Tuple3<TaskManagerConfiguration, NetworkEnvironmentConfiguration, InstanceConnectionInfo> tuple3;
        block7: {
            Option<String> option;
            block10: {
                ActorRef actorRef;
                block9: {
                    Props tmProps;
                    block8: {
                        IOManagerAsync ioManager;
                        DefaultMemoryManager memoryManager;
                        long l;
                        Tuple3 tuple32;
                        String jobManagerAkkaUrl = (String)jobManagerPath.getOrElse((Function0)new Serializable(configuration){
                            public static final long serialVersionUID = 0L;
                            private final Configuration configuration$1;

                            public final String apply() {
                                Tuple2<String, Object> tuple2 = TaskManager$.MODULE$.org$apache$flink$runtime$taskmanager$TaskManager$$getAndCheckJobManagerAddress(this.configuration$1);
                                if (tuple2 != null) {
                                    Tuple2 tuple22;
                                    String jobManagerHostname = (String)tuple2._1();
                                    int jobManagerPort = tuple2._2$mcI$sp();
                                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)jobManagerHostname, (Object)BoxesRunTime.boxToInteger((int)jobManagerPort));
                                    String jobManagerHostname2 = (String)tuple23._1();
                                    int jobManagerPort2 = tuple23._2$mcI$sp();
                                    InetSocketAddress hostPort = new InetSocketAddress(jobManagerHostname2, jobManagerPort2);
                                    return JobManager$.MODULE$.getRemoteJobManagerAkkaURL(hostPort);
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.configuration$1 = configuration$1;
                            }
                        });
                        tuple3 = this.parseTaskManagerConfiguration(configuration, taskManagerHostname, localTaskManagerCommunication);
                        if (tuple3 == null) break block7;
                        TaskManagerConfiguration taskManagerConfig = (TaskManagerConfiguration)tuple3._1();
                        NetworkEnvironmentConfiguration netConfig = (NetworkEnvironmentConfiguration)tuple3._2();
                        InstanceConnectionInfo connectionInfo = (InstanceConnectionInfo)tuple3._3();
                        if (taskManagerConfig == null) break block7;
                        TaskManagerConfiguration taskManagerConfiguration = taskManagerConfig;
                        if (netConfig == null) break block7;
                        NetworkEnvironmentConfiguration networkEnvironmentConfiguration = netConfig;
                        if (connectionInfo == null) break block7;
                        InstanceConnectionInfo instanceConnectionInfo = connectionInfo;
                        Tuple3 tuple33 = tuple32 = new Tuple3((Object)taskManagerConfiguration, (Object)networkEnvironmentConfiguration, (Object)instanceConnectionInfo);
                        TaskManagerConfiguration taskManagerConfig2 = (TaskManagerConfiguration)tuple33._1();
                        NetworkEnvironmentConfiguration netConfig2 = (NetworkEnvironmentConfiguration)tuple33._2();
                        InstanceConnectionInfo connectionInfo2 = (InstanceConnectionInfo)tuple33._3();
                        this.checkTempDirs(taskManagerConfig2.tmpDirPaths());
                        NetworkEnvironment network = new NetworkEnvironment(taskManagerConfig2.timeout(), netConfig2);
                        long configuredMemory = configuration.getLong("taskmanager.memory.size", -1L);
                        this.checkConfigParameter(configuredMemory == -1L || configuredMemory > 0L, BoxesRunTime.boxToLong((long)configuredMemory), "taskmanager.memory.size", "MemoryManager needs at least one MB of memory. If you leave this config parameter empty, the system automatically pick a fraction of the available memory.");
                        if (configuredMemory > 0L) {
                            this.LOG().info((Function0)new Serializable(configuredMemory){
                                public static final long serialVersionUID = 0L;
                                private final long configuredMemory$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", " MB for Flink managed memory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.configuredMemory$1)}));
                                }
                                {
                                    this.configuredMemory$1 = configuredMemory$1;
                                }
                            });
                            l = configuredMemory << 20;
                        } else {
                            float fraction = configuration.getFloat("taskmanager.memory.fraction", 0.7f);
                            this.checkConfigParameter(fraction > 0.0f && fraction < 1.0f, BoxesRunTime.boxToFloat((float)fraction), "taskmanager.memory.fraction", "MemoryManager fraction of the free memory must be between 0.0 and 1.0");
                            long relativeMemSize = (long)((double)EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag() * (double)fraction);
                            this.LOG().info((Function0)new Serializable(fraction, relativeMemSize){
                                public static final long serialVersionUID = 0L;
                                private final float fraction$1;
                                private final long relativeMemSize$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", " of the currently free heap space for Flink managed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)this.fraction$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory (", " MB)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.relativeMemSize$1 >> 20))}))).toString();
                                }
                                {
                                    this.fraction$1 = fraction$1;
                                    this.relativeMemSize$1 = relativeMemSize$1;
                                }
                            });
                            l = relativeMemSize;
                        }
                        long memorySize = l;
                        StreamingMode streamingMode2 = streamingMode;
                        StreamingMode streamingMode3 = StreamingMode.BATCH_ONLY;
                        boolean preAllocateMemory = !(streamingMode2 != null ? !((Object)((Object)streamingMode2)).equals((Object)streamingMode3) : streamingMode3 != null);
                        try {
                            memoryManager = new DefaultMemoryManager(memorySize, taskManagerConfig2.numberOfSlots(), netConfig2.networkBufferSize(), preAllocateMemory);
                            ioManager = new IOManagerAsync(taskManagerConfig2.tmpDirPaths());
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            void var28_26;
                            throw new Exception(new StringBuilder().append((Object)"OutOfMemory error (").append((Object)outOfMemoryError.getMessage()).append((Object)") while allocating the TaskManager memory (").append((Object)BoxesRunTime.boxToLong((long)var28_26)).append((Object)" bytes).").toString(), outOfMemoryError);
                        }
                        tmProps = Props$.MODULE$.apply(taskManagerClass, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerConfig2, connectionInfo2, jobManagerAkkaUrl, memoryManager, ioManager, network, BoxesRunTime.boxToInteger((int)taskManagerConfig2.numberOfSlots())}));
                        option = taskManagerActorName;
                        if (!(option instanceof Some)) break block8;
                        Some some = (Some)option;
                        String actorName = (String)some.x();
                        actorRef = actorSystem.actorOf(tmProps, actorName);
                        break block9;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<String> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block10;
                    actorRef = actorSystem.actorOf(tmProps);
                }
                return actorRef;
            }
            throw new MatchError(option);
        }
        throw new MatchError(tuple3);
    }

    public ActorRef getTaskManagerRemoteReference(String taskManagerUrl, ActorSystem system, FiniteDuration timeout) throws IOException {
        try {
            Future<ActorRef> future = AkkaUtils$.MODULE$.getReference(taskManagerUrl, system, timeout);
            return (ActorRef)Await$.MODULE$.result(future, (Duration)timeout);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ActorNotFound ? true : throwable2 instanceof TimeoutException;
            if (bl) {
                throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaskManager at ", " not reachable. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerUrl}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please make sure that the TaskManager is running and its port is reachable."})).s((Seq)Nil$.MODULE$)).toString(), throwable2);
            }
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                throw new IOException(new StringBuilder().append((Object)"Could not connect to TaskManager at ").append((Object)taskManagerUrl).toString(), iOException);
            }
            throw throwable;
        }
    }

    public Tuple3<TaskManagerConfiguration, NetworkEnvironmentConfiguration, InstanceConnectionInfo> parseTaskManagerConfiguration(Configuration configuration, String taskManagerHostname, boolean localTaskManagerCommunication) throws IllegalArgumentException {
        None$ finiteRegistratioDuration;
        FiniteDuration timeout;
        String syncOrAsync;
        int n;
        int n2;
        int n3;
        int n4 = configuration.getInteger("taskmanager.data.port", 0);
        switch (n4) {
            default: {
                n3 = n4;
                break;
            }
            case 0: {
                n3 = NetUtils.getAvailablePort();
            }
        }
        int dataport = n3;
        this.checkConfigParameter(dataport > 0, BoxesRunTime.boxToInteger((int)dataport), "taskmanager.data.port", "Leave config parameter empty or use 0 to let the system choose a port automatically.");
        InetAddress taskManagerAddress = InetAddress.getByName(taskManagerHostname);
        InstanceConnectionInfo connectionInfo = new InstanceConnectionInfo(taskManagerAddress, dataport);
        int n5 = configuration.getInteger("taskmanager.numberOfTaskSlots", 1);
        switch (n5) {
            default: {
                n2 = n5;
                break;
            }
            case -1: {
                n2 = 1;
            }
        }
        int slots = n2;
        this.checkConfigParameter(slots >= 1, BoxesRunTime.boxToInteger((int)slots), "taskmanager.numberOfTaskSlots", "Number of task slots must be at least one.");
        int numNetworkBuffers = configuration.getInteger("taskmanager.network.numberOfBuffers", 2048);
        this.checkConfigParameter(numNetworkBuffers > 0, BoxesRunTime.boxToInteger((int)numNetworkBuffers), "taskmanager.network.numberOfBuffers", this.checkConfigParameter$default$4());
        int pageSizeNew = configuration.getInteger("taskmanager.memory.segment-size", -1);
        int pageSizeOld = configuration.getInteger("taskmanager.network.bufferSizeInBytes", -1);
        if (pageSizeNew != -1) {
            this.checkConfigParameter(pageSizeNew >= DefaultMemoryManager.MIN_PAGE_SIZE, BoxesRunTime.boxToInteger((int)pageSizeNew), "taskmanager.memory.segment-size", new StringBuilder().append((Object)"Minimum memory segment size is ").append((Object)BoxesRunTime.boxToInteger((int)DefaultMemoryManager.MIN_PAGE_SIZE)).toString());
            this.checkConfigParameter(MathUtils.isPowerOf2(pageSizeNew), BoxesRunTime.boxToInteger((int)pageSizeNew), "taskmanager.memory.segment-size", "Memory segment size must be a power of 2.");
            n = pageSizeNew;
        } else if (pageSizeOld == -1) {
            n = 32768;
        } else {
            this.checkConfigParameter(pageSizeOld >= DefaultMemoryManager.MIN_PAGE_SIZE, BoxesRunTime.boxToInteger((int)pageSizeOld), "taskmanager.network.bufferSizeInBytes", new StringBuilder().append((Object)"Minimum buffer size is ").append((Object)BoxesRunTime.boxToInteger((int)DefaultMemoryManager.MIN_PAGE_SIZE)).toString());
            this.checkConfigParameter(MathUtils.isPowerOf2(pageSizeOld), BoxesRunTime.boxToInteger((int)pageSizeOld), "taskmanager.network.bufferSizeInBytes", "Buffer size must be a power of 2.");
            n = pageSizeOld;
        }
        int pageSize = n;
        String[] tmpDirs = configuration.getString("taskmanager.tmp.dirs", ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH).split(new StringBuilder().append((Object)",|").append((Object)File.pathSeparator).toString());
        None$ nettyConfig = localTaskManagerCommunication ? None$.MODULE$ : new Some((Object)new NettyConfig(connectionInfo.address(), connectionInfo.dataPort(), pageSize, configuration));
        String string = syncOrAsync = configuration.getString("taskmanager.network.defaultIOMode", "sync");
        String string2 = "async";
        IOManager.IOMode ioMode = !(string != null ? !string.equals(string2) : string2 != null) ? IOManager.IOMode.ASYNC : IOManager.IOMode.SYNC;
        NetworkEnvironmentConfiguration networkConfig = new NetworkEnvironmentConfiguration(numNetworkBuffers, pageSize, ioMode, (Option<NettyConfig>)nettyConfig, NetworkEnvironmentConfiguration$.MODULE$.apply$default$5());
        try {
            timeout = AkkaUtils$.MODULE$.getTimeout(configuration);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid format for '", "'. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"akka.ask.timeout"}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use formats like '50 s' or '1 min' to specify the timeout."})).s((Seq)Nil$.MODULE$)).toString());
        }
        this.LOG().info((Function0)new Serializable(timeout){
            public static final long serialVersionUID = 0L;
            private final FiniteDuration timeout$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Messages between TaskManager and JobManager have a max timeout of ").append((Object)this.timeout$2).toString();
            }
            {
                this.timeout$2 = timeout$2;
            }
        });
        long cleanupInterval = configuration.getLong("library-cache-manager.cleanup.interval", 3600L) * 1000L;
        try {
            Duration maxRegistrationDuration = Duration$.MODULE$.apply(configuration.getString("taskmanager.maxRegistrationDuration", "Inf"));
            finiteRegistratioDuration = maxRegistrationDuration.isFinite() ? new Some((Object)((FiniteDuration)maxRegistrationDuration)) : None$.MODULE$;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid format for parameter taskmanager.maxRegistrationDuration", numberFormatException);
        }
        TaskManagerConfiguration taskManagerConfig = new TaskManagerConfiguration(tmpDirs, cleanupInterval, timeout, (Option<FiniteDuration>)finiteRegistratioDuration, slots, configuration);
        return new Tuple3((Object)taskManagerConfig, (Object)networkConfig, (Object)connectionInfo);
    }

    public Tuple2<String, Object> org$apache$flink$runtime$taskmanager$TaskManager$$getAndCheckJobManagerAddress(Configuration configuration) {
        String hostname = configuration.getString("jobmanager.rpc.address", null);
        int port = configuration.getInteger("jobmanager.rpc.port", 6123);
        if (hostname == null) {
            throw new Exception("Config parameter 'jobmanager.rpc.address' is missing (hostname/address of JobManager to connect to).");
        }
        if (port <= 0 || port >= 65536) {
            throw new Exception(new StringBuilder().append((Object)"Invalid value for 'jobmanager.rpc.port' (port of the JobManager actor system) : ").append((Object)BoxesRunTime.boxToInteger((int)port)).append((Object)".  it must be great than 0 and less than 65536.").toString());
        }
        return new Tuple2((Object)hostname, (Object)BoxesRunTime.boxToInteger((int)port));
    }

    private void checkConfigParameter(boolean condition, Object parameter, String name, String errorMessage) throws IllegalConfigurationException {
        if (condition) {
            return;
        }
        throw new IllegalConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid configuration value for '", "' : ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, parameter, errorMessage})));
    }

    private String checkConfigParameter$default$4() {
        return "";
    }

    private void checkTempDirs(String[] tmpDirs) throws IOException {
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tmpDirs).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, Object> x0$2) {
                String dir;
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null && (dir = (String)tuple2._1()) != null) {
                    String string = dir;
                    File file = new File(string);
                    if (file.exists()) {
                        if (file.isDirectory()) {
                            if (file.canWrite()) {
                                BoxedUnit boxedUnit;
                                if (TaskManager$.MODULE$.LOG().isInfoEnabled()) {
                                    long totalSpaceGb = file.getTotalSpace() >> 30;
                                    long usableSpaceGb = file.getUsableSpace() >> 30;
                                    double usablePercentage = (double)usableSpaceGb / (double)totalSpaceGb * (double)100;
                                    String path = file.getAbsolutePath();
                                    TaskManager$.MODULE$.LOG().info((Function0)new Serializable(this, totalSpaceGb, usableSpaceGb, usablePercentage, path){
                                        public static final long serialVersionUID = 0L;
                                        private final long totalSpaceGb$1;
                                        private final long usableSpaceGb$1;
                                        private final double usablePercentage$1;
                                        private final String path$1;

                                        public final String apply() {
                                            String arg$1 = this.path$1;
                                            Long arg$2 = BoxesRunTime.boxToLong((long)this.totalSpaceGb$1);
                                            Long arg$3 = BoxesRunTime.boxToLong((long)this.usableSpaceGb$1);
                                            double arg$4 = this.usablePercentage$1;
                                            return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Temporary file directory '%s': total %s GB, ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$1, arg$2}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("usable %s GB (%.2f%% usable)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$3, BoxesRunTime.boxToDouble((double)arg$4)}))).toString();
                                        }
                                        {
                                            this.totalSpaceGb$1 = totalSpaceGb$1;
                                            this.usableSpaceGb$1 = usableSpaceGb$1;
                                            this.usablePercentage$1 = usablePercentage$1;
                                            this.path$1 = path$1;
                                        }
                                    });
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return;
                            }
                            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary file directory ", " is not writable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                        }
                        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary file directory ", " is not a directory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                    }
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary file directory ", " does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                }
                if (tuple2 != null) {
                    int id = tuple2._2$mcI$sp();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temporary file directory #", " is null."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
                }
                throw new MatchError(tuple2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public MetricRegistry org$apache$flink$runtime$taskmanager$TaskManager$$createMetricsRegistry() {
        void var1_1;
        MetricRegistry metricRegistry = new MetricRegistry();
        metricRegistry.register("gc", (Metric)new GarbageCollectorMetricSet());
        metricRegistry.register("memory", (Metric)new MemoryUsageGaugeSet());
        metricRegistry.register("load", (Metric)new Gauge<Object>(){

            public double getValue() {
                return ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
            }
        });
        Option<Method> fetchCPULoad = this.getMethodToFetchCPULoad();
        if (fetchCPULoad.isEmpty()) {
            this.LOG().warn((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)"getProcessCpuLoad method not available in the Operating System Beanimplementation for this Java runtime environment\n").append((Object)Thread.currentThread().getStackTrace()).toString();
                }
            });
        }
        metricRegistry.register("cpuLoad", (Metric)new Gauge<Object>(fetchCPULoad){
            private final Option fetchCPULoad$1;

            public double getValue() {
                double d;
                try {
                    d = BoxesRunTime.unboxToDouble((Object)this.fetchCPULoad$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Method x$13) {
                            return BoxesRunTime.unboxToDouble((Object)x$13.invoke((Object)((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()), new Object[0]));
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return -1.0;
                        }
                    }));
                }
                catch (Throwable throwable) {
                    TaskManager$.MODULE$.LOG().warn((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Error retrieving CPU Load through OperatingSystemMXBean";
                        }
                    }, (Function0)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable t$12;

                        public final Throwable apply() {
                            return this.t$12;
                        }
                        {
                            this.t$12 = t$12;
                        }
                    });
                    d = -1.0;
                }
                return d;
            }
            {
                this.fetchCPULoad$1 = fetchCPULoad$1;
            }
        });
        return var1_1;
    }

    private Option<Method> getMethodToFetchCPULoad() {
        Method[] methodsList = OperatingSystemMXBean.class.getMethods();
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])methodsList).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Method x$14) {
                String string = x$14.getName();
                String string2 = "getProcessCpuLoad";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })).headOption();
    }

    private final Tuple2 liftedTree1$1(String[] args$1) {
        Tuple2<Configuration, StreamingMode> tuple2;
        try {
            tuple2 = this.parseArgsAndLoadConfig(args$1);
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$9;

                public final String apply() {
                    return this.t$9.getMessage();
                }
                {
                    this.t$9 = t$9;
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$9;

                public final Throwable apply() {
                    return this.t$9;
                }
                {
                    this.t$9 = t$9;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            tuple2 = null;
        }
        return tuple2;
    }

    private TaskManager$() {
        MODULE$ = this;
        this.LOG = Logger$.MODULE$.apply(TaskManager.class);
        this.STARTUP_FAILURE_RETURN_CODE = 1;
        this.RUNTIME_FAILURE_RETURN_CODE = 2;
        this.TASK_MANAGER_NAME = "taskmanager";
        this.MAX_STARTUP_CONNECT_TIME = 120000L;
        this.STARTUP_CONNECT_LOG_SUPPRESS = 10000L;
        this.INITIAL_REGISTRATION_TIMEOUT = new package.DurationInt(package$.MODULE$.DurationInt(500)).milliseconds();
        this.MAX_REGISTRATION_TIMEOUT = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
        this.DELAY_AFTER_REFUSED_REGISTRATION = new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds();
        this.HEARTBEAT_INTERVAL = new package.DurationInt(package$.MODULE$.DurationInt(5000)).milliseconds();
    }
}

