/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemoryUtils;
import sun.misc.Unsafe;

public class DataInputDeserializer
implements DataInputView {
    private byte[] buffer;
    private int end;
    private int position;
    private static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
    private static final long BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final boolean LITTLE_ENDIAN = MemoryUtils.NATIVE_BYTE_ORDER == ByteOrder.LITTLE_ENDIAN;

    public DataInputDeserializer() {
    }

    public DataInputDeserializer(byte[] buffer, int start, int len) {
        this.setBuffer(buffer, start, len);
    }

    public DataInputDeserializer(ByteBuffer buffer) {
        this.setBuffer(buffer);
    }

    public void setBuffer(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            this.buffer = buffer.array();
            this.position = buffer.arrayOffset() + buffer.position();
            this.end = this.position + buffer.remaining();
        } else if (buffer.isDirect()) {
            this.buffer = new byte[buffer.remaining()];
            this.position = 0;
            this.end = this.buffer.length;
            buffer.get(this.buffer);
        } else {
            throw new IllegalArgumentException("The given buffer is neither an array-backed heap ByteBuffer, nor a direct ByteBuffer.");
        }
    }

    public void setBuffer(byte[] buffer, int start, int len) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (start < 0 || len < 0 || start + len > buffer.length) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer;
        this.position = start;
        this.end = start + len;
    }

    public void releaseArrays() {
        this.buffer = null;
    }

    public boolean readBoolean() throws IOException {
        if (this.position < this.end) {
            return this.buffer[this.position++] != 0;
        }
        throw new EOFException();
    }

    public byte readByte() throws IOException {
        if (this.position < this.end) {
            return this.buffer[this.position++];
        }
        throw new EOFException();
    }

    public char readChar() throws IOException {
        if (this.position < this.end - 1) {
            return (char)((this.buffer[this.position++] & 0xFF) << 8 | (this.buffer[this.position++] & 0xFF) << 0);
        }
        throw new EOFException();
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len >= 0) {
            if (off > b.length - len) throw new ArrayIndexOutOfBoundsException();
            if (this.position > this.end - len) throw new EOFException();
            System.arraycopy(this.buffer, this.position, b, off, len);
            this.position += len;
            return;
        } else {
            if (len >= 0) return;
            throw new IllegalArgumentException("Length may not be negative.");
        }
    }

    public int readInt() throws IOException {
        if (this.position >= 0 && this.position < this.end - 3) {
            int value = UNSAFE.getInt(this.buffer, BASE_OFFSET + (long)this.position);
            if (LITTLE_ENDIAN) {
                value = Integer.reverseBytes(value);
            }
            this.position += 4;
            return value;
        }
        throw new EOFException();
    }

    public String readLine() throws IOException {
        if (this.position < this.end) {
            StringBuilder bld = new StringBuilder();
            char curr = (char)this.readUnsignedByte();
            while (this.position < this.end && curr != '\n') {
                bld.append(curr);
                curr = (char)this.readUnsignedByte();
            }
            int len = bld.length();
            if (len > 0 && bld.charAt(len - 1) == '\r') {
                bld.setLength(len - 1);
            }
            String s = bld.toString();
            bld.setLength(0);
            return s;
        }
        return null;
    }

    public long readLong() throws IOException {
        if (this.position >= 0 && this.position < this.end - 7) {
            long value = UNSAFE.getLong(this.buffer, BASE_OFFSET + (long)this.position);
            if (LITTLE_ENDIAN) {
                value = Long.reverseBytes(value);
            }
            this.position += 8;
            return value;
        }
        throw new EOFException();
    }

    public short readShort() throws IOException {
        if (this.position >= 0 && this.position < this.end - 1) {
            return (short)((this.buffer[this.position++] & 0xFF) << 8 | (this.buffer[this.position++] & 0xFF) << 0);
        }
        throw new EOFException();
    }

    public String readUTF() throws IOException {
        int c;
        int count;
        int utflen = this.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int chararr_count = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    public int readUnsignedByte() throws IOException {
        if (this.position < this.end) {
            return this.buffer[this.position++] & 0xFF;
        }
        throw new EOFException();
    }

    public int readUnsignedShort() throws IOException {
        if (this.position < this.end - 1) {
            return (this.buffer[this.position++] & 0xFF) << 8 | (this.buffer[this.position++] & 0xFF) << 0;
        }
        throw new EOFException();
    }

    public int skipBytes(int n) throws IOException {
        if (this.position <= this.end - n) {
            this.position += n;
            return n;
        }
        n = this.end - this.position;
        this.position = this.end;
        return n;
    }

    public void skipBytesToRead(int numBytes) throws IOException {
        int skippedBytes = this.skipBytes(numBytes);
        if (skippedBytes < numBytes) {
            throw new EOFException("Could not skip " + numBytes + " bytes.");
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("Byte array b cannot be null.");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("Offset cannot be negative.");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("Length cannot be negative.");
        }
        if (b.length - off < len) {
            throw new IndexOutOfBoundsException("Byte array does not provide enough space to store requested data.");
        }
        if (this.position >= this.end) {
            return -1;
        }
        int toRead = Math.min(this.end - this.position, len);
        System.arraycopy(this.buffer, this.position, b, off, toRead);
        this.position += toRead;
        return toRead;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

