/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.StringUtils;

public class SerializableArrayList<E extends IOReadableWritable>
extends ArrayList<E>
implements IOReadableWritable {
    private static final long serialVersionUID = 8196856588290198537L;

    public SerializableArrayList() {
    }

    public SerializableArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.size());
        for (IOReadableWritable element : this) {
            StringUtils.writeNullableString((String)element.getClass().getName(), (DataOutputView)out);
            element.write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        this.clear();
        int numberOfElements = in.readInt();
        for (int i = 0; i < numberOfElements; ++i) {
            IOReadableWritable element;
            String elementType = StringUtils.readNullableString((DataInputView)in);
            try {
                Class<?> clazz = Class.forName(elementType);
                element = (IOReadableWritable)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            element.read(in);
            this.add(element);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SerializableArrayList && super.equals(obj);
    }
}

