/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.util.InstantiationUtil;

public class SerializedValue<T>
implements Serializable {
    private static final long serialVersionUID = -3564011643393683761L;
    private final byte[] serializedData;

    public SerializedValue(T value) throws IOException {
        this.serializedData = value == null ? null : InstantiationUtil.serializeObject(value);
    }

    public T deserializeValue(ClassLoader loader) throws IOException, ClassNotFoundException {
        if (loader == null) {
            throw new NullPointerException();
        }
        return (T)(this.serializedData == null ? null : InstantiationUtil.deserializeObject((byte[])this.serializedData, (ClassLoader)loader));
    }

    public int hashCode() {
        return this.serializedData == null ? 0 : Arrays.hashCode(this.serializedData);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SerializedValue) {
            SerializedValue other = (SerializedValue)obj;
            return this.serializedData == null ? other.serializedData == null : other.serializedData != null && Arrays.equals(this.serializedData, other.serializedData);
        }
        return false;
    }

    public String toString() {
        return "SerializedValue";
    }
}

