/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.flink.util.Preconditions;

public class BoundedFIFOQueue<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = -890727339944580409L;
    private final int maxSize;
    private final Queue<T> elements;

    public BoundedFIFOQueue(int maxSize) {
        Preconditions.checkArgument((maxSize >= 0 ? 1 : 0) != 0, (Object)"The maximum size should be at least 0.");
        this.maxSize = maxSize;
        this.elements = new LinkedList<T>();
    }

    public void add(T element) {
        Preconditions.checkNotNull(element);
        if (this.elements.add(element) && this.elements.size() > this.maxSize) {
            this.elements.poll();
        }
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }
}

