/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.accumulators;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.OptionalFailure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringifiedAccumulatorResult
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(StringifiedAccumulatorResult.class);
    private static final long serialVersionUID = -4642311296836822611L;
    private final String name;
    private final String type;
    private final String value;

    public StringifiedAccumulatorResult(String name, String type, String value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public static StringifiedAccumulatorResult[] stringifyAccumulatorResults(Map<String, OptionalFailure<Accumulator<?, ?>>> accs) {
        if (accs == null || accs.isEmpty()) {
            return new StringifiedAccumulatorResult[0];
        }
        StringifiedAccumulatorResult[] results = new StringifiedAccumulatorResult[accs.size()];
        int i = 0;
        for (Map.Entry<String, OptionalFailure<Accumulator<?, ?>>> entry : accs.entrySet()) {
            results[i++] = StringifiedAccumulatorResult.stringifyAccumulatorResult(entry.getKey(), entry.getValue());
        }
        return results;
    }

    private static StringifiedAccumulatorResult stringifyAccumulatorResult(String name, @Nullable OptionalFailure<Accumulator<?, ?>> accumulator) {
        Object localValue;
        if (accumulator == null) {
            return new StringifiedAccumulatorResult(name, "null", "null");
        }
        if (accumulator.isFailure()) {
            return new StringifiedAccumulatorResult(name, "null", ExceptionUtils.stringifyException((Throwable)accumulator.getFailureCause()));
        }
        String simpleName = "null";
        try {
            simpleName = ((Accumulator)accumulator.getUnchecked()).getClass().getSimpleName();
            localValue = ((Accumulator)accumulator.getUnchecked()).getLocalValue();
        }
        catch (RuntimeException exception) {
            LOG.error("Failed to stringify accumulator [" + name + "]", (Throwable)exception);
            localValue = ExceptionUtils.stringifyException((Throwable)exception);
        }
        return new StringifiedAccumulatorResult(name, simpleName, localValue != null ? localValue.toString() : "null");
    }
}

