/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.ResourceConsumer;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateFactory;
import org.apache.flink.runtime.scheduler.adaptive.StateTransitions;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.slf4j.Logger;

class WaitingForResources
implements State,
ResourceConsumer {
    private final Context context;
    private final Logger log;
    private final ResourceCounter desiredResources;
    private final Clock clock;
    @Nullable
    private Deadline resourceStabilizationDeadline;
    private final Duration resourceStabilizationTimeout;
    @Nullable
    private ScheduledFuture<?> resourceTimeoutFuture;

    WaitingForResources(Context context, Logger log, ResourceCounter desiredResources, Duration initialResourceAllocationTimeout, Duration resourceStabilizationTimeout) {
        this(context, log, desiredResources, initialResourceAllocationTimeout, resourceStabilizationTimeout, (Clock)SystemClock.getInstance());
    }

    @VisibleForTesting
    WaitingForResources(Context context, Logger log, ResourceCounter desiredResources, Duration initialResourceAllocationTimeout, Duration resourceStabilizationTimeout, Clock clock) {
        this.context = (Context)Preconditions.checkNotNull((Object)context);
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
        this.desiredResources = (ResourceCounter)Preconditions.checkNotNull((Object)desiredResources);
        this.resourceStabilizationTimeout = (Duration)Preconditions.checkNotNull((Object)resourceStabilizationTimeout);
        this.clock = clock;
        Preconditions.checkNotNull((Object)initialResourceAllocationTimeout);
        Preconditions.checkArgument((!desiredResources.isEmpty() ? 1 : 0) != 0, (Object)"Desired resources must not be empty");
        Preconditions.checkArgument((!resourceStabilizationTimeout.isNegative() ? 1 : 0) != 0, (Object)"Resource stabilization timeout must not be negative");
        if (!initialResourceAllocationTimeout.isNegative()) {
            this.resourceTimeoutFuture = context.runIfState(this, this::resourceTimeout, initialResourceAllocationTimeout);
        }
        context.runIfState(this, this::notifyNewResourcesAvailable, Duration.ZERO);
    }

    @Override
    public void onLeave(Class<? extends State> newState) {
        if (this.resourceTimeoutFuture != null) {
            this.resourceTimeoutFuture.cancel(false);
        }
    }

    @Override
    public void cancel() {
        this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.CANCELED, null));
    }

    @Override
    public void suspend(Throwable cause) {
        this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.SUSPENDED, cause));
    }

    @Override
    public JobStatus getJobStatus() {
        return JobStatus.CREATED;
    }

    @Override
    public ArchivedExecutionGraph getJob() {
        return this.context.getArchivedExecutionGraph(this.getJobStatus(), null);
    }

    @Override
    public void handleGlobalFailure(Throwable cause) {
        this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.FAILED, cause));
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    @Override
    public void notifyNewResourcesAvailable() {
        this.checkDesiredOrSufficientResourcesAvailable();
    }

    private void checkDesiredOrSufficientResourcesAvailable() {
        if (this.context.hasDesiredResources(this.desiredResources)) {
            this.createExecutionGraphWithAvailableResources();
            return;
        }
        if (this.context.hasSufficientResources()) {
            if (this.resourceStabilizationDeadline == null) {
                this.resourceStabilizationDeadline = Deadline.fromNowWithClock((Duration)this.resourceStabilizationTimeout, (Clock)this.clock);
            }
            if (this.resourceStabilizationDeadline.isOverdue()) {
                this.createExecutionGraphWithAvailableResources();
            } else {
                this.context.runIfState(this, this::checkDesiredOrSufficientResourcesAvailable, this.resourceStabilizationDeadline.timeLeft());
            }
        } else {
            this.resourceStabilizationDeadline = null;
        }
    }

    private void resourceTimeout() {
        this.log.debug("Initial resource allocation timeout triggered: Creating ExecutionGraph with available resources.");
        this.createExecutionGraphWithAvailableResources();
    }

    private void createExecutionGraphWithAvailableResources() {
        this.context.goToCreatingExecutionGraph();
    }

    static class Factory
    implements StateFactory<WaitingForResources> {
        private final Context context;
        private final Logger log;
        private final ResourceCounter desiredResources;
        private final Duration initialResourceAllocationTimeout;
        private final Duration resourceStabilizationTimeout;

        public Factory(Context context, Logger log, ResourceCounter desiredResources, Duration initialResourceAllocationTimeout, Duration resourceStabilizationTimeout) {
            this.context = context;
            this.log = log;
            this.desiredResources = desiredResources;
            this.initialResourceAllocationTimeout = initialResourceAllocationTimeout;
            this.resourceStabilizationTimeout = resourceStabilizationTimeout;
        }

        @Override
        public Class<WaitingForResources> getStateClass() {
            return WaitingForResources.class;
        }

        @Override
        public WaitingForResources getState() {
            return new WaitingForResources(this.context, this.log, this.desiredResources, this.initialResourceAllocationTimeout, this.resourceStabilizationTimeout);
        }
    }

    static interface Context
    extends StateTransitions.ToCreatingExecutionGraph,
    StateTransitions.ToFinished {
        public ArchivedExecutionGraph getArchivedExecutionGraph(JobStatus var1, @Nullable Throwable var2);

        public boolean hasDesiredResources(ResourceCounter var1);

        public boolean hasSufficientResources();

        public ScheduledFuture<?> runIfState(State var1, Runnable var2, Duration var3);
    }
}

