/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.filesystem.FSDataOutputStreamWrapper;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsCompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.filesystem.MetadataOutputStreamWrapper;
import org.apache.flink.runtime.state.filesystem.RecoverableStreamWrapper;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FsCheckpointMetadataOutputStream
extends CheckpointMetadataOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(FsCheckpointMetadataOutputStream.class);
    private final Path metadataFilePath;
    private final Path exclusiveCheckpointDir;
    private final FileSystem fileSystem;
    private volatile boolean closed;
    private final MetadataOutputStreamWrapper outputStreamWrapper;

    public FsCheckpointMetadataOutputStream(FileSystem fileSystem, Path metadataFilePath, Path exclusiveCheckpointDir) throws IOException {
        this.fileSystem = (FileSystem)Preconditions.checkNotNull((Object)fileSystem);
        this.metadataFilePath = (Path)Preconditions.checkNotNull((Object)metadataFilePath);
        this.exclusiveCheckpointDir = (Path)Preconditions.checkNotNull((Object)exclusiveCheckpointDir);
        this.outputStreamWrapper = FsCheckpointMetadataOutputStream.getOutputStreamWrapper(fileSystem, metadataFilePath);
    }

    public final void write(int b) throws IOException {
        this.outputStreamWrapper.getOutput().write(b);
    }

    public final void write(@Nonnull byte[] b, int off, int len) throws IOException {
        this.outputStreamWrapper.getOutput().write(b, off, len);
    }

    public long getPos() throws IOException {
        return this.outputStreamWrapper.getOutput().getPos();
    }

    public void flush() throws IOException {
        this.outputStreamWrapper.getOutput().flush();
    }

    public void sync() throws IOException {
        this.outputStreamWrapper.getOutput().sync();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.outputStreamWrapper.close();
                this.outputStreamWrapper.cleanup();
            }
            catch (Throwable t) {
                LOG.warn("Could not close the state stream for {}.", (Object)this.metadataFilePath, (Object)t);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FsCompletedCheckpointStorageLocation closeAndFinalizeCheckpoint() throws IOException {
        FsCheckpointMetadataOutputStream fsCheckpointMetadataOutputStream = this;
        synchronized (fsCheckpointMetadataOutputStream) {
            if (this.closed) throw new IOException("Stream has already been closed and discarded.");
            try {
                long size = 0L;
                try {
                    size = this.outputStreamWrapper.getOutput().getPos();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.outputStreamWrapper.closeForCommit();
                FileStateHandle metaDataHandle = new FileStateHandle(this.metadataFilePath, size);
                FsCompletedCheckpointStorageLocation fsCompletedCheckpointStorageLocation = new FsCompletedCheckpointStorageLocation(this.fileSystem, this.exclusiveCheckpointDir, metaDataHandle, metaDataHandle.getFilePath().getParent().toString());
                return fsCompletedCheckpointStorageLocation;
            }
            catch (Exception e) {
                try {
                    this.outputStreamWrapper.cleanup();
                    throw new IOException("Could not flush and close the file system output stream to " + this.metadataFilePath + " in order to obtain the stream state handle", e);
                }
                catch (Exception deleteException) {
                    LOG.warn("Could not delete the checkpoint stream file {}.", (Object)this.metadataFilePath, (Object)deleteException);
                }
                throw new IOException("Could not flush and close the file system output stream to " + this.metadataFilePath + " in order to obtain the stream state handle", e);
            }
            finally {
                this.closed = true;
            }
        }
    }

    static MetadataOutputStreamWrapper getOutputStreamWrapper(FileSystem fileSystem, Path metadataFilePath) throws IOException {
        if (fileSystem.exists(metadataFilePath)) {
            throw new IOException("Target file " + metadataFilePath + " already exists.");
        }
        try {
            RecoverableWriter recoverableWriter = fileSystem.createRecoverableWriter();
            return new RecoverableStreamWrapper(recoverableWriter.open(metadataFilePath));
        }
        catch (Throwable throwable) {
            LOG.info("Cannot create recoverable writer due to {}, will use the ordinary writer.", (Object)throwable.getMessage());
            return new FSDataOutputStreamWrapper(fileSystem, metadataFilePath);
        }
    }
}

