/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexBackPressureInfo;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobVertexBackPressureHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, JobVertexBackPressureInfo, JobVertexMessageParameters> {
    private final MetricFetcher metricFetcher;

    public JobVertexBackPressureHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobVertexBackPressureInfo, JobVertexMessageParameters> messageHeaders, MetricFetcher metricFetcher) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.metricFetcher = metricFetcher;
    }

    @Override
    protected CompletableFuture<JobVertexBackPressureInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        this.metricFetcher.update();
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID jobVertexId = (JobVertexID)request.getPathParameter(JobVertexIdPathParameter.class);
        MetricStore.TaskMetricStore taskMetricStore = this.metricFetcher.getMetricStore().getTaskMetricStore(jobId.toString(), jobVertexId.toString());
        return CompletableFuture.completedFuture(taskMetricStore != null ? this.createJobVertexBackPressureInfo(taskMetricStore.getAllSubtaskMetricStores()) : JobVertexBackPressureInfo.deprecated());
    }

    private JobVertexBackPressureInfo createJobVertexBackPressureInfo(Map<Integer, MetricStore.ComponentMetricStore> allSubtaskMetricStores) {
        List<JobVertexBackPressureInfo.SubtaskBackPressureInfo> subtaskBackPressureInfos = this.createSubtaskBackPressureInfo(allSubtaskMetricStores);
        return new JobVertexBackPressureInfo(JobVertexBackPressureInfo.VertexBackPressureStatus.OK, JobVertexBackPressureHandler.getBackPressureLevel(this.getMaxBackPressureRatio(subtaskBackPressureInfos)), this.metricFetcher.getLastUpdateTime(), subtaskBackPressureInfos);
    }

    private List<JobVertexBackPressureInfo.SubtaskBackPressureInfo> createSubtaskBackPressureInfo(Map<Integer, MetricStore.ComponentMetricStore> subtaskMetricStores) {
        ArrayList<JobVertexBackPressureInfo.SubtaskBackPressureInfo> result = new ArrayList<JobVertexBackPressureInfo.SubtaskBackPressureInfo>(subtaskMetricStores.size());
        for (Map.Entry<Integer, MetricStore.ComponentMetricStore> entry : subtaskMetricStores.entrySet()) {
            int subtaskIndex = entry.getKey();
            MetricStore.ComponentMetricStore subtaskMetricStore = entry.getValue();
            double backPressureRatio = this.getBackPressureRatio(subtaskMetricStore);
            double idleRatio = this.getIdleRatio(subtaskMetricStore);
            double busyRatio = this.getBusyRatio(subtaskMetricStore);
            result.add(new JobVertexBackPressureInfo.SubtaskBackPressureInfo(subtaskIndex, JobVertexBackPressureHandler.getBackPressureLevel(backPressureRatio), backPressureRatio, idleRatio, busyRatio));
        }
        result.sort(Comparator.comparingInt(JobVertexBackPressureInfo.SubtaskBackPressureInfo::getSubtask));
        return result;
    }

    private double getMaxBackPressureRatio(List<JobVertexBackPressureInfo.SubtaskBackPressureInfo> subtaskBackPressureInfos) {
        return subtaskBackPressureInfos.stream().mapToDouble(backPressureInfo -> backPressureInfo.getBackPressuredRatio()).max().getAsDouble();
    }

    private double getBackPressureRatio(MetricStore.ComponentMetricStore metricStore) {
        return this.getMsPerSecondMetricAsRatio(metricStore, "backPressuredTimeMsPerSecond");
    }

    private double getIdleRatio(MetricStore.ComponentMetricStore metricStore) {
        return this.getMsPerSecondMetricAsRatio(metricStore, "idleTimeMsPerSecond");
    }

    private double getBusyRatio(MetricStore.ComponentMetricStore metricStore) {
        return this.getMsPerSecondMetricAsRatio(metricStore, "busyTimeMsPerSecond");
    }

    private double getMsPerSecondMetricAsRatio(MetricStore.ComponentMetricStore metricStore, String metricName) {
        return Double.valueOf(metricStore.getMetric(metricName, "0")) / 1000.0;
    }

    private static JobVertexBackPressureInfo.VertexBackPressureLevel getBackPressureLevel(double backPressureRatio) {
        if (backPressureRatio <= 0.1) {
            return JobVertexBackPressureInfo.VertexBackPressureLevel.OK;
        }
        if (backPressureRatio <= 0.5) {
            return JobVertexBackPressureInfo.VertexBackPressureLevel.LOW;
        }
        return JobVertexBackPressureInfo.VertexBackPressureLevel.HIGH;
    }
}

