/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotInfoTracker;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;

class DefaultLocationPreferenceSlotSelectionStrategy
extends LocationPreferenceSlotSelectionStrategy {
    DefaultLocationPreferenceSlotSelectionStrategy() {
    }

    @Override
    @Nonnull
    protected Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectWithoutLocationPreference(@Nonnull FreeSlotInfoTracker freeSlotInfoTracker, @Nonnull ResourceProfile resourceProfile) {
        for (AllocationID allocationId : freeSlotInfoTracker.getAvailableSlots()) {
            SlotInfo candidate = freeSlotInfoTracker.getSlotInfo(allocationId);
            if (!candidate.getResourceProfile().isMatching(resourceProfile)) continue;
            return Optional.of(SlotSelectionStrategy.SlotInfoAndLocality.of(candidate, Locality.UNCONSTRAINED));
        }
        return Optional.empty();
    }

    @Override
    protected double calculateCandidateScore(int localWeigh, int hostLocalWeigh, Supplier<Double> taskExecutorUtilizationSupplier) {
        return localWeigh * 10 + hostLocalWeigh;
    }
}

