/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.embedded;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.AbstractThreadsafeJobResultStore;
import org.apache.flink.runtime.highavailability.JobResultEntry;
import org.apache.flink.runtime.jobmaster.JobResult;

public class EmbeddedJobResultStore
extends AbstractThreadsafeJobResultStore {
    private final Map<JobID, JobResultEntry> dirtyJobResults = new HashMap<JobID, JobResultEntry>();
    private final Map<JobID, JobResultEntry> cleanJobResults = new HashMap<JobID, JobResultEntry>();

    @Override
    public void createDirtyResultInternal(JobResultEntry jobResultEntry) {
        this.dirtyJobResults.put(jobResultEntry.getJobId(), jobResultEntry);
    }

    @Override
    public void markResultAsCleanInternal(JobID jobId) throws IOException, NoSuchElementException {
        JobResultEntry jobResultEntry = this.dirtyJobResults.remove(jobId);
        if (jobResultEntry == null) {
            throw new NoSuchElementException(String.format("Could not mark job %s as clean as it is not present in the job result store.", jobId));
        }
        this.cleanJobResults.put(jobId, jobResultEntry);
    }

    @Override
    public boolean hasDirtyJobResultEntryInternal(JobID jobId) throws IOException {
        return this.dirtyJobResults.containsKey(jobId);
    }

    @Override
    public boolean hasCleanJobResultEntryInternal(JobID jobId) throws IOException {
        return this.cleanJobResults.containsKey(jobId);
    }

    @Override
    public Set<JobResult> getDirtyResultsInternal() throws IOException {
        return this.dirtyJobResults.values().stream().map(JobResultEntry::getJobResult).collect(Collectors.toSet());
    }
}

