/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.metrics.InputChannelMetrics;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.LocalInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RecoveredInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;

public class LocalRecoveredInputChannel
extends RecoveredInputChannel {
    private final ResultPartitionManager partitionManager;
    private final TaskEventPublisher taskEventPublisher;

    LocalRecoveredInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, int consumedSubpartitionIndex, ResultPartitionManager partitionManager, TaskEventPublisher taskEventPublisher, int initialBackOff, int maxBackoff, int networkBuffersPerChannel, InputChannelMetrics metrics) {
        super(inputGate, channelIndex, partitionId, consumedSubpartitionIndex, initialBackOff, maxBackoff, metrics.getNumBytesInLocalCounter(), metrics.getNumBuffersInLocalCounter(), networkBuffersPerChannel);
        this.partitionManager = (ResultPartitionManager)Preconditions.checkNotNull((Object)partitionManager);
        this.taskEventPublisher = (TaskEventPublisher)Preconditions.checkNotNull((Object)taskEventPublisher);
    }

    @Override
    protected InputChannel toInputChannelInternal() {
        return new LocalInputChannel(this.inputGate, this.getChannelIndex(), this.partitionId, this.consumedSubpartitionIndex, this.partitionManager, this.taskEventPublisher, this.initialBackoff, this.maxBackoff, this.numBytesIn, this.numBuffersIn, this.channelStateWriter);
    }
}

