/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.blocklist.BlockedTaskManagerChecker;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.metrics.groups.SlotManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManagerSlot;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocator;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceEventListener;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerException;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotStatusUpdateListener;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskExecutorManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.runtime.rest.messages.taskmanager.SlotInfo;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.runtime.slots.ResourceRequirements;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.exceptions.SlotOccupiedException;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeclarativeSlotManager
implements SlotManager {
    private static final Logger LOG = LoggerFactory.getLogger(DeclarativeSlotManager.class);
    private final SlotTracker slotTracker;
    private final ResourceTracker resourceTracker;
    private final BiFunction<Executor, ResourceAllocator, TaskExecutorManager> taskExecutorManagerFactory;
    @Nullable
    private TaskExecutorManager taskExecutorManager;
    private final Time taskManagerRequestTimeout;
    private final SlotMatchingStrategy slotMatchingStrategy;
    private final SlotManagerMetricGroup slotManagerMetricGroup;
    private final Map<JobID, String> jobMasterTargetAddresses = new HashMap<JobID, String>();
    private final Map<SlotID, AllocationID> pendingSlotAllocations;
    private final Duration requirementsCheckDelay;
    private boolean sendNotEnoughResourceNotifications = true;
    private final ScheduledExecutor scheduledExecutor;
    @Nullable
    private ResourceManagerId resourceManagerId;
    @Nullable
    private Executor mainThreadExecutor;
    @Nullable
    private ResourceEventListener resourceEventListener;
    @Nullable
    private CompletableFuture<Void> requirementsCheckFuture;
    @Nullable
    private BlockedTaskManagerChecker blockedTaskManagerChecker;
    private boolean started;

    public DeclarativeSlotManager(ScheduledExecutor scheduledExecutor, SlotManagerConfiguration slotManagerConfiguration, SlotManagerMetricGroup slotManagerMetricGroup, ResourceTracker resourceTracker, SlotTracker slotTracker) {
        Preconditions.checkNotNull((Object)slotManagerConfiguration);
        this.taskManagerRequestTimeout = slotManagerConfiguration.getTaskManagerRequestTimeout();
        this.slotManagerMetricGroup = (SlotManagerMetricGroup)Preconditions.checkNotNull((Object)slotManagerMetricGroup);
        this.resourceTracker = (ResourceTracker)Preconditions.checkNotNull((Object)resourceTracker);
        this.scheduledExecutor = (ScheduledExecutor)Preconditions.checkNotNull((Object)scheduledExecutor);
        this.requirementsCheckDelay = slotManagerConfiguration.getRequirementCheckDelay();
        this.pendingSlotAllocations = CollectionUtil.newHashMapWithExpectedSize((int)16);
        this.slotTracker = (SlotTracker)Preconditions.checkNotNull((Object)slotTracker);
        slotTracker.registerSlotStatusUpdateListener(this.createSlotStatusUpdateListener());
        this.slotMatchingStrategy = slotManagerConfiguration.getSlotMatchingStrategy();
        this.taskExecutorManagerFactory = (executor, resourceAllocator) -> new TaskExecutorManager(slotManagerConfiguration.getDefaultWorkerResourceSpec(), slotManagerConfiguration.getNumSlotsPerWorker(), slotManagerConfiguration.getMaxSlotNum(), slotManagerConfiguration.isWaitResultConsumedBeforeRelease(), slotManagerConfiguration.getRedundantTaskManagerNum(), slotManagerConfiguration.getTaskManagerTimeout(), slotManagerConfiguration.getDeclareNeededResourceDelay(), scheduledExecutor, (Executor)executor, (ResourceAllocator)resourceAllocator);
        this.resourceManagerId = null;
        this.resourceEventListener = null;
        this.mainThreadExecutor = null;
        this.taskExecutorManager = null;
        this.blockedTaskManagerChecker = null;
        this.started = false;
    }

    private SlotStatusUpdateListener createSlotStatusUpdateListener() {
        return (taskManagerSlot, previous, current, jobId) -> {
            if (previous == SlotState.PENDING) {
                this.pendingSlotAllocations.remove(taskManagerSlot.getSlotId());
            }
            if (current == SlotState.PENDING) {
                this.resourceTracker.notifyAcquiredResource(jobId, taskManagerSlot.getResourceProfile());
            }
            if (current == SlotState.FREE) {
                this.resourceTracker.notifyLostResource(jobId, taskManagerSlot.getResourceProfile());
            }
            if (current == SlotState.ALLOCATED) {
                this.taskExecutorManager.occupySlot(taskManagerSlot.getInstanceId());
            }
            if (previous == SlotState.ALLOCATED && current == SlotState.FREE) {
                this.taskExecutorManager.freeSlot(taskManagerSlot.getInstanceId());
            }
        };
    }

    @Override
    public void setFailUnfulfillableRequest(boolean failUnfulfillableRequest) {
        this.sendNotEnoughResourceNotifications = failUnfulfillableRequest;
        if (failUnfulfillableRequest) {
            this.checkResourceRequirementsWithDelay();
        }
    }

    @Override
    public void triggerResourceRequirementsCheck() {
        this.checkResourceRequirementsWithDelay();
    }

    @Override
    public void start(ResourceManagerId newResourceManagerId, Executor newMainThreadExecutor, ResourceAllocator newResourceAllocator, ResourceEventListener newResourceEventListener, BlockedTaskManagerChecker newBlockedTaskManagerChecker) {
        LOG.debug("Starting the slot manager.");
        this.resourceManagerId = (ResourceManagerId)((Object)Preconditions.checkNotNull((Object)((Object)newResourceManagerId)));
        this.mainThreadExecutor = (Executor)Preconditions.checkNotNull((Object)newMainThreadExecutor);
        this.resourceEventListener = (ResourceEventListener)Preconditions.checkNotNull((Object)newResourceEventListener);
        this.taskExecutorManager = this.taskExecutorManagerFactory.apply(newMainThreadExecutor, newResourceAllocator);
        this.blockedTaskManagerChecker = (BlockedTaskManagerChecker)Preconditions.checkNotNull((Object)newBlockedTaskManagerChecker);
        this.started = true;
        this.registerSlotManagerMetrics();
    }

    private void registerSlotManagerMetrics() {
        this.slotManagerMetricGroup.gauge("taskSlotsAvailable", () -> (long)this.getNumberFreeSlots());
        this.slotManagerMetricGroup.gauge("taskSlotsTotal", () -> (long)this.getNumberRegisteredSlots());
    }

    @Override
    public void suspend() {
        if (!this.started) {
            return;
        }
        LOG.info("Suspending the slot manager.");
        this.slotManagerMetricGroup.close();
        this.resourceTracker.clear();
        if (this.taskExecutorManager != null) {
            this.taskExecutorManager.close();
            for (InstanceID registeredTaskManager : this.taskExecutorManager.getTaskExecutors()) {
                this.unregisterTaskManager(registeredTaskManager, (Exception)((Object)new SlotManagerException("The slot manager is being suspended.")));
            }
        }
        this.taskExecutorManager = null;
        this.resourceManagerId = null;
        this.resourceEventListener = null;
        this.blockedTaskManagerChecker = null;
        this.started = false;
    }

    @Override
    public void close() throws Exception {
        LOG.info("Closing the slot manager.");
        this.suspend();
    }

    @Override
    public void clearResourceRequirements(JobID jobId) {
        this.checkInit();
        this.maybeReclaimInactiveSlots(jobId);
        this.jobMasterTargetAddresses.remove(jobId);
        this.resourceTracker.notifyResourceRequirements(jobId, Collections.emptyList());
    }

    @Override
    public void processResourceRequirements(ResourceRequirements resourceRequirements) {
        this.checkInit();
        if (resourceRequirements.getResourceRequirements().isEmpty() && this.resourceTracker.isRequirementEmpty(resourceRequirements.getJobId())) {
            return;
        }
        if (resourceRequirements.getResourceRequirements().isEmpty()) {
            LOG.info("Clearing resource requirements of job {}", (Object)resourceRequirements.getJobId());
        } else {
            LOG.info("Received resource requirements from job {}: {}", (Object)resourceRequirements.getJobId(), resourceRequirements.getResourceRequirements());
        }
        if (!resourceRequirements.getResourceRequirements().isEmpty()) {
            this.jobMasterTargetAddresses.put(resourceRequirements.getJobId(), resourceRequirements.getTargetAddress());
        }
        this.resourceTracker.notifyResourceRequirements(resourceRequirements.getJobId(), resourceRequirements.getResourceRequirements());
        this.checkResourceRequirementsWithDelay();
    }

    private void maybeReclaimInactiveSlots(JobID jobId) {
        if (!this.resourceTracker.getAcquiredResources(jobId).isEmpty()) {
            Collection<TaskExecutorConnection> taskExecutorsWithAllocatedSlots = this.slotTracker.getTaskExecutorsWithAllocatedSlotsForJob(jobId);
            for (TaskExecutorConnection taskExecutorConnection : taskExecutorsWithAllocatedSlots) {
                TaskExecutorGateway taskExecutorGateway = taskExecutorConnection.getTaskExecutorGateway();
                taskExecutorGateway.freeInactiveSlots(jobId, this.taskManagerRequestTimeout);
            }
        }
    }

    @Override
    public SlotManager.RegistrationResult registerTaskManager(TaskExecutorConnection taskExecutorConnection, SlotReport initialSlotReport, ResourceProfile totalResourceProfile, ResourceProfile defaultSlotResourceProfile) {
        this.checkInit();
        LOG.debug("Registering task executor {} under {} at the slot manager.", (Object)taskExecutorConnection.getResourceID(), (Object)taskExecutorConnection.getInstanceID());
        if (this.taskExecutorManager.isTaskManagerRegistered(taskExecutorConnection.getInstanceID())) {
            LOG.debug("Task executor {} was already registered.", (Object)taskExecutorConnection.getResourceID());
            this.reportSlotStatus(taskExecutorConnection.getInstanceID(), initialSlotReport);
            return SlotManager.RegistrationResult.IGNORED;
        }
        if (!this.taskExecutorManager.registerTaskManager(taskExecutorConnection, initialSlotReport, totalResourceProfile, defaultSlotResourceProfile)) {
            LOG.debug("Task executor {} could not be registered.", (Object)taskExecutorConnection.getResourceID());
            return SlotManager.RegistrationResult.REJECTED;
        }
        for (SlotStatus slotStatus : initialSlotReport) {
            this.slotTracker.addSlot(slotStatus.getSlotID(), slotStatus.getResourceProfile(), taskExecutorConnection, slotStatus.getJobID());
        }
        this.checkResourceRequirementsWithDelay();
        return SlotManager.RegistrationResult.SUCCESS;
    }

    @Override
    public boolean unregisterTaskManager(InstanceID instanceId, Exception cause) {
        this.checkInit();
        LOG.debug("Unregistering task executor {} from the slot manager.", (Object)instanceId);
        if (this.taskExecutorManager.isTaskManagerRegistered(instanceId)) {
            this.slotTracker.removeSlots(this.taskExecutorManager.getSlotsOf(instanceId));
            this.taskExecutorManager.unregisterTaskExecutor(instanceId);
            this.checkResourceRequirementsWithDelay();
            return true;
        }
        LOG.debug("There is no task executor registered with instance ID {}. Ignoring this message.", (Object)instanceId);
        return false;
    }

    @Override
    public boolean reportSlotStatus(InstanceID instanceId, SlotReport slotReport) {
        this.checkInit();
        LOG.debug("Received slot report from instance {}: {}.", (Object)instanceId, (Object)slotReport);
        if (this.taskExecutorManager.isTaskManagerRegistered(instanceId)) {
            if (this.slotTracker.notifySlotStatus(slotReport)) {
                this.checkResourceRequirementsWithDelay();
            }
            return true;
        }
        LOG.debug("Received slot report for unknown task manager with instance id {}. Ignoring this report.", (Object)instanceId);
        return false;
    }

    @Override
    public void freeSlot(SlotID slotId, AllocationID allocationId) {
        this.checkInit();
        LOG.debug("Freeing slot {}.", (Object)slotId);
        this.slotTracker.notifyFree(slotId);
        this.checkResourceRequirementsWithDelay();
    }

    private void checkResourceRequirementsWithDelay() {
        if (this.requirementsCheckDelay.toMillis() <= 0L) {
            this.checkResourceRequirements();
        } else if (this.requirementsCheckFuture == null || this.requirementsCheckFuture.isDone()) {
            this.requirementsCheckFuture = new CompletableFuture();
            this.scheduledExecutor.schedule(() -> this.mainThreadExecutor.execute(() -> {
                this.checkResourceRequirements();
                ((CompletableFuture)Preconditions.checkNotNull(this.requirementsCheckFuture)).complete(null);
            }), this.requirementsCheckDelay.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private void checkResourceRequirements() {
        Map<JobID, Collection<ResourceRequirement>> missingResources = this.resourceTracker.getMissingResources();
        if (missingResources.isEmpty()) {
            this.taskExecutorManager.clearPendingTaskManagerSlots();
            return;
        }
        LinkedHashMap<JobID, ResourceCounter> unfulfilledRequirements = new LinkedHashMap<JobID, ResourceCounter>();
        for (Map.Entry<JobID, Collection<ResourceRequirement>> resourceRequirements : missingResources.entrySet()) {
            JobID jobId = resourceRequirements.getKey();
            ResourceCounter unfulfilledJobRequirements = this.tryAllocateSlotsForJob(jobId, resourceRequirements.getValue());
            if (unfulfilledJobRequirements.isEmpty()) continue;
            unfulfilledRequirements.put(jobId, unfulfilledJobRequirements);
        }
        if (unfulfilledRequirements.isEmpty()) {
            return;
        }
        ResourceCounter freePendingSlots = ResourceCounter.withResources(this.taskExecutorManager.getPendingTaskManagerSlots().stream().collect(Collectors.groupingBy(PendingTaskManagerSlot::getResourceProfile, Collectors.summingInt(x -> 1))));
        for (Map.Entry unfulfilledRequirement : unfulfilledRequirements.entrySet()) {
            freePendingSlots = this.tryFulfillRequirementsWithPendingSlots((JobID)unfulfilledRequirement.getKey(), ((ResourceCounter)unfulfilledRequirement.getValue()).getResourcesWithCount(), freePendingSlots);
        }
        if (!freePendingSlots.isEmpty()) {
            this.taskExecutorManager.removePendingTaskManagerSlots(freePendingSlots);
        }
    }

    private ResourceCounter tryAllocateSlotsForJob(JobID jobId, Collection<ResourceRequirement> missingResources) {
        ResourceCounter outstandingRequirements = ResourceCounter.empty();
        for (ResourceRequirement resourceRequirement : missingResources) {
            int numMissingSlots = this.internalTryAllocateSlots(jobId, this.jobMasterTargetAddresses.get(jobId), resourceRequirement);
            if (numMissingSlots <= 0) continue;
            outstandingRequirements = outstandingRequirements.add(resourceRequirement.getResourceProfile(), numMissingSlots);
        }
        return outstandingRequirements;
    }

    private int internalTryAllocateSlots(JobID jobId, String targetAddress, ResourceRequirement resourceRequirement) {
        ResourceProfile requiredResource = resourceRequirement.getResourceProfile();
        LinkedHashMap<SlotID, TaskManagerSlotInformation> availableSlots = new LinkedHashMap<SlotID, TaskManagerSlotInformation>();
        for (TaskManagerSlotInformation freeSlot : this.slotTracker.getFreeSlots()) {
            if (this.isBlockedTaskManager(freeSlot.getTaskManagerConnection().getResourceID())) continue;
            availableSlots.put(freeSlot.getSlotId(), freeSlot);
        }
        int numUnfulfilled = 0;
        for (int x = 0; x < resourceRequirement.getNumberOfRequiredSlots(); ++x) {
            Optional reservedSlot = this.slotMatchingStrategy.findMatchingSlot(requiredResource, availableSlots.values(), this::getNumberRegisteredSlotsOf);
            if (!reservedSlot.isPresent()) {
                int numRemaining = resourceRequirement.getNumberOfRequiredSlots() - x;
                numUnfulfilled += numRemaining;
                break;
            }
            this.allocateSlot((TaskManagerSlotInformation)reservedSlot.get(), jobId, targetAddress, requiredResource);
            availableSlots.remove(((TaskManagerSlotInformation)reservedSlot.get()).getSlotId());
        }
        return numUnfulfilled;
    }

    private boolean isBlockedTaskManager(ResourceID resourceID) {
        Preconditions.checkNotNull((Object)this.blockedTaskManagerChecker);
        return this.blockedTaskManagerChecker.isBlockedTaskManager(resourceID);
    }

    private void allocateSlot(TaskManagerSlotInformation taskManagerSlot, JobID jobId, String targetAddress, ResourceProfile resourceProfile) {
        SlotID slotId = taskManagerSlot.getSlotId();
        LOG.debug("Starting allocation of slot {} for job {} with resource profile {}.", new Object[]{slotId, jobId, resourceProfile});
        InstanceID instanceId = taskManagerSlot.getInstanceId();
        if (!this.taskExecutorManager.isTaskManagerRegistered(instanceId)) {
            throw new IllegalStateException("Could not find a registered task manager for instance id " + (Object)((Object)instanceId) + '.');
        }
        TaskExecutorConnection taskExecutorConnection = taskManagerSlot.getTaskManagerConnection();
        TaskExecutorGateway gateway = taskExecutorConnection.getTaskExecutorGateway();
        AllocationID allocationId = new AllocationID();
        this.slotTracker.notifyAllocationStart(slotId, jobId);
        this.taskExecutorManager.markUsed(instanceId);
        this.pendingSlotAllocations.put(slotId, allocationId);
        CompletableFuture<Acknowledge> requestFuture = gateway.requestSlot(slotId, jobId, allocationId, resourceProfile, targetAddress, this.resourceManagerId, this.taskManagerRequestTimeout);
        CompletionStage slotAllocationResponseProcessingFuture = requestFuture.handleAsync((acknowledge, throwable) -> {
            AllocationID currentAllocationForSlot = this.pendingSlotAllocations.get(slotId);
            if (currentAllocationForSlot == null || !currentAllocationForSlot.equals((Object)allocationId)) {
                LOG.debug("Ignoring slot allocation update from task executor {} for slot {} and job {}, because the allocation was already completed or cancelled.", new Object[]{instanceId, slotId, jobId});
                return null;
            }
            if (acknowledge != null) {
                LOG.trace("Completed allocation of slot {} for job {}.", (Object)slotId, (Object)jobId);
                this.slotTracker.notifyAllocationComplete(slotId, jobId);
            } else {
                if (throwable instanceof SlotOccupiedException) {
                    SlotOccupiedException exception = (SlotOccupiedException)throwable;
                    LOG.debug("Tried allocating slot {} for job {}, but it was already allocated for job {}.", new Object[]{slotId, jobId, exception.getJobId()});
                    this.slotTracker.notifySlotStatus(Collections.singleton(new SlotStatus(slotId, taskManagerSlot.getResourceProfile(), exception.getJobId(), exception.getAllocationId())));
                } else {
                    LOG.warn("Slot allocation for slot {} for job {} failed.", new Object[]{slotId, jobId, throwable});
                    this.slotTracker.notifyFree(slotId);
                }
                this.checkResourceRequirementsWithDelay();
            }
            return null;
        }, this.mainThreadExecutor);
        FutureUtils.assertNoException((CompletableFuture)slotAllocationResponseProcessingFuture);
    }

    private ResourceCounter tryFulfillRequirementsWithPendingSlots(JobID jobId, Collection<Map.Entry<ResourceProfile, Integer>> missingResources, ResourceCounter pendingSlots) {
        for (Map.Entry<ResourceProfile, Integer> missingResource : missingResources) {
            ResourceProfile profile = missingResource.getKey();
            for (int i = 0; i < missingResource.getValue(); ++i) {
                MatchingResult matchingResult = this.tryFulfillWithPendingSlots(profile, pendingSlots);
                pendingSlots = matchingResult.getNewAvailableResources();
                if (matchingResult.isSuccessfulMatching()) continue;
                WorkerAllocationResult allocationResult = this.tryAllocateWorkerAndReserveSlot(profile, pendingSlots);
                pendingSlots = allocationResult.getNewAvailableResources();
                if (allocationResult.isSuccessfulAllocating() || !this.sendNotEnoughResourceNotifications) continue;
                LOG.warn("Could not fulfill resource requirements of job {}. Free slots: {}", (Object)jobId, (Object)this.slotTracker.getFreeSlots().size());
                this.resourceEventListener.notEnoughResourceAvailable(jobId, this.resourceTracker.getAcquiredResources(jobId));
                return pendingSlots;
            }
        }
        return pendingSlots;
    }

    private MatchingResult tryFulfillWithPendingSlots(ResourceProfile resourceProfile, ResourceCounter pendingSlots) {
        Set<ResourceProfile> pendingSlotProfiles = pendingSlots.getResources();
        if (pendingSlotProfiles.contains(resourceProfile)) {
            pendingSlots = pendingSlots.subtract(resourceProfile, 1);
            return new MatchingResult(true, pendingSlots);
        }
        for (ResourceProfile pendingSlotProfile : pendingSlotProfiles) {
            if (!pendingSlotProfile.isMatching(resourceProfile)) continue;
            pendingSlots = pendingSlots.subtract(pendingSlotProfile, 1);
            return new MatchingResult(true, pendingSlots);
        }
        return new MatchingResult(false, pendingSlots);
    }

    private WorkerAllocationResult tryAllocateWorkerAndReserveSlot(ResourceProfile profile, ResourceCounter pendingSlots) {
        Optional<ResourceRequirement> newlyFulfillableRequirements = this.taskExecutorManager.allocateWorker(profile);
        if (newlyFulfillableRequirements.isPresent()) {
            ResourceRequirement newSlots = newlyFulfillableRequirements.get();
            if (newSlots.getNumberOfRequiredSlots() > 1) {
                pendingSlots = pendingSlots.add(newSlots.getResourceProfile(), newSlots.getNumberOfRequiredSlots() - 1);
            }
            return new WorkerAllocationResult(true, pendingSlots);
        }
        return new WorkerAllocationResult(false, pendingSlots);
    }

    @Override
    public int getNumberRegisteredSlots() {
        return this.taskExecutorManager.getNumberRegisteredSlots();
    }

    @Override
    public int getNumberRegisteredSlotsOf(InstanceID instanceId) {
        return this.taskExecutorManager.getNumberRegisteredSlotsOf(instanceId);
    }

    @Override
    public int getNumberFreeSlots() {
        return this.taskExecutorManager.getNumberFreeSlots();
    }

    @Override
    public int getNumberFreeSlotsOf(InstanceID instanceId) {
        return this.taskExecutorManager.getNumberFreeSlotsOf(instanceId);
    }

    @Override
    public ResourceProfile getRegisteredResource() {
        return this.taskExecutorManager.getTotalRegisteredResources();
    }

    @Override
    public ResourceProfile getRegisteredResourceOf(InstanceID instanceID) {
        return this.taskExecutorManager.getTotalRegisteredResourcesOf(instanceID);
    }

    @Override
    public ResourceProfile getFreeResource() {
        return this.taskExecutorManager.getTotalFreeResources();
    }

    @Override
    public ResourceProfile getFreeResourceOf(InstanceID instanceID) {
        return this.taskExecutorManager.getTotalFreeResourcesOf(instanceID);
    }

    @Override
    public Collection<SlotInfo> getAllocatedSlotsOf(InstanceID instanceID) {
        return Collections.emptyList();
    }

    private void checkInit() {
        Preconditions.checkState((boolean)this.started, (Object)"The slot manager has not been started.");
    }

    private static class WorkerAllocationResult {
        private final boolean isSuccessfulAllocating;
        private final ResourceCounter newAvailableResources;

        private WorkerAllocationResult(boolean isSuccessfulAllocating, ResourceCounter newAvailableResources) {
            this.isSuccessfulAllocating = isSuccessfulAllocating;
            this.newAvailableResources = (ResourceCounter)Preconditions.checkNotNull((Object)newAvailableResources);
        }

        private ResourceCounter getNewAvailableResources() {
            return this.newAvailableResources;
        }

        private boolean isSuccessfulAllocating() {
            return this.isSuccessfulAllocating;
        }
    }

    private static class MatchingResult {
        private final boolean isSuccessfulMatching;
        private final ResourceCounter newAvailableResources;

        private MatchingResult(boolean isSuccessfulMatching, ResourceCounter newAvailableResources) {
            this.isSuccessfulMatching = isSuccessfulMatching;
            this.newAvailableResources = (ResourceCounter)Preconditions.checkNotNull((Object)newAvailableResources);
        }

        private ResourceCounter getNewAvailableResources() {
            return this.newAvailableResources;
        }

        private boolean isSuccessfulMatching() {
            return this.isSuccessfulMatching;
        }
    }
}

