/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalFile {
    private static final Logger LOG = LoggerFactory.getLogger(PhysicalFile.class);
    @Nullable
    private FSDataOutputStream outputStream;
    private final AtomicInteger logicalFileRefCount;
    private final AtomicLong size;
    private final AtomicLong dataSize;
    @Nullable
    private final PhysicalFileDeleter deleter;
    private final Path filePath;
    private final CheckpointedStateScope scope;
    private boolean closed;
    private boolean deleted = false;
    private boolean isOwned;
    private boolean couldReuse;

    public PhysicalFile(@Nullable FSDataOutputStream outputStream, Path filePath, @Nullable PhysicalFileDeleter deleter, CheckpointedStateScope scope) {
        this(outputStream, filePath, deleter, scope, true);
    }

    public PhysicalFile(@Nullable FSDataOutputStream outputStream, Path filePath, @Nullable PhysicalFileDeleter deleter, CheckpointedStateScope scope, boolean owned) {
        this.filePath = filePath;
        this.outputStream = outputStream;
        this.closed = outputStream == null;
        this.deleter = deleter;
        this.scope = scope;
        this.size = new AtomicLong(0L);
        this.dataSize = new AtomicLong(0L);
        this.couldReuse = owned;
        this.logicalFileRefCount = new AtomicInteger(0);
        this.isOwned = owned;
    }

    @Nullable
    public FSDataOutputStream getOutputStream() {
        return this.outputStream;
    }

    void incRefCount() {
        int newValue = this.logicalFileRefCount.incrementAndGet();
        LOG.trace("Increase the reference count of physical file: {} by 1. New value is: {}.", (Object)this.filePath, (Object)newValue);
    }

    void decRefCount() throws IOException {
        Preconditions.checkArgument((this.logicalFileRefCount.get() > 0 ? 1 : 0) != 0);
        int newValue = this.logicalFileRefCount.decrementAndGet();
        LOG.trace("Decrease the reference count of physical file: {} by 1. New value is: {}. ", (Object)this.filePath, (Object)newValue);
        this.deleteIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIfNecessary() throws IOException {
        PhysicalFile physicalFile = this;
        synchronized (physicalFile) {
            if (!this.isOpen() && !this.deleted && this.logicalFileRefCount.get() <= 0) {
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Fail to close output stream when deleting file: {}", (Object)this.filePath);
                    }
                }
                if (this.deleter != null && this.isOwned) {
                    this.deleter.perform(this.filePath, this.size.get());
                } else {
                    LOG.debug("Skip deleting this file {} because it is not owned by FileMergingManager.", (Object)this.filePath);
                }
                this.deleted = true;
            }
        }
    }

    void incSize(long delta) {
        this.dataSize.addAndGet(delta);
        if (!this.closed) {
            this.size.addAndGet(delta);
        }
    }

    void decSize(long delta) {
        this.dataSize.addAndGet(-delta);
    }

    long getSize() {
        return this.size.get();
    }

    long wastedSize() {
        return this.size.get() - this.dataSize.get();
    }

    void updateSize(long updated) {
        this.size.set(updated);
    }

    boolean isCouldReuse() {
        return !this.closed || this.couldReuse;
    }

    boolean checkReuseOnSpaceAmplification(float maxAmp) {
        if (!this.closed) {
            return true;
        }
        if (this.couldReuse && (this.dataSize.get() == 0L || (float)this.dataSize.get() * maxAmp < (float)this.size.get())) {
            this.couldReuse = false;
        }
        return this.couldReuse;
    }

    @VisibleForTesting
    int getRefCount() {
        return this.logicalFileRefCount.get();
    }

    public boolean closed() {
        return this.closed;
    }

    public void close() throws IOException {
        this.innerClose();
        this.deleteIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerClose() throws IOException {
        PhysicalFile physicalFile = this;
        synchronized (physicalFile) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
    }

    public boolean isOpen() {
        return !this.closed && this.outputStream != null;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public CheckpointedStateScope getScope() {
        return this.scope;
    }

    public boolean isOwned() {
        return this.isOwned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalFile that = (PhysicalFile)o;
        return this.isOwned == that.isOwned && this.filePath.equals((Object)that.filePath);
    }

    public String toString() {
        return String.format("Physical File: [%s], owned: %s, closed: %s, logicalFileRefCount: %d", this.filePath, this.isOwned, this.closed, this.logicalFileRefCount.get());
    }

    @FunctionalInterface
    public static interface PhysicalFileCreator {
        public PhysicalFile perform(FileMergingSnapshotManager.SubtaskKey var1, CheckpointedStateScope var2) throws IOException;
    }

    @FunctionalInterface
    public static interface PhysicalFileDeleter {
        public void perform(Path var1, long var2) throws IOException;
    }
}

