/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFile;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFileReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyService;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerSpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemorySpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierProducerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteStorageScanner;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierProducerAgent;
import org.apache.flink.runtime.util.ConfigurationParserUtils;
import org.apache.flink.util.Preconditions;

public class RemoteTierFactory
implements TierFactory {
    private static final String DEFAULT_REMOTE_STORAGE_BASE_PATH = null;
    private static final int DEFAULT_REMOTE_TIER_EXCLUSIVE_BUFFERS = 1;
    private static final int DEFAULT_REMOTE_TIER_NUM_BYTES_PER_SEGMENT = 524288;
    private int bufferSizeBytes = -1;
    private String remoteStoragePath = DEFAULT_REMOTE_STORAGE_BASE_PATH;

    @Override
    public void setup(Configuration configuration) {
        this.bufferSizeBytes = ConfigurationParserUtils.getPageSize(configuration);
        this.remoteStoragePath = (String)Preconditions.checkNotNull((Object)configuration.get(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_REMOTE_STORAGE_BASE_PATH));
    }

    @Override
    public TieredStorageMemorySpec getMasterAgentMemorySpec() {
        return new TieredStorageMemorySpec(TieredStorageUtils.getRemoteTierName(), 0);
    }

    @Override
    public TieredStorageMemorySpec getProducerAgentMemorySpec() {
        return new TieredStorageMemorySpec(TieredStorageUtils.getRemoteTierName(), 1);
    }

    @Override
    public TieredStorageMemorySpec getConsumerAgentMemorySpec() {
        return new TieredStorageMemorySpec(TieredStorageUtils.getRemoteTierName(), 0);
    }

    @Override
    public TierMasterAgent createMasterAgent(TieredStorageResourceRegistry resourceRegistry) {
        return new RemoteTierMasterAgent(this.remoteStoragePath, resourceRegistry);
    }

    @Override
    public TierProducerAgent createProducerAgent(int numPartitions, int numSubpartitions, TieredStoragePartitionId partitionID, String dataFileBasePath, boolean isBroadcastOnly, TieredStorageMemoryManager storageMemoryManager, TieredStorageNettyService nettyService, TieredStorageResourceRegistry resourceRegistry, BatchShuffleReadBufferPool bufferPool, ScheduledExecutorService ioExecutor, List<TierShuffleDescriptor> shuffleDescriptors, int maxRequestedBuffers) {
        Preconditions.checkState((this.bufferSizeBytes > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)this.remoteStoragePath);
        SegmentPartitionFileWriter partitionFileWriter = SegmentPartitionFile.createPartitionFileWriter(this.remoteStoragePath, numSubpartitions);
        return new RemoteTierProducerAgent(partitionID, numSubpartitions, 524288, this.bufferSizeBytes, isBroadcastOnly, partitionFileWriter, storageMemoryManager, resourceRegistry);
    }

    @Override
    public TierConsumerAgent createConsumerAgent(List<TieredStorageConsumerSpec> tieredStorageConsumerSpecs, List<TierShuffleDescriptor> shuffleDescriptors, TieredStorageNettyService nettyService) {
        SegmentPartitionFileReader partitionFileReader = SegmentPartitionFile.createPartitionFileReader(this.remoteStoragePath);
        RemoteStorageScanner remoteStorageScanner = new RemoteStorageScanner(this.remoteStoragePath);
        return new RemoteTierConsumerAgent(tieredStorageConsumerSpecs, remoteStorageScanner, partitionFileReader, this.bufferSizeBytes);
    }
}

