/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.util;

import javax.annotation.Nullable;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;

public class MutableIOMetrics
extends IOMetrics {
    private static final long serialVersionUID = -5460777634971381737L;
    private boolean numBytesInComplete = true;
    private boolean numBytesOutComplete = true;
    private boolean numRecordsInComplete = true;
    private boolean numRecordsOutComplete = true;

    public MutableIOMetrics() {
        super(0L, 0L, 0L, 0L, 0L, 0.0, 0L);
    }

    public boolean isNumBytesInComplete() {
        return this.numBytesInComplete;
    }

    public boolean isNumBytesOutComplete() {
        return this.numBytesOutComplete;
    }

    public boolean isNumRecordsInComplete() {
        return this.numRecordsInComplete;
    }

    public boolean isNumRecordsOutComplete() {
        return this.numRecordsOutComplete;
    }

    public void addIOMetrics(AccessExecution attempt, @Nullable MetricFetcher fetcher, String jobID, String taskID) {
        if (attempt.getState().isTerminal()) {
            IOMetrics ioMetrics = attempt.getIOMetrics();
            if (ioMetrics != null) {
                this.numBytesIn += ioMetrics.getNumBytesIn();
                this.numBytesOut += ioMetrics.getNumBytesOut();
                this.numRecordsIn += ioMetrics.getNumRecordsIn();
                this.numRecordsOut += ioMetrics.getNumRecordsOut();
                this.accumulateBackPressuredTime += ioMetrics.getAccumulateBackPressuredTime();
                this.accumulateIdleTime += ioMetrics.getAccumulateIdleTime();
                this.accumulateBusyTime = Double.isNaN(ioMetrics.getAccumulateBusyTime()) ? Double.NaN : (this.accumulateBusyTime += ioMetrics.getAccumulateBusyTime());
            }
        } else if (fetcher != null) {
            fetcher.update();
            MetricStore.ComponentMetricStore metrics = fetcher.getMetricStore().getSubtaskAttemptMetricStore(jobID, taskID, attempt.getParallelSubtaskIndex(), attempt.getAttemptNumber());
            if (metrics != null) {
                if (metrics.getMetric("numBytesIn") == null) {
                    this.numBytesInComplete = false;
                } else {
                    this.numBytesIn += Long.valueOf(metrics.getMetric("numBytesIn")).longValue();
                }
                if (metrics.getMetric("numBytesOut") == null) {
                    this.numBytesOutComplete = false;
                } else {
                    this.numBytesOut += Long.valueOf(metrics.getMetric("numBytesOut")).longValue();
                }
                if (metrics.getMetric("numRecordsIn") == null) {
                    this.numRecordsInComplete = false;
                } else {
                    this.numRecordsIn += Long.valueOf(metrics.getMetric("numRecordsIn")).longValue();
                }
                if (metrics.getMetric("numRecordsOut") == null) {
                    this.numRecordsOutComplete = false;
                } else {
                    this.numRecordsOut += Long.valueOf(metrics.getMetric("numRecordsOut")).longValue();
                }
                if (metrics.getMetric("accumulateBackPressuredTimeMs") != null) {
                    this.accumulateBackPressuredTime += Long.parseLong(metrics.getMetric("accumulateBackPressuredTimeMs"));
                }
                if (metrics.getMetric("accumulateIdleTimeMs") != null) {
                    this.accumulateIdleTime += Long.parseLong(metrics.getMetric("accumulateIdleTimeMs"));
                }
                if (metrics.getMetric("accumulateBusyTimeMs") != null) {
                    double busyTime = Double.parseDouble(metrics.getMetric("accumulateBusyTimeMs"));
                    this.accumulateBusyTime = Double.isNaN(busyTime) ? Double.NaN : (this.accumulateBusyTime += busyTime);
                }
            } else {
                this.numBytesInComplete = false;
                this.numBytesOutComplete = false;
                this.numRecordsInComplete = false;
                this.numRecordsOutComplete = false;
            }
        }
    }
}

