/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.net.URL;
import java.util.concurrent.Future;
import org.apache.calcite.avatica.org.apache.http.ConnectionReuseStrategy;
import org.apache.calcite.avatica.org.apache.http.HttpClientConnection;
import org.apache.calcite.avatica.org.apache.http.HttpHost;
import org.apache.calcite.avatica.org.apache.http.HttpResponse;
import org.apache.calcite.avatica.org.apache.http.client.protocol.RequestExpectContinue;
import org.apache.calcite.avatica.org.apache.http.entity.ByteArrayEntity;
import org.apache.calcite.avatica.org.apache.http.entity.ContentType;
import org.apache.calcite.avatica.org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.calcite.avatica.org.apache.http.impl.pool.BasicConnFactory;
import org.apache.calcite.avatica.org.apache.http.impl.pool.BasicConnPool;
import org.apache.calcite.avatica.org.apache.http.impl.pool.BasicPoolEntry;
import org.apache.calcite.avatica.org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.calcite.avatica.org.apache.http.protocol.HttpCoreContext;
import org.apache.calcite.avatica.org.apache.http.protocol.HttpProcessor;
import org.apache.calcite.avatica.org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.calcite.avatica.org.apache.http.protocol.HttpRequestExecutor;
import org.apache.calcite.avatica.org.apache.http.protocol.RequestConnControl;
import org.apache.calcite.avatica.org.apache.http.protocol.RequestContent;
import org.apache.calcite.avatica.org.apache.http.protocol.RequestTargetHost;
import org.apache.calcite.avatica.org.apache.http.util.EntityUtils;
import org.apache.calcite.avatica.remote.AvaticaHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaCommonsHttpClientImpl
implements AvaticaHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaCommonsHttpClientImpl.class);
    private static final ConnectionReuseStrategy REUSE = DefaultConnectionReuseStrategy.INSTANCE;
    private static final String MAX_POOLED_CONNECTION_PER_ROUTE_KEY = "avatica.pooled.connections.per.route";
    private static final String MAX_POOLED_CONNECTION_PER_ROUTE_DEFAULT = "4";
    private static final String MAX_POOLED_CONNECTIONS_KEY = "avatica.pooled.connections.max";
    private static final String MAX_POOLED_CONNECTIONS_DEFAULT = "16";
    protected final HttpHost host;
    protected final HttpProcessor httpProcessor;
    protected final HttpRequestExecutor httpExecutor;
    protected final BasicConnPool httpPool;

    public AvaticaCommonsHttpClientImpl(URL url) {
        this.host = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        this.httpProcessor = HttpProcessorBuilder.create().add(new RequestContent()).add(new RequestTargetHost()).add(new RequestConnControl()).add(new RequestExpectContinue()).build();
        this.httpExecutor = new HttpRequestExecutor();
        this.httpPool = new BasicConnPool(new BasicConnFactory());
        int maxPerRoute = Integer.parseInt(System.getProperty(MAX_POOLED_CONNECTION_PER_ROUTE_KEY, MAX_POOLED_CONNECTION_PER_ROUTE_DEFAULT));
        int maxTotal = Integer.parseInt(System.getProperty(MAX_POOLED_CONNECTIONS_KEY, MAX_POOLED_CONNECTIONS_DEFAULT));
        this.httpPool.setDefaultMaxPerRoute(maxPerRoute);
        this.httpPool.setMaxTotal(maxTotal);
    }

    @Override
    public byte[] send(byte[] request) {
        while (true) {
            boolean reusable = false;
            Future future = this.httpPool.lease(this.host, null);
            BasicPoolEntry entry = null;
            try {
                entry = (BasicPoolEntry)future.get();
                HttpCoreContext coreContext = HttpCoreContext.create();
                coreContext.setTargetHost(this.host);
                HttpClientConnection conn = (HttpClientConnection)entry.getConnection();
                ByteArrayEntity entity = new ByteArrayEntity(request, ContentType.APPLICATION_OCTET_STREAM);
                BasicHttpEntityEnclosingRequest postRequest = new BasicHttpEntityEnclosingRequest("POST", "/");
                postRequest.setEntity(entity);
                this.httpExecutor.preProcess(postRequest, this.httpProcessor, coreContext);
                HttpResponse response = this.httpExecutor.execute(postRequest, conn, coreContext);
                this.httpExecutor.postProcess(response, this.httpProcessor, coreContext);
                reusable = REUSE.keepAlive(response, coreContext);
                int statusCode = response.getStatusLine().getStatusCode();
                if (503 == statusCode) continue;
                byte[] byArray = EntityUtils.toByteArray(response.getEntity());
                return byArray;
            }
            catch (Exception e) {
                LOG.debug("Failed to execute HTTP request", e);
                throw new RuntimeException(e);
            }
            finally {
                this.httpPool.release(entry, reusable);
                continue;
            }
            break;
        }
    }
}

