/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Objects;
import org.apache.calcite.avatica.ConnectionConfig;
import org.apache.calcite.avatica.remote.AvaticaCommonsHttpClientImpl;
import org.apache.calcite.avatica.remote.AvaticaHttpClient;
import org.apache.calcite.avatica.remote.AvaticaHttpClientFactory;

public class AvaticaHttpClientFactoryImpl
implements AvaticaHttpClientFactory {
    public static final String HTTP_CLIENT_IMPL_DEFAULT = AvaticaCommonsHttpClientImpl.class.getName();
    public static final AvaticaHttpClientFactoryImpl INSTANCE = new AvaticaHttpClientFactoryImpl();

    public static AvaticaHttpClientFactoryImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public AvaticaHttpClient getClient(URL url, ConnectionConfig config) {
        String className = config.httpClientClass();
        if (null == className) {
            className = HTTP_CLIENT_IMPL_DEFAULT;
        }
        try {
            Class<?> clz = Class.forName(className);
            Constructor<?> constructor = clz.getConstructor(URL.class);
            Object instance = constructor.newInstance(Objects.requireNonNull(url));
            return (AvaticaHttpClient)AvaticaHttpClient.class.cast(instance);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to construct AvaticaHttpClient implementation " + className, e);
        }
    }
}

