/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.util;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.AvaticaSite;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.util.ArrayImpl;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.Cursor;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.Spacer;
import org.apache.calcite.avatica.util.StructImpl;
import org.apache.calcite.avatica.util.TimeUnitRange;

public abstract class AbstractCursor
implements Cursor {
    protected final boolean[] wasNull = new boolean[]{false};

    protected AbstractCursor() {
    }

    @Override
    public boolean wasNull() {
        return this.wasNull[0];
    }

    @Override
    public List<Cursor.Accessor> createAccessors(List<ColumnMetaData> types, Calendar localCalendar, ArrayImpl.Factory factory) {
        ArrayList<Cursor.Accessor> accessors = new ArrayList<Cursor.Accessor>();
        for (ColumnMetaData type : types) {
            accessors.add(this.createAccessor(type, accessors.size(), localCalendar, factory));
        }
        return accessors;
    }

    protected Cursor.Accessor createAccessor(ColumnMetaData columnMetaData, int ordinal, Calendar localCalendar, ArrayImpl.Factory factory) {
        Getter getter = this.createGetter(ordinal);
        return this.createAccessor(columnMetaData, getter, localCalendar, factory);
    }

    protected Cursor.Accessor createAccessor(ColumnMetaData columnMetaData, Getter getter, Calendar localCalendar, ArrayImpl.Factory factory) {
        switch (columnMetaData.type.rep) {
            case NUMBER: {
                switch (columnMetaData.type.id) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return new NumberAccessor(getter, columnMetaData.scale);
                    }
                }
            }
        }
        switch (columnMetaData.type.id) {
            case -6: {
                return new ByteAccessor(getter);
            }
            case 5: {
                return new ShortAccessor(getter);
            }
            case 4: {
                return new IntAccessor(getter);
            }
            case -5: {
                return new LongAccessor(getter);
            }
            case 16: {
                return new BooleanAccessor(getter);
            }
            case 7: {
                return new FloatAccessor(getter);
            }
            case 6: 
            case 8: {
                return new DoubleAccessor(getter);
            }
            case 3: {
                return new BigDecimalAccessor(getter);
            }
            case 1: {
                switch (columnMetaData.type.rep) {
                    case PRIMITIVE_CHAR: 
                    case CHARACTER: {
                        return new StringFromCharAccessor(getter, columnMetaData.displaySize);
                    }
                }
                return new FixedStringAccessor(getter, columnMetaData.displaySize);
            }
            case 12: {
                return new StringAccessor(getter);
            }
            case -3: 
            case -2: {
                switch (columnMetaData.type.rep) {
                    case STRING: {
                        return new BinaryFromStringAccessor(getter);
                    }
                }
                return new BinaryAccessor(getter);
            }
            case 91: {
                switch (columnMetaData.type.rep) {
                    case NUMBER: 
                    case PRIMITIVE_INT: 
                    case INTEGER: {
                        return new DateFromNumberAccessor(getter, localCalendar);
                    }
                    case JAVA_SQL_DATE: {
                        return new DateAccessor(getter);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)columnMetaData.type.rep)));
            }
            case 92: {
                switch (columnMetaData.type.rep) {
                    case NUMBER: 
                    case PRIMITIVE_INT: 
                    case INTEGER: {
                        return new TimeFromNumberAccessor(getter, localCalendar);
                    }
                    case JAVA_SQL_TIME: {
                        return new TimeAccessor(getter);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)columnMetaData.type.rep)));
            }
            case 93: {
                switch (columnMetaData.type.rep) {
                    case NUMBER: 
                    case PRIMITIVE_LONG: 
                    case LONG: {
                        return new TimestampFromNumberAccessor(getter, localCalendar);
                    }
                    case JAVA_SQL_TIMESTAMP: {
                        return new TimestampAccessor(getter);
                    }
                    case JAVA_UTIL_DATE: {
                        return new TimestampFromUtilDateAccessor(getter, localCalendar);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)columnMetaData.type.rep)));
            }
            case 2003: {
                ColumnMetaData.ArrayType arrayType = (ColumnMetaData.ArrayType)columnMetaData.type;
                SlotGetter componentGetter = new SlotGetter();
                Cursor.Accessor componentAccessor = this.createAccessor(ColumnMetaData.dummy(arrayType.component, true), componentGetter, localCalendar, factory);
                return new ArrayAccessor(getter, arrayType.component, componentAccessor, componentGetter, factory);
            }
            case 2002: {
                switch (columnMetaData.type.rep) {
                    case OBJECT: {
                        ColumnMetaData.StructType structType = (ColumnMetaData.StructType)columnMetaData.type;
                        ArrayList<Cursor.Accessor> accessors = new ArrayList<Cursor.Accessor>();
                        for (ColumnMetaData column : structType.columns) {
                            Getter fieldGetter = structType.columns.size() == 1 ? getter : new StructGetter(getter, column);
                            accessors.add(this.createAccessor(column, fieldGetter, localCalendar, factory));
                        }
                        return new StructAccessor(getter, accessors);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)columnMetaData.type.rep)));
            }
            case 1111: 
            case 2000: {
                if (columnMetaData.type.name.startsWith("INTERVAL_")) {
                    TimeUnitRange range;
                    int end = columnMetaData.type.name.indexOf("(");
                    if (end < 0) {
                        end = columnMetaData.type.name.length();
                    }
                    if ((range = TimeUnitRange.valueOf(columnMetaData.type.name.substring("INTERVAL_".length(), end))).monthly()) {
                        return new IntervalYearMonthAccessor(getter, range);
                    }
                    return new IntervalDayTimeAccessor(getter, range, columnMetaData.scale);
                }
                return new ObjectAccessor(getter);
            }
        }
        throw new RuntimeException("unknown type " + columnMetaData.type.id);
    }

    protected abstract Getter createGetter(int var1);

    @Override
    public abstract boolean next();

    private static String timestampAsString(long v, Calendar calendar) {
        if (calendar != null) {
            v -= (long)calendar.getTimeZone().getOffset(v);
        }
        return DateTimeUtils.unixTimestampToString(v);
    }

    private static String dateAsString(int v, Calendar calendar) {
        AvaticaUtils.discard(calendar);
        return DateTimeUtils.unixDateToString(v);
    }

    private static String timeAsString(int v, Calendar calendar) {
        if (calendar != null) {
            v -= calendar.getTimeZone().getOffset(v);
        }
        return DateTimeUtils.unixTimeToString(v);
    }

    private static Date longToDate(long v, Calendar calendar) {
        if (calendar != null) {
            v -= (long)calendar.getTimeZone().getOffset(v);
        }
        return new Date(v);
    }

    static Time intToTime(int v, Calendar calendar) {
        if (calendar != null) {
            v -= calendar.getTimeZone().getOffset(v);
        }
        return new Time(v);
    }

    static Timestamp longToTimestamp(long v, Calendar calendar) {
        if (calendar != null) {
            v -= (long)calendar.getTimeZone().getOffset(v);
        }
        return new Timestamp(v);
    }

    public class StructGetter
    implements Getter {
        public final Getter getter;
        private final ColumnMetaData columnMetaData;

        public StructGetter(Getter getter, ColumnMetaData columnMetaData) {
            this.getter = getter;
            this.columnMetaData = columnMetaData;
        }

        @Override
        public Object getObject() {
            Object o = this.getter.getObject();
            if (o instanceof Object[]) {
                Object[] objects = (Object[])o;
                return objects[this.columnMetaData.ordinal];
            }
            try {
                Field field = o.getClass().getField(this.columnMetaData.label);
                return field.get(this.getter.getObject());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean wasNull() {
            return this.getObject() == null;
        }
    }

    public class SlotGetter
    implements Getter {
        public Object slot;

        @Override
        public Object getObject() {
            return this.slot;
        }

        @Override
        public boolean wasNull() {
            return this.slot == null;
        }
    }

    protected abstract class AbstractGetter
    implements Getter {
        protected AbstractGetter() {
        }

        @Override
        public boolean wasNull() {
            return AbstractCursor.this.wasNull[0];
        }
    }

    protected static interface Getter {
        public Object getObject();

        public boolean wasNull();
    }

    private static class ObjectAccessor
    extends AccessorImpl {
        public ObjectAccessor(Getter getter) {
            super(getter);
        }
    }

    private static class StructAccessor
    extends AccessorImpl {
        private final List<Cursor.Accessor> fieldAccessors;

        public StructAccessor(Getter getter, List<Cursor.Accessor> fieldAccessors) {
            super(getter);
            this.fieldAccessors = fieldAccessors;
        }

        @Override
        public Object getObject() {
            return this.getStruct();
        }

        @Override
        public Struct getStruct() {
            Object o = super.getObject();
            if (o == null) {
                return null;
            }
            if (o instanceof List) {
                return new StructImpl((List)o);
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (Cursor.Accessor fieldAccessor : this.fieldAccessors) {
                try {
                    list.add(fieldAccessor.getObject());
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return new StructImpl(list);
        }
    }

    static class ArrayAccessor
    extends AccessorImpl {
        final ColumnMetaData.AvaticaType componentType;
        final Cursor.Accessor componentAccessor;
        final SlotGetter componentSlotGetter;
        final ArrayImpl.Factory factory;

        public ArrayAccessor(Getter getter, ColumnMetaData.AvaticaType componentType, Cursor.Accessor componentAccessor, SlotGetter componentSlotGetter, ArrayImpl.Factory factory) {
            super(getter);
            this.componentType = componentType;
            this.componentAccessor = componentAccessor;
            this.componentSlotGetter = componentSlotGetter;
            this.factory = factory;
        }

        @Override
        public Object getObject() {
            Object object = super.getObject();
            if (object == null || object instanceof List) {
                return object;
            }
            return AvaticaUtils.primitiveList(object);
        }

        @Override
        public Array getArray() {
            List list = (List)this.getObject();
            if (list == null) {
                return null;
            }
            return new ArrayImpl(list, this);
        }

        @Override
        public String getString() {
            Array array = this.getArray();
            return array == null ? null : array.toString();
        }
    }

    private static class IntervalDayTimeAccessor
    extends LongAccessor {
        private final TimeUnitRange range;
        private final int scale;

        public IntervalDayTimeAccessor(Getter getter, TimeUnitRange range, int scale) {
            super(getter);
            this.range = range;
            this.scale = scale;
        }

        @Override
        public String getString() {
            long v = this.getLong();
            if (v == 0L && this.wasNull()) {
                return null;
            }
            return DateTimeUtils.intervalDayTimeToString(v, this.range, this.scale);
        }
    }

    private static class IntervalYearMonthAccessor
    extends IntAccessor {
        private final TimeUnitRange range;

        public IntervalYearMonthAccessor(Getter getter, TimeUnitRange range) {
            super(getter);
            this.range = range;
        }

        @Override
        public String getString() {
            int v = this.getInt();
            if (v == 0 && this.wasNull()) {
                return null;
            }
            return DateTimeUtils.intervalYearMonthToString(v, this.range);
        }
    }

    private static class TimestampFromUtilDateAccessor
    extends ObjectAccessor {
        private final Calendar localCalendar;

        public TimestampFromUtilDateAccessor(Getter getter, Calendar localCalendar) {
            super(getter);
            this.localCalendar = localCalendar;
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) {
            java.util.Date date = (java.util.Date)this.getObject();
            if (date == null) {
                return null;
            }
            long v = date.getTime();
            if (calendar != null) {
                v -= (long)calendar.getTimeZone().getOffset(v);
            }
            return new Timestamp(v);
        }

        @Override
        public Date getDate(Calendar calendar) {
            Timestamp timestamp = this.getTimestamp(calendar);
            if (timestamp == null) {
                return null;
            }
            return new Date(timestamp.getTime());
        }

        @Override
        public Time getTime(Calendar calendar) {
            Timestamp timestamp = this.getTimestamp(calendar);
            if (timestamp == null) {
                return null;
            }
            return new Time(DateTimeUtils.floorMod(timestamp.getTime(), 86400000L));
        }

        @Override
        public String getString() {
            java.util.Date date = (java.util.Date)this.getObject();
            if (date == null) {
                return null;
            }
            return AbstractCursor.timestampAsString(date.getTime(), null);
        }

        @Override
        public long getLong() {
            Timestamp timestamp = this.getTimestamp(this.localCalendar);
            return timestamp == null ? 0L : timestamp.getTime();
        }
    }

    private static class TimestampAccessor
    extends ObjectAccessor {
        public TimestampAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) {
            Timestamp timestamp = (Timestamp)this.getObject();
            if (timestamp == null) {
                return null;
            }
            if (calendar != null) {
                long v = timestamp.getTime();
                v -= (long)calendar.getTimeZone().getOffset(v);
                timestamp = new Timestamp(v);
            }
            return timestamp;
        }

        @Override
        public Date getDate(Calendar calendar) {
            Timestamp timestamp = this.getTimestamp(calendar);
            if (timestamp == null) {
                return null;
            }
            return new Date(timestamp.getTime());
        }

        @Override
        public Time getTime(Calendar calendar) {
            Timestamp timestamp = this.getTimestamp(calendar);
            if (timestamp == null) {
                return null;
            }
            return new Time(DateTimeUtils.floorMod(timestamp.getTime(), 86400000L));
        }

        @Override
        public String getString() {
            long v = this.getLong();
            if (v == 0L && this.wasNull()) {
                return null;
            }
            return AbstractCursor.timestampAsString(v, null);
        }

        @Override
        public long getLong() {
            Timestamp timestamp = this.getTimestamp(null);
            return timestamp == null ? 0L : timestamp.getTime();
        }
    }

    private static class TimeAccessor
    extends ObjectAccessor {
        public TimeAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public Time getTime(Calendar calendar) {
            Time date = (Time)this.getObject();
            if (date == null) {
                return null;
            }
            if (calendar != null) {
                long v = date.getTime();
                v -= (long)calendar.getTimeZone().getOffset(v);
                date = new Time(v);
            }
            return date;
        }

        @Override
        public String getString() {
            int v = this.getInt();
            if (v == 0 && this.wasNull()) {
                return null;
            }
            return AbstractCursor.timeAsString(v, null);
        }

        @Override
        public long getLong() {
            Time time = this.getTime(null);
            return time == null ? 0L : time.getTime() % 86400000L;
        }
    }

    private static class DateAccessor
    extends ObjectAccessor {
        public DateAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public Date getDate(Calendar calendar) {
            Date date = (Date)this.getObject();
            if (date == null) {
                return null;
            }
            if (calendar != null) {
                long v = date.getTime();
                v -= (long)calendar.getTimeZone().getOffset(v);
                date = new Date(v);
            }
            return date;
        }

        @Override
        public String getString() {
            int v = this.getInt();
            if (v == 0 && this.wasNull()) {
                return null;
            }
            return AbstractCursor.dateAsString(v, null);
        }

        @Override
        public long getLong() {
            Date date = this.getDate(null);
            return date == null ? 0L : date.getTime() / 86400000L;
        }
    }

    private static class TimestampFromNumberAccessor
    extends NumberAccessor {
        private final Calendar localCalendar;

        public TimestampFromNumberAccessor(Getter getter, Calendar localCalendar) {
            super(getter, 0);
            this.localCalendar = localCalendar;
        }

        @Override
        public Object getObject() {
            return this.getTimestamp(this.localCalendar);
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return AbstractCursor.longToTimestamp(v.longValue(), calendar);
        }

        @Override
        public Date getDate(Calendar calendar) {
            Timestamp timestamp = this.getTimestamp(calendar);
            if (timestamp == null) {
                return null;
            }
            return new Date(timestamp.getTime());
        }

        @Override
        public Time getTime(Calendar calendar) {
            Timestamp timestamp = this.getTimestamp(calendar);
            if (timestamp == null) {
                return null;
            }
            return new Time(DateTimeUtils.floorMod(timestamp.getTime(), 86400000L));
        }

        @Override
        public String getString() {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return AbstractCursor.timestampAsString(v.longValue(), null);
        }
    }

    private static class TimeFromNumberAccessor
    extends NumberAccessor {
        private final Calendar localCalendar;

        public TimeFromNumberAccessor(Getter getter, Calendar localCalendar) {
            super(getter, 0);
            this.localCalendar = localCalendar;
        }

        @Override
        public Object getObject() {
            return this.getTime(this.localCalendar);
        }

        @Override
        public Time getTime(Calendar calendar) {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return AbstractCursor.intToTime(v.intValue(), calendar);
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return AbstractCursor.longToTimestamp(v.longValue(), calendar);
        }

        @Override
        public String getString() {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return AbstractCursor.timeAsString(v.intValue(), null);
        }
    }

    private static class DateFromNumberAccessor
    extends NumberAccessor {
        private final Calendar localCalendar;

        public DateFromNumberAccessor(Getter getter, Calendar localCalendar) {
            super(getter, 0);
            this.localCalendar = localCalendar;
        }

        @Override
        public Object getObject() {
            return this.getDate(this.localCalendar);
        }

        @Override
        public Date getDate(Calendar calendar) {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return AbstractCursor.longToDate(v.longValue() * 86400000L, calendar);
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return AbstractCursor.longToTimestamp(v.longValue() * 86400000L, calendar);
        }

        @Override
        public String getString() {
            Number v = this.getNumber();
            if (v == null) {
                return null;
            }
            return AbstractCursor.dateAsString(v.intValue(), null);
        }
    }

    private static class BinaryFromStringAccessor
    extends StringAccessor {
        public BinaryFromStringAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public Object getObject() {
            return super.getObject();
        }

        @Override
        public byte[] getBytes() {
            Object obj = this.getObject();
            if (obj instanceof byte[]) {
                return (byte[])obj;
            }
            return this.getBase64Decoded();
        }

        private byte[] getBase64Decoded() {
            String string = super.getString();
            if (null == string) {
                return null;
            }
            return ByteString.parseBase64(string);
        }

        @Override
        public String getString() {
            byte[] bytes = this.getBase64Decoded();
            if (null == bytes) {
                return null;
            }
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }

    private static class BinaryAccessor
    extends AccessorImpl {
        public BinaryAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public byte[] getBytes() {
            Object obj = this.getObject();
            try {
                ByteString o = (ByteString)obj;
                return o == null ? null : o.getBytes();
            }
            catch (Exception ex) {
                return obj == null ? null : (byte[])obj;
            }
        }

        @Override
        public String getString() {
            Object o = this.getObject();
            if (null == o) {
                return null;
            }
            if (o instanceof byte[]) {
                return new String((byte[])o, StandardCharsets.UTF_8);
            }
            if (o instanceof ByteString) {
                return ((ByteString)o).toString();
            }
            throw new IllegalStateException("Unhandled value type: " + o.getClass());
        }
    }

    private static class StringFromCharAccessor
    extends FixedStringAccessor {
        public StringFromCharAccessor(Getter getter, int length) {
            super(getter, length);
        }

        @Override
        public String getString() {
            Character s = (Character)super.getObject();
            if (s == null) {
                return null;
            }
            return this.spacer.padRight(s.toString());
        }
    }

    private static class FixedStringAccessor
    extends StringAccessor {
        protected final Spacer spacer;

        public FixedStringAccessor(Getter getter, int length) {
            super(getter);
            this.spacer = new Spacer(length);
        }

        @Override
        public String getString() {
            String s = super.getString();
            if (s == null) {
                return null;
            }
            return this.spacer.padRight(s);
        }
    }

    private static class StringAccessor
    extends AccessorImpl {
        public StringAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public String getString() {
            return (String)this.getObject();
        }

        @Override
        public byte[] getBytes() {
            return super.getBytes();
        }
    }

    static class NumberAccessor
    extends BigNumberAccessor {
        private final int scale;

        public NumberAccessor(Getter getter, int scale) {
            super(getter);
            this.scale = scale;
        }

        @Override
        protected Number getNumber() {
            return (Number)super.getObject();
        }

        @Override
        public BigDecimal getBigDecimal(int scale) {
            Number n = this.getNumber();
            if (n == null) {
                return null;
            }
            BigDecimal decimal = AvaticaSite.toBigDecimal(n);
            if (0 != scale) {
                return decimal.setScale(scale, 7);
            }
            return decimal;
        }

        @Override
        public BigDecimal getBigDecimal() {
            return this.getBigDecimal(this.scale);
        }
    }

    private static class BigDecimalAccessor
    extends BigNumberAccessor {
        public BigDecimalAccessor(Getter getter) {
            super(getter);
        }

        @Override
        protected Number getNumber() {
            return (Number)this.getObject();
        }

        @Override
        public BigDecimal getBigDecimal(int scale) {
            return (BigDecimal)this.getObject();
        }

        @Override
        public BigDecimal getBigDecimal() {
            return (BigDecimal)this.getObject();
        }
    }

    private static abstract class BigNumberAccessor
    extends AccessorImpl {
        public BigNumberAccessor(Getter getter) {
            super(getter);
        }

        protected abstract Number getNumber();

        @Override
        public double getDouble() {
            Number number = this.getNumber();
            return number == null ? 0.0 : number.doubleValue();
        }

        @Override
        public float getFloat() {
            Number number = this.getNumber();
            return number == null ? 0.0f : number.floatValue();
        }

        @Override
        public long getLong() {
            Number number = this.getNumber();
            return number == null ? 0L : number.longValue();
        }

        @Override
        public int getInt() {
            Number number = this.getNumber();
            return number == null ? 0 : number.intValue();
        }

        @Override
        public short getShort() {
            Number number = this.getNumber();
            return number == null ? (short)0 : number.shortValue();
        }

        @Override
        public byte getByte() {
            Number number = this.getNumber();
            return number == null ? (byte)0 : number.byteValue();
        }

        @Override
        public boolean getBoolean() {
            Number number = this.getNumber();
            return number != null && number.doubleValue() != 0.0;
        }
    }

    private static class DoubleAccessor
    extends ApproximateNumericAccessor {
        public DoubleAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public double getDouble() {
            Double o = (Double)this.getObject();
            return o == null ? 0.0 : o;
        }
    }

    private static class FloatAccessor
    extends ApproximateNumericAccessor {
        public FloatAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public float getFloat() {
            Float o = (Float)this.getObject();
            return o == null ? 0.0f : o.floatValue();
        }

        @Override
        public double getDouble() {
            return this.getFloat();
        }
    }

    private static abstract class ApproximateNumericAccessor
    extends AccessorImpl {
        public ApproximateNumericAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public BigDecimal getBigDecimal(int scale) {
            double v = this.getDouble();
            if (v == 0.0 && this.getter.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(v).setScale(scale, RoundingMode.DOWN);
        }

        @Override
        public BigDecimal getBigDecimal() {
            double v = this.getDouble();
            if (v == 0.0 && this.getter.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(v);
        }

        @Override
        public abstract double getDouble();

        @Override
        public long getLong() {
            return (long)this.getDouble();
        }
    }

    private static class LongAccessor
    extends ExactNumericAccessor {
        public LongAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public long getLong() {
            Long o = (Long)super.getObject();
            return o == null ? 0L : o;
        }
    }

    private static class IntAccessor
    extends ExactNumericAccessor {
        public IntAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public int getInt() {
            Integer o = (Integer)super.getObject();
            return o == null ? 0 : o;
        }

        @Override
        public long getLong() {
            return this.getInt();
        }
    }

    private static class ShortAccessor
    extends ExactNumericAccessor {
        public ShortAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public short getShort() {
            Short o = (Short)this.getObject();
            return o == null ? (short)0 : o;
        }

        @Override
        public long getLong() {
            return this.getShort();
        }
    }

    private static class ByteAccessor
    extends ExactNumericAccessor {
        public ByteAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public byte getByte() {
            Byte o = (Byte)this.getObject();
            return o == null ? (byte)0 : o;
        }

        @Override
        public long getLong() {
            return this.getByte();
        }
    }

    private static class BooleanAccessor
    extends ExactNumericAccessor {
        public BooleanAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public boolean getBoolean() {
            Boolean o = (Boolean)this.getObject();
            return o != null && o != false;
        }

        @Override
        public long getLong() {
            return this.getBoolean() ? 1L : 0L;
        }
    }

    private static abstract class ExactNumericAccessor
    extends AccessorImpl {
        public ExactNumericAccessor(Getter getter) {
            super(getter);
        }

        @Override
        public BigDecimal getBigDecimal(int scale) {
            long v = this.getLong();
            if (v == 0L && this.getter.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(v).setScale(scale, RoundingMode.DOWN);
        }

        @Override
        public BigDecimal getBigDecimal() {
            long val = this.getLong();
            if (val == 0L && this.getter.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(val);
        }

        @Override
        public double getDouble() {
            return this.getLong();
        }

        @Override
        public float getFloat() {
            return this.getLong();
        }

        @Override
        public abstract long getLong();
    }

    static class AccessorImpl
    implements Cursor.Accessor {
        protected final Getter getter;

        public AccessorImpl(Getter getter) {
            assert (getter != null);
            this.getter = getter;
        }

        @Override
        public boolean wasNull() {
            return this.getter.wasNull();
        }

        @Override
        public String getString() {
            Object o = this.getObject();
            return o == null ? null : o.toString();
        }

        @Override
        public boolean getBoolean() {
            return this.getLong() != 0L;
        }

        @Override
        public byte getByte() {
            return (byte)this.getLong();
        }

        @Override
        public short getShort() {
            return (short)this.getLong();
        }

        @Override
        public int getInt() {
            return (int)this.getLong();
        }

        @Override
        public long getLong() {
            throw this.cannotConvert("long");
        }

        @Override
        public float getFloat() {
            return (float)this.getDouble();
        }

        @Override
        public double getDouble() {
            throw this.cannotConvert("double");
        }

        @Override
        public BigDecimal getBigDecimal() {
            throw this.cannotConvert("BigDecimal");
        }

        @Override
        public BigDecimal getBigDecimal(int scale) {
            throw this.cannotConvert("BigDecimal with scale");
        }

        @Override
        public byte[] getBytes() {
            throw this.cannotConvert("byte[]");
        }

        @Override
        public InputStream getAsciiStream() {
            throw this.cannotConvert("InputStream (ascii)");
        }

        @Override
        public InputStream getUnicodeStream() {
            throw this.cannotConvert("InputStream (unicode)");
        }

        @Override
        public InputStream getBinaryStream() {
            throw this.cannotConvert("InputStream (binary)");
        }

        @Override
        public Object getObject() {
            return this.getter.getObject();
        }

        @Override
        public Reader getCharacterStream() {
            throw this.cannotConvert("Reader");
        }

        private RuntimeException cannotConvert(String targetType) {
            return new RuntimeException("cannot convert to " + targetType + " (" + this + ")");
        }

        @Override
        public Object getObject(Map<String, Class<?>> map2) {
            throw this.cannotConvert("Object (with map)");
        }

        @Override
        public Ref getRef() {
            throw this.cannotConvert("Ref");
        }

        @Override
        public Blob getBlob() {
            throw this.cannotConvert("Blob");
        }

        @Override
        public Clob getClob() {
            throw this.cannotConvert("Clob");
        }

        @Override
        public Array getArray() {
            throw this.cannotConvert("Array");
        }

        public Struct getStruct() {
            throw this.cannotConvert("Struct");
        }

        @Override
        public Date getDate(Calendar calendar) {
            throw this.cannotConvert("Date");
        }

        @Override
        public Time getTime(Calendar calendar) {
            throw this.cannotConvert("Time");
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) {
            throw this.cannotConvert("Timestamp");
        }

        @Override
        public URL getURL() {
            throw this.cannotConvert("URL");
        }

        @Override
        public NClob getNClob() {
            throw this.cannotConvert("NClob");
        }

        @Override
        public SQLXML getSQLXML() {
            throw this.cannotConvert("SQLXML");
        }

        @Override
        public String getNString() {
            throw this.cannotConvert("NString");
        }

        @Override
        public Reader getNCharacterStream() {
            throw this.cannotConvert("NCharacterStream");
        }

        @Override
        public <T> T getObject(Class<T> type) {
            throw this.cannotConvert("Object (with type)");
        }
    }
}

