/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.avatica.DriverVersion;
import org.apache.calcite.avatica.Handler;
import org.apache.calcite.avatica.HandlerImpl;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.calcite.jdbc.CalciteFactory;
import org.apache.calcite.jdbc.CalciteMetaImpl;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.model.ModelHandler;

public class Driver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:calcite:";
    final Function0<CalcitePrepare> prepareFactory = this.createPrepareFactory();

    protected Function0<CalcitePrepare> createPrepareFactory() {
        return CalcitePrepare.DEFAULT_FACTORY;
    }

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: 
            case JDBC_40: {
                throw new IllegalArgumentException("JDBC version not supported: " + (Object)((Object)jdbcVersion));
            }
        }
        return "org.apache.calcite.jdbc.CalciteJdbc41Factory";
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "org-apache-calcite-jdbc.properties", "Calcite JDBC Driver", "unknown version", "Calcite", "unknown version");
    }

    @Override
    protected Handler createHandler() {
        return new HandlerImpl(){

            @Override
            public void onConnectionInit(AvaticaConnection connection_) throws SQLException {
                CalciteConnectionImpl connection = (CalciteConnectionImpl)connection_;
                super.onConnectionInit(connection);
                String model = connection.config().model();
                if (model != null) {
                    try {
                        new ModelHandler(connection, model);
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                }
                connection.init();
            }
        };
    }

    @Override
    protected Collection<ConnectionProperty> getConnectionProperties() {
        ArrayList<ConnectionProperty> list = new ArrayList<ConnectionProperty>();
        Collections.addAll(list, BuiltInConnectionProperty.values());
        Collections.addAll(list, CalciteConnectionProperty.values());
        return list;
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        return new CalciteMetaImpl((CalciteConnectionImpl)connection);
    }

    CalciteConnection connect(CalciteSchema rootSchema, JavaTypeFactory typeFactory) {
        return (CalciteConnection)((Object)((CalciteFactory)this.factory).newConnection(this, this.factory, CONNECT_STRING_PREFIX, new Properties(), rootSchema, typeFactory));
    }

    static {
        new Driver().register();
    }
}

