/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.AbstractRelOptPlanner;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.MaterializedViewSubstitutionVisitor;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.plan.volcano.RelSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.RuleQueue;
import org.apache.calcite.plan.volcano.VolcanoCost;
import org.apache.calcite.plan.volcano.VolcanoPlannerPhase;
import org.apache.calcite.plan.volcano.VolcanoPlannerPhaseRuleMappingInitializer;
import org.apache.calcite.plan.volcano.VolcanoRelMetadataProvider;
import org.apache.calcite.plan.volcano.VolcanoRuleCall;
import org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.convert.Converter;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.AggregateJoinTransposeRule;
import org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import org.apache.calcite.rel.rules.AggregateRemoveRule;
import org.apache.calcite.rel.rules.CalcRemoveRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.JoinAssociateRule;
import org.apache.calcite.rel.rules.JoinCommuteRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.rules.SemiJoinRule;
import org.apache.calcite.rel.rules.SortRemoveRule;
import org.apache.calcite.rel.rules.UnionToDistinctRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.SaffronProperties;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.graph.Graphs;
import org.apache.calcite.util.graph.TopologicalOrderIterator;
import org.apache.flink.shaded.calcite.com.google.common.base.Function;
import org.apache.flink.shaded.calcite.com.google.common.base.Supplier;
import org.apache.flink.shaded.calcite.com.google.common.base.Suppliers;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.Iterables;
import org.apache.flink.shaded.calcite.com.google.common.collect.LinkedHashMultimap;
import org.apache.flink.shaded.calcite.com.google.common.collect.LinkedListMultimap;
import org.apache.flink.shaded.calcite.com.google.common.collect.Lists;
import org.apache.flink.shaded.calcite.com.google.common.collect.Maps;
import org.apache.flink.shaded.calcite.com.google.common.collect.Multimap;
import org.apache.flink.shaded.calcite.com.google.common.collect.SetMultimap;
import org.apache.flink.shaded.calcite.com.google.common.collect.Sets;

public class VolcanoPlanner
extends AbstractRelOptPlanner {
    protected static final double COST_IMPROVEMENT = 0.5;
    private static final Function<RelOptTable, List<String>> GET_QUALIFIED_NAME = new Function<RelOptTable, List<String>>(){

        @Override
        public List<String> apply(RelOptTable relOptTable) {
            return relOptTable.getQualifiedName();
        }
    };
    protected RelSubset root;
    protected boolean ambitious = true;
    protected boolean impatient = false;
    private final Multimap<Class<? extends RelNode>, RelOptRuleOperand> classOperands = LinkedListMultimap.create();
    final List<RelSet> allSets = new ArrayList<RelSet>();
    private final Map<Pair<String, RelDataType>, RelNode> mapDigestToRel = new HashMap<Pair<String, RelDataType>, RelNode>();
    private final IdentityHashMap<RelNode, RelSubset> mapRel2Subset = new IdentityHashMap();
    final Map<RelNode, Double> relImportances = new HashMap<RelNode, Double>();
    private final Set<RelOptSchema> registeredSchemas = new HashSet<RelOptSchema>();
    final RuleQueue ruleQueue = new RuleQueue(this);
    private final List<RelTraitDef> traitDefs = new ArrayList<RelTraitDef>();
    protected final Set<RelOptRule> ruleSet = new HashSet<RelOptRule>();
    private int nextSetId = 0;
    private int registerCount;
    RelOptListener listener;
    private String originalRootString;
    private RelNode originalRoot;
    private boolean locked;
    private final List<RelOptMaterialization> materializations = Lists.newArrayList();
    private final Map<List<String>, RelOptLattice> latticeByName = Maps.newLinkedHashMap();
    final Map<RelNode, Provenance> provenanceMap = new HashMap<RelNode, Provenance>();
    private final Deque<VolcanoRuleCall> ruleCallStack = new ArrayDeque<VolcanoRuleCall>();
    private final RelOptCost zeroCost;
    private final SetMultimap<String, Class> ruleNames = LinkedHashMultimap.create();

    public VolcanoPlanner() {
        this(null, null);
    }

    public VolcanoPlanner(Context externalContext) {
        this(null, externalContext);
    }

    public VolcanoPlanner(RelOptCostFactory costFactory, Context externalContext) {
        super(costFactory == null ? VolcanoCost.FACTORY : costFactory, externalContext);
        this.zeroCost = this.costFactory.makeZeroCost();
    }

    protected VolcanoPlannerPhaseRuleMappingInitializer getPhaseRuleMappingInitializer() {
        return new VolcanoPlannerPhaseRuleMappingInitializer(){

            @Override
            public void initialize(Map<VolcanoPlannerPhase, Set<String>> phaseRuleMap) {
                phaseRuleMap.get((Object)VolcanoPlannerPhase.PRE_PROCESS_MDR).add("xxx");
                phaseRuleMap.get((Object)VolcanoPlannerPhase.PRE_PROCESS).add("xxx");
                phaseRuleMap.get((Object)VolcanoPlannerPhase.CLEANUP).add("xxx");
            }
        };
    }

    @Override
    public boolean isRegistered(RelNode rel) {
        return this.mapRel2Subset.get(rel) != null;
    }

    @Override
    public void setRoot(RelNode rel) {
        this.registerMetadataRels();
        this.root = this.registerImpl(rel, null);
        if (this.originalRoot == null) {
            this.originalRoot = rel;
        }
        this.originalRootString = RelOptUtil.toString(this.root, SqlExplainLevel.ALL_ATTRIBUTES);
        this.ruleQueue.recompute(this.root);
        this.ensureRootConverters();
    }

    @Override
    public RelNode getRoot() {
        return this.root;
    }

    @Override
    public void addMaterialization(RelOptMaterialization materialization) {
        this.materializations.add(materialization);
    }

    @Override
    public void addLattice(RelOptLattice lattice) {
        this.latticeByName.put(lattice.starRelOptTable.getQualifiedName(), lattice);
    }

    @Override
    public RelOptLattice getLattice(RelOptTable table) {
        return this.latticeByName.get(table.getQualifiedName());
    }

    private void useLattice(RelOptLattice lattice, RelNode rel) {
        Hook.SUB.run(rel);
        this.registerImpl(rel, this.root.set);
    }

    private List<RelNode> useMaterialization(RelNode root, RelOptMaterialization materialization, boolean firstRun) {
        List<RelNode> sub = this.substitute(root, materialization);
        if (!sub.isEmpty()) {
            for (RelNode rel : sub) {
                Hook.SUB.run(rel);
                this.registerImpl(rel, this.root.set);
            }
            return sub;
        }
        if (firstRun) {
            RelSubset subset = this.registerImpl(materialization.queryRel, null);
            RelNode tableRel2 = RelOptUtil.createCastRel(materialization.tableRel, materialization.queryRel.getRowType(), true);
            this.registerImpl(tableRel2, subset.set);
        }
        return ImmutableList.of();
    }

    private List<RelNode> substitute(RelNode root, RelOptMaterialization materialization) {
        RelNode newRoot;
        if (materialization.starTable != null && (newRoot = RelOptMaterialization.tryUseStar(root, materialization.starRelOptTable)) != null) {
            root = newRoot;
        }
        RelNode target = materialization.queryRel;
        HepProgram program = new HepProgramBuilder().addRuleInstance(FilterProjectTransposeRule.INSTANCE).addRuleInstance(ProjectMergeRule.INSTANCE).build();
        HepPlanner hepPlanner = new HepPlanner(program, this.getContext());
        hepPlanner.setRoot(target);
        target = hepPlanner.findBestExp();
        hepPlanner.setRoot(root);
        root = hepPlanner.findBestExp();
        return new MaterializedViewSubstitutionVisitor(target, root).go(materialization.tableRel);
    }

    private void useMaterializations(RelNode root, List<RelOptMaterialization> materializations) {
        ArrayList<RelNode> applied = Lists.newArrayList(root);
        for (RelOptMaterialization m : materializations) {
            int count = applied.size();
            for (int i = 0; i < count; ++i) {
                List<RelNode> sub = this.useMaterialization((RelNode)applied.get(i), m, i == 0);
                applied.addAll(sub);
            }
        }
    }

    private void useApplicableMaterializations() {
        CalciteConnectionConfig config = this.context.unwrap(CalciteConnectionConfig.class);
        if (config == null || !config.materializationsEnabled()) {
            return;
        }
        DefaultDirectedGraph<List<String>, DefaultEdge> usesGraph = DefaultDirectedGraph.create();
        HashMap<List<String>, RelOptMaterialization> qnameMap = new HashMap<List<String>, RelOptMaterialization>();
        for (RelOptMaterialization materialization : this.materializations) {
            if (materialization.table == null || materialization.starTable != null) continue;
            List<String> qname = materialization.table.getQualifiedName();
            qnameMap.put(qname, materialization);
            for (RelOptTable usedTable : VolcanoPlanner.findTables(materialization.queryRel)) {
                usesGraph.addVertex(qname);
                usesGraph.addVertex(usedTable.getQualifiedName());
                usesGraph.addEdge(usedTable.getQualifiedName(), qname);
            }
        }
        Graphs.FrozenGraph<List<String>, DefaultEdge> frozenGraph = Graphs.makeImmutable(usesGraph);
        Set<RelOptTable> queryTables = VolcanoPlanner.findTables(this.originalRoot);
        ArrayList<RelOptMaterialization> applicableMaterializations = Lists.newArrayList();
        for (List qname : TopologicalOrderIterator.of(usesGraph)) {
            RelOptMaterialization materialization = (RelOptMaterialization)qnameMap.get(qname);
            if (materialization == null || !this.usesTable(materialization.table, queryTables, frozenGraph)) continue;
            applicableMaterializations.add(materialization);
        }
        this.useMaterializations(this.originalRoot, applicableMaterializations);
        ArrayList<Pair<RelOptLattice, RelNode>> latticeUses = Lists.newArrayList();
        HashSet<List<String>> queryTableNames = Sets.newHashSet(Iterables.transform(queryTables, GET_QUALIFIED_NAME));
        Supplier<RelNode> leafJoinRoot = Suppliers.memoize(new Supplier<RelNode>(){

            @Override
            public RelNode get() {
                return RelOptMaterialization.toLeafJoinForm(VolcanoPlanner.this.originalRoot);
            }
        });
        for (RelOptLattice lattice : this.latticeByName.values()) {
            RelNode rel2;
            if (!queryTableNames.contains(lattice.rootTable().getQualifiedName()) || (rel2 = lattice.rewrite(leafJoinRoot.get())) == null) continue;
            if (CalcitePrepareImpl.DEBUG) {
                System.out.println("use lattice:\n" + RelOptUtil.toString(rel2));
            }
            latticeUses.add(Pair.of(lattice, rel2));
        }
        if (!latticeUses.isEmpty()) {
            this.useLattice((RelOptLattice)((Pair)latticeUses.get((int)0)).left, (RelNode)((Pair)latticeUses.get((int)0)).right);
        }
    }

    private boolean usesTable(RelOptTable table, Set<RelOptTable> usedTables, Graphs.FrozenGraph<List<String>, DefaultEdge> usesGraph) {
        for (RelOptTable queryTable : usedTables) {
            if (usesGraph.getShortestPath(queryTable.getQualifiedName(), table.getQualifiedName()) == null) continue;
            return true;
        }
        return false;
    }

    private static Set<RelOptTable> findTables(RelNode rel) {
        final LinkedHashSet<RelOptTable> usedTables = new LinkedHashSet<RelOptTable>();
        new RelVisitor(){

            @Override
            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof TableScan) {
                    usedTables.add(node.getTable());
                }
                super.visit(node, ordinal, parent);
            }
        }.go(rel);
        return usedTables;
    }

    public RelSet getSet(RelNode rel) {
        assert (rel != null) : "pre: rel != null";
        RelSubset subset = this.getSubset(rel);
        if (subset != null) {
            assert (subset.set != null);
            return subset.set;
        }
        return null;
    }

    @Override
    public boolean addRelTraitDef(RelTraitDef relTraitDef) {
        return !this.traitDefs.contains(relTraitDef) && this.traitDefs.add(relTraitDef);
    }

    @Override
    public void clearRelTraitDefs() {
        this.traitDefs.clear();
    }

    @Override
    public List<RelTraitDef> getRelTraitDefs() {
        return this.traitDefs;
    }

    @Override
    public RelTraitSet emptyTraitSet() {
        RelTraitSet traitSet = super.emptyTraitSet();
        for (RelTraitDef traitDef : this.traitDefs) {
            if (traitDef.multiple()) {
                // empty if block
            }
            traitSet = traitSet.plus((RelTrait)traitDef.getDefault());
        }
        return traitSet;
    }

    @Override
    public void clear() {
        super.clear();
        for (RelOptRule rule : ImmutableList.copyOf(this.ruleSet)) {
            this.removeRule(rule);
        }
        this.classOperands.clear();
        this.allSets.clear();
        this.mapDigestToRel.clear();
        this.mapRel2Subset.clear();
        this.relImportances.clear();
        this.ruleQueue.clear();
        this.ruleNames.clear();
    }

    @Override
    public boolean addRule(RelOptRule rule) {
        ConverterRule converterRule;
        RelTrait ruleTrait;
        RelTraitDef ruleTraitDef;
        Set<Class> x;
        if (this.locked) {
            return false;
        }
        if (this.ruleSet.contains(rule)) {
            return false;
        }
        boolean added = this.ruleSet.add(rule);
        assert (added);
        String ruleName = rule.toString();
        if (this.ruleNames.put(ruleName, rule.getClass()) && (x = this.ruleNames.get(ruleName)).size() > 1) {
            throw new RuntimeException("Rule description '" + ruleName + "' is not unique; classes: " + x);
        }
        this.mapRuleDescription(rule);
        for (RelOptRuleOperand operand : rule.getOperands()) {
            for (Class<? extends RelNode> subClass : this.subClasses(operand.getMatchedClass())) {
                this.classOperands.put(subClass, operand);
            }
        }
        if (rule instanceof ConverterRule && this.traitDefs.contains(ruleTraitDef = (ruleTrait = (converterRule = (ConverterRule)rule).getInTrait()).getTraitDef())) {
            ruleTraitDef.registerConverterRule(this, converterRule);
        }
        return true;
    }

    @Override
    public boolean removeRule(RelOptRule rule) {
        ConverterRule converterRule;
        RelTrait ruleTrait;
        RelTraitDef ruleTraitDef;
        if (!this.ruleSet.remove(rule)) {
            return false;
        }
        this.unmapRuleDescription(rule);
        Iterator<RelOptRuleOperand> iter = this.classOperands.values().iterator();
        while (iter.hasNext()) {
            RelOptRuleOperand entry = iter.next();
            if (!entry.getRule().equals((Object)rule)) continue;
            iter.remove();
        }
        if (rule instanceof ConverterRule && this.traitDefs.contains(ruleTraitDef = (ruleTrait = (converterRule = (ConverterRule)rule).getInTrait()).getTraitDef())) {
            ruleTraitDef.deregisterConverterRule(this, converterRule);
        }
        return true;
    }

    @Override
    protected void onNewClass(RelNode node) {
        super.onNewClass(node);
        Class<?> clazz = node.getClass();
        for (RelOptRule rule : this.ruleSet) {
            for (RelOptRuleOperand operand : rule.getOperands()) {
                if (!operand.getMatchedClass().isAssignableFrom(clazz)) continue;
                this.classOperands.put(clazz, operand);
            }
        }
    }

    public boolean canConvert(RelTraitSet fromTraits, RelTraitSet toTraits) {
        assert (fromTraits.size() >= toTraits.size());
        boolean canConvert = true;
        for (int i = 0; i < toTraits.size() && canConvert; ++i) {
            RelTrait fromTrait = fromTraits.getTrait(i);
            RelTrait toTrait = toTraits.getTrait(i);
            assert (fromTrait.getTraitDef() == toTrait.getTraitDef());
            assert (this.traitDefs.contains(fromTrait.getTraitDef()));
            assert (this.traitDefs.contains(toTrait.getTraitDef()));
            canConvert = fromTrait.getTraitDef().canConvert(this, fromTrait, toTrait);
        }
        return canConvert;
    }

    @Override
    public RelNode changeTraits(RelNode rel, RelTraitSet toTraits) {
        assert (!rel.getTraitSet().equals(toTraits));
        assert (toTraits.allSimple());
        RelSubset rel2 = this.ensureRegistered(rel, null);
        if (rel2.getTraitSet().equals(toTraits)) {
            return rel2;
        }
        return rel2.set.getOrCreateSubset(rel.getCluster(), toTraits.simplify());
    }

    @Override
    public RelOptPlanner chooseDelegate() {
        return this;
    }

    @Override
    public RelNode findBestExp() {
        this.ensureRootConverters();
        this.useApplicableMaterializations();
        int cumulativeTicks = 0;
        for (VolcanoPlannerPhase phase : VolcanoPlannerPhase.values()) {
            this.setInitialImportance();
            RelOptCost targetCost = this.costFactory.makeHugeCost();
            int tick = 0;
            int firstFiniteTick = -1;
            int splitCount = 0;
            int giveUpTick = Integer.MAX_VALUE;
            while (true) {
                ++tick;
                ++cumulativeTicks;
                if (this.root.bestCost.isLe(targetCost)) {
                    if (firstFiniteTick < 0) {
                        firstFiniteTick = cumulativeTicks;
                        this.clearImportanceBoost();
                    }
                    if (!this.ambitious) break;
                    targetCost = this.root.bestCost.multiplyBy(0.9);
                    ++splitCount;
                    if (this.impatient) {
                        giveUpTick = firstFiniteTick < 10 ? cumulativeTicks + 25 : cumulativeTicks + Math.max(firstFiniteTick / 10, 25);
                    }
                } else {
                    if (cumulativeTicks > giveUpTick) break;
                    if (this.root.bestCost.isInfinite() && tick % 10 == 0) {
                        this.injectImportanceBoost();
                    }
                }
                LOGGER.debug("PLANNER = {}; TICK = {}/{}; PHASE = {}; COST = {}", this, cumulativeTicks, tick, phase.toString(), this.root.bestCost);
                VolcanoRuleMatch match = this.ruleQueue.popMatch(phase);
                if (match == null) break;
                assert (match.getRule().matches(match));
                match.onMatch();
                this.root = this.canonize(this.root);
            }
            this.ruleQueue.phaseCompleted(phase);
        }
        if (LOGGER.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.dump(pw);
            pw.flush();
            LOGGER.trace(sw.toString());
        }
        RelNode cheapest = this.root.buildCheapestPlan(this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cheapest plan:\n{}", (Object)RelOptUtil.toString(cheapest, SqlExplainLevel.ALL_ATTRIBUTES));
            LOGGER.debug("Provenance:\n{}", (Object)this.provenance(cheapest));
        }
        return cheapest;
    }

    private void registerMetadataRels() {
        JaninoRelMetadataProvider.DEFAULT.register(this.classOperands.keySet());
    }

    void ensureRootConverters() {
        HashSet<RelSubset> subsets = Sets.newHashSet();
        for (RelNode rel : this.root.getRels()) {
            if (!(rel instanceof AbstractConverter)) continue;
            subsets.add((RelSubset)((AbstractConverter)rel).getInput());
        }
        for (RelSubset subset : this.root.set.subsets) {
            ImmutableList<RelTrait> difference = this.root.getTraitSet().difference(subset.getTraitSet());
            if (difference.size() != 1 || !subsets.add(subset)) continue;
            this.register(new AbstractConverter(subset.getCluster(), subset, ((RelTrait)difference.get(0)).getTraitDef(), this.root.getTraitSet()), this.root);
        }
    }

    private String provenance(RelNode root) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        final ArrayList nodes = new ArrayList();
        new RelVisitor(){

            @Override
            public void visit(RelNode node, int ordinal, RelNode parent) {
                nodes.add(node);
                super.visit(node, ordinal, parent);
            }
        }.go(root);
        HashSet<RelNode> visited = new HashSet<RelNode>();
        for (RelNode node : nodes) {
            this.provenanceRecurse(pw, node, 0, visited);
        }
        pw.flush();
        return sw.toString();
    }

    private void provenanceRecurse(PrintWriter pw, RelNode node, int i, Set<RelNode> visited) {
        Spaces.append(pw, i * 2);
        if (!visited.add(node)) {
            pw.println("rel#" + node.getId() + " (see above)");
            return;
        }
        pw.println(node);
        Provenance o = this.provenanceMap.get(node);
        Spaces.append(pw, i * 2 + 2);
        if (o == Provenance.EMPTY) {
            pw.println("no parent");
        } else if (o instanceof DirectProvenance) {
            RelNode rel = ((DirectProvenance)o).source;
            pw.println("direct");
            this.provenanceRecurse(pw, rel, i + 2, visited);
        } else if (o instanceof RuleProvenance) {
            RuleProvenance rule = (RuleProvenance)o;
            pw.println("call#" + rule.callId + " rule [" + rule.rule + "]");
            for (RelNode rel : rule.rels) {
                this.provenanceRecurse(pw, rel, i + 2, visited);
            }
        } else if (o == null && node instanceof RelSubset) {
            RelSubset subset = (RelSubset)node;
            pw.println("subset " + subset);
            this.provenanceRecurse(pw, subset.getRelList().get(0), i + 2, visited);
        } else {
            throw new AssertionError((Object)("bad type " + o));
        }
    }

    private void setInitialImportance() {
        RelVisitor visitor = new RelVisitor(){
            int depth = 0;
            final Set<RelSubset> visitedSubsets = new HashSet<RelSubset>();

            @Override
            public void visit(RelNode p, int ordinal, RelNode parent) {
                if (p instanceof RelSubset) {
                    RelSubset subset = (RelSubset)p;
                    if (this.visitedSubsets.contains(subset)) {
                        return;
                    }
                    if (subset != VolcanoPlanner.this.root) {
                        Double importance = Math.pow(0.9, this.depth);
                        VolcanoPlanner.this.ruleQueue.updateImportance(subset, importance);
                    }
                    this.visitedSubsets.add(subset);
                    ++this.depth;
                    for (RelNode rel : subset.getRels()) {
                        this.visit(rel, -1, subset);
                    }
                    --this.depth;
                } else {
                    super.visit(p, ordinal, parent);
                }
            }
        };
        visitor.go(this.root);
    }

    private void injectImportanceBoost() {
        HashSet<RelSubset> requireBoost = new HashSet<RelSubset>();
        block0: for (RelSubset subset : this.ruleQueue.subsetImportances.keySet()) {
            for (RelNode rel : subset.getRels()) {
                if (rel.getConvention() == Convention.NONE) continue;
                continue block0;
            }
            requireBoost.add(subset);
        }
        this.ruleQueue.boostImportance(requireBoost, 1.25);
    }

    private void clearImportanceBoost() {
        Set<RelSubset> empty = Collections.emptySet();
        this.ruleQueue.boostImportance(empty, 1.0);
    }

    @Override
    public RelSubset register(RelNode rel, RelNode equivRel) {
        RelSet set;
        assert (!this.isRegistered(rel)) : "pre: isRegistered(rel)";
        if (equivRel == null) {
            set = null;
        } else {
            assert (RelOptUtil.equal("rel rowtype", rel.getRowType(), "equivRel rowtype", equivRel.getRowType(), Litmus.THROW));
            set = this.getSet(equivRel);
        }
        RelSubset subset = this.registerImpl(rel, set);
        if (LOGGER.isDebugEnabled()) {
            this.validate();
        }
        return subset;
    }

    @Override
    public RelSubset ensureRegistered(RelNode rel, RelNode equivRel) {
        RelSubset subset = this.getSubset(rel);
        if (subset != null) {
            if (equivRel != null) {
                RelSubset equivSubset = this.getSubset(equivRel);
                if (subset.set != equivSubset.set) {
                    this.merge(equivSubset.set, subset.set);
                }
            }
            return subset;
        }
        return this.register(rel, equivRel);
    }

    protected void validate() {
        RelMetadataQuery mq = RelMetadataQuery.instance();
        for (RelSet set : this.allSets) {
            if (set.equivalentSet != null) {
                throw new AssertionError((Object)("set [" + set + "] has been merged: it should not be in the list"));
            }
            for (RelSubset subset : set.subsets) {
                if (subset.set != set) {
                    throw new AssertionError((Object)("subset [" + subset.getDescription() + "] is in wrong set [" + set + "]"));
                }
                for (RelNode rel : subset.getRels()) {
                    RelOptCost relCost = this.getCost(rel, mq);
                    if (relCost.isLt(subset.bestCost)) {
                        throw new AssertionError((Object)("rel [" + rel.getDescription() + "] has lower cost " + relCost + " than best cost " + subset.bestCost + " of subset [" + subset.getDescription() + "]"));
                    }
                }
            }
        }
    }

    public void registerAbstractRelationalRules() {
        this.addRule(FilterJoinRule.FILTER_ON_JOIN);
        this.addRule(FilterJoinRule.JOIN);
        this.addRule(AbstractConverter.ExpandConversionRule.INSTANCE);
        this.addRule(JoinCommuteRule.INSTANCE);
        this.addRule(SemiJoinRule.INSTANCE);
        if (CalcitePrepareImpl.COMMUTE) {
            this.addRule(JoinAssociateRule.INSTANCE);
        }
        this.addRule(AggregateRemoveRule.INSTANCE);
        this.addRule(UnionToDistinctRule.INSTANCE);
        this.addRule(ProjectRemoveRule.INSTANCE);
        this.addRule(AggregateJoinTransposeRule.INSTANCE);
        this.addRule(AggregateProjectMergeRule.INSTANCE);
        this.addRule(CalcRemoveRule.INSTANCE);
        this.addRule(SortRemoveRule.INSTANCE);
    }

    @Override
    public void registerSchema(RelOptSchema schema) {
        if (this.registeredSchemas.add(schema)) {
            try {
                schema.registerRules(this);
            }
            catch (Exception e) {
                throw Util.newInternal(e, "Error while registering schema " + schema);
            }
        }
    }

    @Override
    public RelOptCost getCost(RelNode rel, RelMetadataQuery mq) {
        assert (rel != null) : "pre-condition: rel != null";
        if (rel instanceof RelSubset) {
            return ((RelSubset)rel).bestCost;
        }
        if (rel.getTraitSet().getTrait(ConventionTraitDef.INSTANCE) == Convention.NONE) {
            return this.costFactory.makeInfiniteCost();
        }
        RelOptCost cost = mq.getNonCumulativeCost(rel);
        if (!this.zeroCost.isLt(cost)) {
            cost = this.costFactory.makeTinyCost();
        }
        for (RelNode input : rel.getInputs()) {
            cost = cost.plus(this.getCost(input, mq));
        }
        return cost;
    }

    public RelSubset getSubset(RelNode rel) {
        assert (rel != null) : "pre: rel != null";
        if (rel instanceof RelSubset) {
            return (RelSubset)rel;
        }
        return this.mapRel2Subset.get(rel);
    }

    public RelSubset getSubset(RelNode rel, RelTraitSet traits) {
        return this.getSubset(rel, traits, false);
    }

    public RelSubset getSubset(RelNode rel, RelTraitSet traits, boolean createIfMissing) {
        if (rel instanceof RelSubset && rel.getTraitSet().equals(traits)) {
            return (RelSubset)rel;
        }
        RelSet set = this.getSet(rel);
        if (set == null) {
            return null;
        }
        if (createIfMissing) {
            return set.getOrCreateSubset(rel.getCluster(), traits);
        }
        return set.getSubset(traits);
    }

    private RelNode changeTraitsUsingConverters(RelNode rel, RelTraitSet toTraits, boolean allowAbstractConverters) {
        RelTraitSet fromTraits = rel.getTraitSet();
        assert (fromTraits.size() >= toTraits.size());
        boolean allowInfiniteCostConverters = SaffronProperties.instance().allowInfiniteCostConverters.get();
        RelNode converted = rel;
        for (int i = 0; converted != null && i < toTraits.size(); ++i) {
            RelTrait fromTrait = converted.getTraitSet().getTrait(i);
            RelTraitDef traitDef = fromTrait.getTraitDef();
            RelTrait toTrait = toTraits.getTrait(i);
            if (toTrait == null) continue;
            assert (traitDef == toTrait.getTraitDef());
            if (fromTrait.equals(toTrait)) continue;
            rel = traitDef.convert(this, converted, toTrait, allowInfiniteCostConverters);
            if (rel != null) {
                assert (rel.getTraitSet().getTrait(traitDef).satisfies(toTrait));
                if ((rel = this.completeConversion(rel, allowInfiniteCostConverters, toTraits, Expressions.list(traitDef))) != null) {
                    this.register(rel, converted);
                }
            }
            if (rel == null && allowAbstractConverters) {
                RelTraitSet stepTraits = converted.getTraitSet().replace(toTrait);
                rel = this.getSubset(converted, stepTraits);
            }
            converted = rel;
        }
        if (converted != null) assert (converted.getTraitSet().satisfies(toTraits));
        return converted;
    }

    private RelNode completeConversion(RelNode rel, boolean allowInfiniteCostConverters, RelTraitSet toTraits, Expressions.FluentList<RelTraitDef> usedTraits) {
        return rel;
    }

    RelNode changeTraitsUsingConverters(RelNode rel, RelTraitSet toTraits) {
        return this.changeTraitsUsingConverters(rel, toTraits, false);
    }

    void checkForSatisfiedConverters(RelSet set, RelNode rel) {
        int i = 0;
        while (i < set.abstractConverters.size()) {
            AbstractConverter converter = set.abstractConverters.get(i);
            RelNode converted = this.changeTraitsUsingConverters(rel, converter.getTraitSet());
            if (converted == null) {
                ++i;
                continue;
            }
            if (!this.isRegistered(converted)) {
                this.registerImpl(converted, set);
            }
            set.abstractConverters.remove(converter);
        }
    }

    @Override
    public void setImportance(RelNode rel, double importance) {
        assert (rel != null);
        if (importance == 0.0) {
            this.relImportances.put(rel, importance);
        }
    }

    public void dump(PrintWriter pw) {
        RelMetadataQuery mq = RelMetadataQuery.instance();
        pw.println("Root: " + this.root.getDescription());
        pw.println("Original rel:");
        pw.println(this.originalRootString);
        pw.println("Sets:");
        RelSet[] sets = this.allSets.toArray(new RelSet[this.allSets.size()]);
        Arrays.sort(sets, new Comparator<RelSet>(){

            @Override
            public int compare(RelSet o1, RelSet o2) {
                return o1.id - o2.id;
            }
        });
        for (RelSet set : sets) {
            pw.println("Set#" + set.id + ", type: " + set.subsets.get(0).getRowType());
            int j2 = -1;
            for (RelSubset subset : set.subsets) {
                ++j2;
                pw.println("\t" + subset.getDescription() + ", best=" + (subset.best == null ? "null" : "rel#" + subset.best.getId()) + ", importance=" + this.ruleQueue.getImportance(subset));
                assert (subset.set == set);
                for (int k = 0; k < j2; ++k) {
                    assert (!set.subsets.get(k).getTraitSet().equals(subset.getTraitSet()));
                }
                for (RelNode rel : subset.getRels()) {
                    pw.print("\t\t" + rel.getDescription());
                    for (RelNode input : rel.getInputs()) {
                        Iterator<RelNode> rels;
                        RelSubset inputSubset = this.getSubset(input, input.getTraitSet());
                        RelSet inputSet = inputSubset.set;
                        if (!(input instanceof RelSubset) || !(rels = inputSubset.getRels().iterator()).hasNext()) continue;
                        input = rels.next();
                        assert (input.getTraitSet().satisfies(inputSubset.getTraitSet()));
                        assert (inputSet.rels.contains(input));
                        assert (inputSet.subsets.contains(inputSubset));
                    }
                    Double importance = this.relImportances.get(rel);
                    if (importance != null) {
                        pw.print(", importance=" + importance);
                    }
                    pw.print(", rowcount=" + mq.getRowCount(rel));
                    pw.println(", cumulative cost=" + this.getCost(rel, mq));
                }
            }
        }
        pw.println();
    }

    private static Pair<String, RelDataType> key(RelNode rel) {
        return Pair.of(rel.getDigest(), rel.getRowType());
    }

    void rename(RelNode rel) {
        String oldDigest = rel.getDigest();
        if (this.fixUpInputs(rel)) {
            Pair<String, RelDataType> oldKey = Pair.of(oldDigest, rel.getRowType());
            RelNode removed = this.mapDigestToRel.remove(oldKey);
            assert (removed == rel);
            String newDigest = rel.recomputeDigest();
            LOGGER.trace("Rename #{} from '{}' to '{}'", rel.getId(), oldDigest, newDigest);
            Pair<String, RelDataType> key = VolcanoPlanner.key(rel);
            RelNode equivRel = this.mapDigestToRel.put(key, rel);
            if (equivRel != null) {
                assert (equivRel != rel);
                LOGGER.trace("After renaming rel#{} it is now equivalent to rel#{}", (Object)rel.getId(), (Object)equivRel.getId());
                this.mapDigestToRel.put(key, equivRel);
                RelSubset equivRelSubset = this.getSubset(equivRel);
                this.ruleQueue.recompute(equivRelSubset, true);
                for (RelNode input : rel.getInputs()) {
                    ((RelSubset)input).set.parents.remove(rel);
                }
                RelSubset subset = this.mapRel2Subset.put(rel, equivRelSubset);
                assert (subset != null);
                boolean existed = subset.set.rels.remove(rel);
                assert (existed) : "rel was not known to its set";
                RelSubset equivSubset = this.getSubset(equivRel);
                if (equivSubset != subset) {
                    assert (equivSubset.getTraitSet().equals(subset.getTraitSet()));
                    assert (equivSubset.set != subset.set);
                    this.merge(equivSubset.set, subset.set);
                }
            }
        }
    }

    void reregister(RelSet set, RelNode rel) {
        Pair<String, RelDataType> key = VolcanoPlanner.key(rel);
        RelNode equivRel = this.mapDigestToRel.get(key);
        if (equivRel != null && equivRel != rel) {
            assert (equivRel.getClass() == rel.getClass());
            assert (equivRel.getTraitSet().equals(rel.getTraitSet()));
            RelSubset equivRelSubset = this.getSubset(equivRel);
            this.ruleQueue.recompute(equivRelSubset, true);
            return;
        }
        RelSubset subset2 = this.addRelToSet(rel, set);
    }

    private RelSubset canonize(RelSubset subset) {
        if (subset.set.equivalentSet == null) {
            return subset;
        }
        RelSet set = subset.set;
        do {
            set = set.equivalentSet;
        } while (set.equivalentSet != null);
        return set.getOrCreateSubset(subset.getCluster(), subset.getTraitSet());
    }

    void fireRules(RelNode rel, boolean deferred) {
        for (RelOptRuleOperand operand : this.classOperands.get(rel.getClass())) {
            if (!operand.matches(rel)) continue;
            VolcanoRuleCall ruleCall = deferred ? new DeferringRuleCall(this, operand) : new VolcanoRuleCall(this, operand);
            ruleCall.match(rel);
        }
    }

    private boolean fixUpInputs(RelNode rel) {
        List<RelNode> inputs = rel.getInputs();
        int i = -1;
        int changeCount = 0;
        for (RelNode input : inputs) {
            RelSubset subset;
            RelSubset newSubset;
            ++i;
            if (!(input instanceof RelSubset) || (newSubset = this.canonize(subset = (RelSubset)input)) == subset) continue;
            rel.replaceInput(i, newSubset);
            if (subset.set != newSubset.set) {
                subset.set.parents.remove(rel);
                newSubset.set.parents.add(rel);
            }
            ++changeCount;
        }
        return changeCount > 0;
    }

    private RelSet merge(RelSet set, RelSet set2) {
        assert (set != set2) : "pre: set != set2";
        set = VolcanoPlanner.equivRoot(set);
        if ((set2 = VolcanoPlanner.equivRoot(set2)) == set) {
            return set;
        }
        if (set.id > set2.id) {
            RelSet t = set;
            set = set2;
            set2 = t;
        }
        set.mergeWith(this, set2);
        if (set2 == this.getSet(this.root)) {
            this.root = set.getOrCreateSubset(this.root.getCluster(), this.root.getTraitSet());
            this.ensureRootConverters();
        }
        return set;
    }

    private static RelSet equivRoot(RelSet s) {
        RelSet p = s;
        while (s.equivalentSet != null) {
            p = VolcanoPlanner.forward2(s, p);
            s = s.equivalentSet;
        }
        return s;
    }

    private static RelSet forward2(RelSet s, RelSet p) {
        p = VolcanoPlanner.forward1(s, p);
        p = VolcanoPlanner.forward1(s, p);
        return p;
    }

    private static RelSet forward1(RelSet s, RelSet p) {
        if (p != null && (p = p.equivalentSet) == s) {
            throw Util.newInternal("cycle in equivalence tree");
        }
        return p;
    }

    private RelSubset registerImpl(RelNode rel, RelSet set) {
        if (rel instanceof RelSubset) {
            return this.registerSubset(set, (RelSubset)rel);
        }
        assert (!this.isRegistered(rel)) : "already been registered: " + rel;
        if (rel.getCluster().getPlanner() != this) {
            throw Util.newInternal("Relational expression " + rel + " belongs to a different planner than is currently being" + " used.");
        }
        RelTraitSet traits = rel.getTraitSet();
        Convention convention = traits.getTrait(ConventionTraitDef.INSTANCE);
        assert (convention != null);
        if (!convention.getInterface().isInstance(rel) && !(rel instanceof Converter)) {
            throw Util.newInternal("Relational expression " + rel + " has calling-convention " + convention + " but does not implement the required interface '" + convention.getInterface() + "' of that convention");
        }
        if (traits.size() != this.traitDefs.size()) {
            throw Util.newInternal("Relational expression " + rel + " does not have the correct number of traits " + traits.size() + " != " + this.traitDefs.size());
        }
        rel = rel.onRegister(this);
        if (this.ruleCallStack.isEmpty()) {
            this.provenanceMap.put(rel, Provenance.EMPTY);
        } else {
            VolcanoRuleCall ruleCall = this.ruleCallStack.peek();
            this.provenanceMap.put(rel, new RuleProvenance(ruleCall.rule, ImmutableList.copyOf(ruleCall.rels), ruleCall.id));
        }
        Pair<String, RelDataType> key = VolcanoPlanner.key(rel);
        RelNode equivExp = this.mapDigestToRel.get(key);
        if (equivExp != null) {
            if (equivExp == rel) {
                return this.getSubset(rel);
            }
            assert (RelOptUtil.equal("left", equivExp.getRowType(), "right", rel.getRowType(), Litmus.THROW));
            RelSet equivSet = this.getSet(equivExp);
            if (equivSet != null) {
                LOGGER.trace("Register: rel#{} is equivalent to {}", (Object)rel.getId(), (Object)equivExp.getDescription());
                return this.registerSubset(set, this.getSubset(equivExp));
            }
        }
        if (rel instanceof Converter) {
            RelNode input = ((Converter)rel).getInput();
            RelSet childSet = this.getSet(input);
            if (set != null && set != childSet && set.equivalentSet == null) {
                LOGGER.trace("Register #{} {} (and merge sets, because it is a conversion)", (Object)rel.getId(), (Object)rel.getDigest());
                this.merge(set, childSet);
                ++this.registerCount;
                if (this.fixUpInputs(rel)) {
                    rel.recomputeDigest();
                    key = VolcanoPlanner.key(rel);
                    RelNode equivRel = this.mapDigestToRel.get(key);
                    if (equivRel != rel && equivRel != null) {
                        set.obliterateRelNode(rel);
                        return this.getSubset(equivRel);
                    }
                }
            } else {
                set = childSet;
            }
        }
        if (set == null) {
            set = new RelSet(this.nextSetId++, Util.minus(RelOptUtil.getVariablesSet(rel), rel.getVariablesSet()), RelOptUtil.getVariablesUsed(rel));
            this.allSets.add(set);
        }
        while (set.equivalentSet != null) {
            set = set.equivalentSet;
        }
        this.registerClass(rel);
        ++this.registerCount;
        int subsetBeforeCount = set.subsets.size();
        RelSubset subset = this.addRelToSet(rel, set);
        RelNode xx = this.mapDigestToRel.put(key, rel);
        assert (xx == null || xx == rel) : rel.getDigest();
        LOGGER.trace("Register {} in {}", (Object)rel.getDescription(), (Object)subset.getDescription());
        if (xx != null) {
            return subset;
        }
        if (rel == this.root) {
            this.ruleQueue.subsetImportances.put(subset, 1.0);
        }
        for (RelNode input : rel.getInputs()) {
            RelSubset childSubset = (RelSubset)input;
            childSubset.set.parents.add(rel);
            this.ruleQueue.recompute(childSubset);
        }
        if (rel == this.root) {
            this.ruleQueue.subsetImportances.remove(subset);
        }
        if (rel instanceof AbstractConverter) {
            set.abstractConverters.add((AbstractConverter)rel);
        }
        this.checkForSatisfiedConverters(set, rel);
        this.ruleQueue.recompute(subset, true);
        this.fireRules(rel, true);
        if (set.subsets.size() > subsetBeforeCount) {
            this.fireRules(subset, true);
        }
        return subset;
    }

    private RelSubset addRelToSet(RelNode rel, RelSet set) {
        RelSubset subset = set.add(rel);
        this.mapRel2Subset.put(rel, subset);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        subset.propagateCostImprovements(this, mq, rel, new HashSet<RelSubset>());
        return subset;
    }

    private RelSubset registerSubset(RelSet set, RelSubset subset) {
        if (set != subset.set && set != null && set.equivalentSet == null) {
            LOGGER.trace("Register #{} {}, and merge sets", (Object)subset.getId(), (Object)subset);
            this.merge(set, subset.set);
            ++this.registerCount;
        }
        return subset;
    }

    @Override
    public void addListener(RelOptListener newListener) {
        if (this.listener != null) {
            throw Util.needToImplement("multiple VolcanoPlanner listeners");
        }
        this.listener = newListener;
    }

    @Override
    public void registerMetadataProviders(List<RelMetadataProvider> list) {
        list.add(0, new VolcanoRelMetadataProvider());
    }

    @Override
    public long getRelMetadataTimestamp(RelNode rel) {
        RelSubset subset = this.getSubset(rel);
        if (subset == null) {
            return 0L;
        }
        return subset.timestamp;
    }

    public static String normalizePlan(String plan) {
        if (plan == null) {
            return null;
        }
        Pattern poundDigits = Pattern.compile("Subset#[0-9]+\\.");
        int i = 0;
        Matcher matcher;
        while ((matcher = poundDigits.matcher(plan)).find()) {
            String token = matcher.group();
            plan = plan.replace(token, "Subset#{" + i++ + "}.");
        }
        return plan;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void ensureRegistered(RelNode rel, RelNode equivRel, VolcanoRuleCall ruleCall) {
        this.ruleCallStack.push(ruleCall);
        this.ensureRegistered(rel, equivRel);
        this.ruleCallStack.pop();
    }

    static class RuleProvenance
    extends Provenance {
        final RelOptRule rule;
        final ImmutableList<RelNode> rels;
        final int callId;

        RuleProvenance(RelOptRule rule, ImmutableList<RelNode> rels, int callId) {
            this.rule = rule;
            this.rels = rels;
            this.callId = callId;
        }
    }

    static class DirectProvenance
    extends Provenance {
        final RelNode source;

        DirectProvenance(RelNode source) {
            this.source = source;
        }
    }

    private static class UnknownProvenance
    extends Provenance {
        private UnknownProvenance() {
        }
    }

    private static abstract class Provenance {
        public static final Provenance EMPTY = new UnknownProvenance();

        private Provenance() {
        }
    }

    private static class DeferringRuleCall
    extends VolcanoRuleCall {
        DeferringRuleCall(VolcanoPlanner planner, RelOptRuleOperand operand) {
            super(planner, operand);
        }

        @Override
        protected void onMatch() {
            VolcanoRuleMatch match = new VolcanoRuleMatch(this.volcanoPlanner, this.getOperand0(), this.rels, (Map<RelNode, List<RelNode>>)this.nodeInputs);
            this.volcanoPlanner.ruleQueue.addMatch(match);
        }
    }
}

