/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTraitPropagationVisitor;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.Util;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableMap;
import org.apache.flink.shaded.calcite.com.google.common.collect.Lists;

public class VolcanoRuleCall
extends RelOptRuleCall {
    protected final VolcanoPlanner volcanoPlanner;
    private List<RelNode> generatedRelList;

    protected VolcanoRuleCall(VolcanoPlanner planner, RelOptRuleOperand operand, RelNode[] rels, Map<RelNode, List<RelNode>> nodeInputs) {
        super(planner, operand, rels, nodeInputs);
        this.volcanoPlanner = planner;
    }

    VolcanoRuleCall(VolcanoPlanner planner, RelOptRuleOperand operand) {
        this(planner, operand, new RelNode[operand.getRule().operands.size()], ImmutableMap.of());
    }

    @Override
    public void transformTo(RelNode rel, Map<RelNode, RelNode> equiv) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Transform to: rel#{}" + rel.getId() + " via {}{}", rel.getId(), this.getRule(), equiv.isEmpty() ? "" : " with equivalences " + equiv);
            if (this.generatedRelList != null) {
                this.generatedRelList.add(rel);
            }
        }
        try {
            RelOptListener.RuleProductionEvent event;
            RelTraitSet rels0Traits = this.rels[0].getTraitSet();
            new RelTraitPropagationVisitor(this.getPlanner(), rels0Traits).go(rel);
            if (LOGGER.isTraceEnabled()) {
                String relDesc = "rel#" + rel.getId() + ":" + rel.getRelTypeName();
                LOGGER.trace("call#{}: Rule {} arguments {} created {}", this.id, this.getRule(), Arrays.toString(this.rels), relDesc);
            }
            if (this.volcanoPlanner.listener != null) {
                event = new RelOptListener.RuleProductionEvent(this.volcanoPlanner, rel, this, true);
                this.volcanoPlanner.listener.ruleProductionSucceeded(event);
            }
            for (Map.Entry<RelNode, RelNode> entry : equiv.entrySet()) {
                this.volcanoPlanner.ensureRegistered(entry.getKey(), entry.getValue(), this);
            }
            this.volcanoPlanner.ensureRegistered(rel, this.rels[0], this);
            if (this.volcanoPlanner.listener != null) {
                event = new RelOptListener.RuleProductionEvent(this.volcanoPlanner, rel, this, false);
                this.volcanoPlanner.listener.ruleProductionSucceeded(event);
            }
        }
        catch (Throwable e) {
            throw Util.newInternal(e, "Error occurred while applying rule " + this.getRule());
        }
    }

    protected void onMatch() {
        assert (this.getRule().matches(this));
        this.volcanoPlanner.checkCancel();
        try {
            if (this.volcanoPlanner.isRuleExcluded(this.getRule())) {
                LOGGER.debug("Rule [{}] not fired due to exclusion filter", (Object)this.getRule());
                return;
            }
            for (int i = 0; i < this.rels.length; ++i) {
                RelNode rel = this.rels[i];
                RelSubset subset = this.volcanoPlanner.getSubset(rel);
                if (subset == null) {
                    LOGGER.debug("Rule [{}] not fired because operand #{} ({}) has no subset", this.getRule(), i, rel);
                    return;
                }
                if (subset.set.equivalentSet != null) {
                    LOGGER.debug("Rule [{}] not fired because operand #{} ({}) belongs to obsolete set", this.getRule(), i, rel);
                    return;
                }
                Double importance = this.volcanoPlanner.relImportances.get(rel);
                if (importance == null || importance != 0.0) continue;
                LOGGER.debug("Rule [{}] not fired because operand #{} ({}) has importance=0", this.getRule(), i, rel);
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("call#{}: Apply rule [{}] to {}", this.id, this.getRule(), Arrays.toString(this.rels));
            }
            if (this.volcanoPlanner.listener != null) {
                RelOptListener.RuleAttemptedEvent event = new RelOptListener.RuleAttemptedEvent(this.volcanoPlanner, this.rels[0], this, true);
                this.volcanoPlanner.listener.ruleAttempted(event);
            }
            if (LOGGER.isDebugEnabled()) {
                this.generatedRelList = new ArrayList<RelNode>();
            }
            this.getRule().onMatch(this);
            if (LOGGER.isDebugEnabled()) {
                if (this.generatedRelList.isEmpty()) {
                    LOGGER.debug("call#{} generated 0 successors.", (Object)this.id);
                } else {
                    LOGGER.debug("call#{} generated {} successors: {}", this.id, this.generatedRelList.size(), this.generatedRelList);
                }
                this.generatedRelList = null;
            }
            if (this.volcanoPlanner.listener != null) {
                RelOptListener.RuleAttemptedEvent event = new RelOptListener.RuleAttemptedEvent(this.volcanoPlanner, this.rels[0], this, false);
                this.volcanoPlanner.listener.ruleAttempted(event);
            }
        }
        catch (Throwable e) {
            throw Util.newInternal(e, "Error while applying rule " + this.getRule() + ", args " + Arrays.toString(this.rels));
        }
    }

    void match(RelNode rel) {
        assert (this.getOperand0().matches(rel));
        boolean solve = false;
        int operandOrdinal = this.getOperand0().solveOrder[0];
        this.rels[operandOrdinal] = rel;
        this.matchRecurse(1);
    }

    private void matchRecurse(int solve) {
        List<RelOptRuleOperand> operands = this.getRule().operands;
        if (solve == operands.size()) {
            if (this.getRule().matches(this)) {
                this.onMatch();
            }
        } else {
            List<RelNode> inputs;
            Collection<RelNode> successors;
            RelOptRuleOperand parentOperand;
            int operandOrdinal = this.operand0.solveOrder[solve];
            int previousOperandOrdinal = this.operand0.solveOrder[solve - 1];
            boolean ascending = operandOrdinal < previousOperandOrdinal;
            RelOptRuleOperand previousOperand = operands.get(previousOperandOrdinal);
            RelOptRuleOperand operand = operands.get(operandOrdinal);
            RelNode previous = this.rels[previousOperandOrdinal];
            if (ascending) {
                assert (previousOperand.getParent() == operand);
                parentOperand = operand;
                RelSubset subset = this.volcanoPlanner.getSubset(previous);
                successors = subset.getParentRels();
            } else {
                parentOperand = previousOperand;
                int parentOrdinal = operand.getParent().ordinalInRule;
                RelNode parentRel = this.rels[parentOrdinal];
                inputs = parentRel.getInputs();
                if (operand.ordinalInParent < inputs.size()) {
                    RelSubset subset = (RelSubset)inputs.get(operand.ordinalInParent);
                    successors = operand.getMatchedClass() == RelSubset.class ? subset.set.subsets : subset.getRelList();
                } else {
                    successors = ImmutableList.of();
                }
            }
            for (RelNode rel : successors) {
                if (!operand.matches(rel)) continue;
                if (ascending) {
                    RelSubset input = (RelSubset)rel.getInput(previousOperand.ordinalInParent);
                    List<RelNode> inputRels = input.set.getRelsFromAllSubsets();
                    if (!inputRels.contains(previous)) continue;
                }
                switch (parentOperand.childPolicy) {
                    case UNORDERED: {
                        if (ascending) {
                            inputs = Lists.newArrayList(rel.getInputs());
                            inputs.set(previousOperand.ordinalInParent, previous);
                            this.setChildRels(rel, inputs);
                            break;
                        }
                        inputs = this.getChildRels(previous);
                        if (inputs == null) {
                            inputs = Lists.newArrayList(previous.getInputs());
                        }
                        inputs.set(operand.ordinalInParent, rel);
                        this.setChildRels(previous, inputs);
                    }
                }
                this.rels[operandOrdinal] = rel;
                this.matchRecurse(solve + 1);
            }
        }
    }
}

