/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.convert;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.Converter;
import org.apache.flink.shaded.calcite.com.google.common.base.Preconditions;
import org.apache.flink.shaded.calcite.com.google.common.base.Predicate;
import org.apache.flink.shaded.calcite.com.google.common.base.Predicates;

public abstract class ConverterRule
extends RelOptRule {
    private final RelTrait inTrait;
    private final RelTrait outTrait;

    public ConverterRule(Class<? extends RelNode> clazz, RelTrait in, RelTrait out, String description) {
        this(clazz, Predicates.alwaysTrue(), in, out, description);
    }

    public <R extends RelNode> ConverterRule(Class<R> clazz, Predicate<? super R> predicate, RelTrait in, RelTrait out, String description) {
        super(new ConverterRelOptRuleOperand(clazz, in, predicate), description == null ? "ConverterRule<in=" + in + ",out=" + out + ">" : description);
        this.inTrait = Preconditions.checkNotNull(in);
        this.outTrait = Preconditions.checkNotNull(out);
        assert (in.getTraitDef() == out.getTraitDef());
    }

    @Override
    public Convention getOutConvention() {
        return (Convention)this.outTrait;
    }

    @Override
    public RelTrait getOutTrait() {
        return this.outTrait;
    }

    public RelTrait getInTrait() {
        return this.inTrait;
    }

    public RelTraitDef getTraitDef() {
        return this.inTrait.getTraitDef();
    }

    public abstract RelNode convert(RelNode var1);

    public boolean isGuaranteed() {
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode converted;
        Object rel = call.rel(0);
        if (rel.getTraitSet().contains(this.inTrait) && (converted = this.convert((RelNode)rel)) != null) {
            call.transformTo(converted);
        }
    }

    private static class ConverterRelOptRuleOperand
    extends RelOptRuleOperand {
        public <R extends RelNode> ConverterRelOptRuleOperand(Class<R> clazz, RelTrait in, Predicate<? super R> predicate) {
            super(clazz, in, predicate, RelOptRule.any());
        }

        @Override
        public boolean matches(RelNode rel) {
            if (rel instanceof Converter && ((ConverterRule)this.getRule()).getTraitDef() == ((Converter)rel).getTraitDef()) {
                return false;
            }
            return super.matches(rel);
        }
    }
}

