/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import java.util.concurrent.ExecutionException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataFactory;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.metadata.UnboundMetadata;
import org.apache.calcite.util.Pair;
import org.apache.flink.shaded.calcite.com.google.common.base.Throwables;
import org.apache.flink.shaded.calcite.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.calcite.com.google.common.cache.CacheLoader;
import org.apache.flink.shaded.calcite.com.google.common.cache.LoadingCache;
import org.apache.flink.shaded.calcite.com.google.common.util.concurrent.UncheckedExecutionException;

public class MetadataFactoryImpl
implements MetadataFactory {
    public static final UnboundMetadata<Metadata> DUMMY = new UnboundMetadata<Metadata>(){

        @Override
        public Metadata bind(RelNode rel, RelMetadataQuery mq) {
            return null;
        }
    };
    private final LoadingCache<Pair<Class<RelNode>, Class<Metadata>>, UnboundMetadata<Metadata>> cache;

    public MetadataFactoryImpl(RelMetadataProvider provider) {
        this.cache = CacheBuilder.newBuilder().build(MetadataFactoryImpl.loader(provider));
    }

    static CacheLoader<Pair<Class<RelNode>, Class<Metadata>>, UnboundMetadata<Metadata>> loader(final RelMetadataProvider provider) {
        return new CacheLoader<Pair<Class<RelNode>, Class<Metadata>>, UnboundMetadata<Metadata>>(){

            @Override
            public UnboundMetadata<Metadata> load(Pair<Class<RelNode>, Class<Metadata>> key) throws Exception {
                UnboundMetadata function = provider.apply((Class)key.left, (Class)key.right);
                return function != null ? function : DUMMY;
            }
        };
    }

    @Override
    public <M extends Metadata> M query(RelNode rel, RelMetadataQuery mq, Class<M> metadataClazz) {
        try {
            Pair<Class<?>, Class<M>> key = Pair.of(rel.getClass(), metadataClazz);
            Metadata apply2 = this.cache.get(key).bind(rel, mq);
            return (M)((Metadata)metadataClazz.cast(apply2));
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }
}

