/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.tools.RelBuilderFactory;

public class ProjectFilterTransposeRule
extends RelOptRule {
    public static final ProjectFilterTransposeRule INSTANCE = new ProjectFilterTransposeRule(LogicalProject.class, LogicalFilter.class, RelFactories.LOGICAL_BUILDER, PushProjector.ExprCondition.FALSE);
    private final PushProjector.ExprCondition preserveExprCondition;

    public ProjectFilterTransposeRule(Class<? extends Project> projectClass, Class<? extends Filter> filterClass, RelBuilderFactory relBuilderFactory, PushProjector.ExprCondition preserveExprCondition) {
        super(ProjectFilterTransposeRule.operand(projectClass, ProjectFilterTransposeRule.operand(filterClass, ProjectFilterTransposeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        this.preserveExprCondition = preserveExprCondition;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalFilter filter;
        LogicalProject origProj;
        if (call.rels.length == 2) {
            origProj = (LogicalProject)call.rel(0);
            filter = (LogicalFilter)call.rel(1);
        } else {
            origProj = null;
            filter = (LogicalFilter)call.rel(0);
        }
        RelNode rel = filter.getInput();
        RexNode origFilter = filter.getCondition();
        if (origProj != null && RexOver.containsOver(origProj.getProjects(), null)) {
            return;
        }
        PushProjector pushProjector = new PushProjector(origProj, origFilter, rel, this.preserveExprCondition);
        RelNode topProject = pushProjector.convertProject(null);
        if (topProject != null) {
            call.transformTo(topProject);
        }
    }
}

