/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.util.ImmutableNullableList;

public class FlatLists {
    public static final ComparableEmptyList COMPARABLE_EMPTY_LIST = new ComparableEmptyList();

    private FlatLists() {
    }

    public static <T> List<T> of() {
        return COMPARABLE_EMPTY_LIST;
    }

    public static <T> List<T> of(T t0) {
        return new Flat1List<T>(t0);
    }

    public static <T> List<T> of(T t0, T t1) {
        return new Flat2List<T>(t0, t1);
    }

    public static <T> List<T> of(T t0, T t1, T t2) {
        return new Flat3List<T>(t0, t1, t2);
    }

    public static <T> List<T> of(T t0, T t1, T t2, T t3) {
        return new Flat4List<T>(t0, t1, t2, t3);
    }

    public static <T> List<T> of(T t0, T t1, T t2, T t3, T t4) {
        return new Flat5List<T>(t0, t1, t2, t3, t4);
    }

    public static <T> List<T> of(T t0, T t1, T t2, T t3, T t4, T t5) {
        return new Flat6List<T>(t0, t1, t2, t3, t4, t5);
    }

    public static <T extends Comparable> List<T> of(T ... t) {
        return FlatLists.flatList_(t, (boolean)false);
    }

    @Deprecated
    public static <T> List<T> copy(T ... t) {
        return FlatLists.flatListNotComparable(t);
    }

    public static <T extends Comparable> List<T> copyOf(T ... t) {
        return FlatLists.flatList_(t, (boolean)true);
    }

    public static <T> List<T> copyOf(T ... t) {
        return FlatLists.flatListNotComparable(t);
    }

    private static <T extends Comparable> List<T> flatList_(T[] t, boolean copy) {
        switch (t.length) {
            case 0: {
                return COMPARABLE_EMPTY_LIST;
            }
            case 1: {
                return Collections.singletonList(t[0]);
            }
            case 2: {
                return new Flat2List<T>(t[0], t[1]);
            }
            case 3: {
                return new Flat3List<T>(t[0], t[1], t[2]);
            }
            case 4: {
                return new Flat4List<T>(t[0], t[1], t[2], t[3]);
            }
            case 5: {
                return new Flat5List<T>(t[0], t[1], t[2], t[3], t[4]);
            }
            case 6: {
                return new Flat6List<T>(t[0], t[1], t[2], t[3], t[4], t[5]);
            }
        }
        if (copy) {
            return new ComparableListImpl<Object>(Arrays.asList((Object[])t.clone()));
        }
        return new ComparableListImpl<T>(Arrays.asList(t));
    }

    private static <T> List<T> flatListNotComparable(T[] t) {
        switch (t.length) {
            case 0: {
                return COMPARABLE_EMPTY_LIST;
            }
            case 1: {
                return new Flat1List<T>(t[0]);
            }
            case 2: {
                return new Flat2List<T>(t[0], t[1]);
            }
            case 3: {
                return new Flat3List<T>(t[0], t[1], t[2]);
            }
            case 4: {
                return new Flat4List<T>(t[0], t[1], t[2], t[3]);
            }
            case 5: {
                return new Flat5List<T>(t[0], t[1], t[2], t[3], t[4]);
            }
            case 6: {
                return new Flat6List<T>(t[0], t[1], t[2], t[3], t[4], t[5]);
            }
        }
        return ImmutableNullableList.copyOf(t);
    }

    public static <T> List<T> of(List<T> t) {
        switch (t.size()) {
            case 0: {
                return COMPARABLE_EMPTY_LIST;
            }
            case 1: {
                return Collections.singletonList(t.get(0));
            }
            case 2: {
                return new Flat2List<T>(t.get(0), t.get(1));
            }
            case 3: {
                return new Flat3List<T>(t.get(0), t.get(1), t.get(2));
            }
            case 4: {
                return new Flat4List<T>(t.get(0), t.get(1), t.get(2), t.get(3));
            }
            case 5: {
                return new Flat5List<T>(t.get(0), t.get(1), t.get(2), t.get(3), t.get(4));
            }
            case 6: {
                return new Flat6List<T>(t.get(0), t.get(1), t.get(2), t.get(3), t.get(4), t.get(5));
            }
        }
        return new ComparableListImpl<Object>(Arrays.asList(t.toArray()));
    }

    static class ComparableListImpl<T extends Comparable<T>>
    extends AbstractList<T>
    implements ComparableList<T> {
        private final List<T> list;

        protected ComparableListImpl(List<T> list) {
            this.list = list;
        }

        @Override
        public T get(int index) {
            return (T)((Comparable)this.list.get(index));
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public int compareTo(List o) {
            return ComparableListImpl.compare(this.list, o);
        }

        static <T extends Comparable<T>> int compare(List<T> list0, List<T> list1) {
            int size0 = list0.size();
            int size1 = list1.size();
            if (size1 == size0) {
                return ComparableListImpl.compare(list0, list1, size0);
            }
            int c = ComparableListImpl.compare(list0, list1, Math.min(size0, size1));
            if (c != 0) {
                return c;
            }
            return size0 - size1;
        }

        static <T extends Comparable<T>> int compare(List<T> list0, List<T> list1, int size) {
            for (int i = 0; i < size; ++i) {
                Comparable o1;
                Comparable o0 = (Comparable)list0.get(i);
                int c = ComparableListImpl.compare(o0, o1 = (Comparable)list1.get(i));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }

        static <T extends Comparable<T>> int compare(T a, T b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return a.compareTo(b);
        }
    }

    public static interface ComparableList<T>
    extends List<T>,
    Comparable<List> {
    }

    private static class ComparableEmptyList<T>
    extends AbstractList<T>
    implements ComparableList<T> {
        private ComparableEmptyList() {
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || o instanceof List && ((List)o).isEmpty();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int compareTo(List o) {
            return ComparableListImpl.compare(this, o);
        }
    }

    protected static class Flat6List<T>
    extends AbstractFlatList<T>
    implements ComparableList<T> {
        private final T t0;
        private final T t1;
        private final T t2;
        private final T t3;
        private final T t4;
        private final T t5;

        Flat6List(T t0, T t1, T t2, T t3, T t4, T t5) {
            this.t0 = t0;
            this.t1 = t1;
            this.t2 = t2;
            this.t3 = t3;
            this.t4 = t4;
            this.t5 = t5;
        }

        public String toString() {
            return "[" + this.t0 + ", " + this.t1 + ", " + this.t2 + "," + this.t3 + ", " + this.t4 + ", " + this.t5 + "]";
        }

        @Override
        public T get(int index) {
            switch (index) {
                case 0: {
                    return this.t0;
                }
                case 1: {
                    return this.t1;
                }
                case 2: {
                    return this.t2;
                }
                case 3: {
                    return this.t3;
                }
                case 4: {
                    return this.t4;
                }
                case 5: {
                    return this.t5;
                }
            }
            throw new IndexOutOfBoundsException("index " + index);
        }

        @Override
        public int size() {
            return 6;
        }

        @Override
        public Iterator<T> iterator() {
            return Arrays.asList(this.t0, this.t1, this.t2, this.t3, this.t4, this.t5).iterator();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Flat6List) {
                Flat6List that = (Flat6List)o;
                return Objects.equals(this.t0, that.t0) && Objects.equals(this.t1, that.t1) && Objects.equals(this.t2, that.t2) && Objects.equals(this.t3, that.t3) && Objects.equals(this.t4, that.t4) && Objects.equals(this.t5, that.t5);
            }
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            int h = 1;
            h = h * 31 + Utilities.hash(this.t0);
            h = h * 31 + Utilities.hash(this.t1);
            h = h * 31 + Utilities.hash(this.t2);
            h = h * 31 + Utilities.hash(this.t3);
            h = h * 31 + Utilities.hash(this.t4);
            h = h * 31 + Utilities.hash(this.t5);
            return h;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                if (this.t0 == null) {
                    return 0;
                }
                if (this.t1 == null) {
                    return 1;
                }
                if (this.t2 == null) {
                    return 2;
                }
                if (this.t3 == null) {
                    return 3;
                }
                if (this.t4 == null) {
                    return 4;
                }
                if (this.t5 == null) {
                    return 5;
                }
            } else {
                if (this.t0.equals(o)) {
                    return 0;
                }
                if (this.t1.equals(o)) {
                    return 1;
                }
                if (this.t2.equals(o)) {
                    return 2;
                }
                if (this.t3.equals(o)) {
                    return 3;
                }
                if (this.t4.equals(o)) {
                    return 4;
                }
                if (this.t5.equals(o)) {
                    return 5;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o == null) {
                if (this.t5 == null) {
                    return 5;
                }
                if (this.t4 == null) {
                    return 4;
                }
                if (this.t3 == null) {
                    return 3;
                }
                if (this.t2 == null) {
                    return 2;
                }
                if (this.t1 == null) {
                    return 1;
                }
                if (this.t0 == null) {
                    return 0;
                }
            } else {
                if (this.t5.equals(o)) {
                    return 5;
                }
                if (this.t4.equals(o)) {
                    return 4;
                }
                if (this.t3.equals(o)) {
                    return 3;
                }
                if (this.t2.equals(o)) {
                    return 2;
                }
                if (this.t1.equals(o)) {
                    return 1;
                }
                if (this.t0.equals(o)) {
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public <T2> T2[] toArray(T2[] a) {
            a[0] = this.t0;
            a[1] = this.t1;
            a[2] = this.t2;
            a[3] = this.t3;
            a[4] = this.t4;
            a[5] = this.t5;
            return a;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.t0, this.t1, this.t2, this.t3, this.t4, this.t5};
        }

        @Override
        public int compareTo(List o) {
            return ComparableListImpl.compare(this, o);
        }
    }

    protected static class Flat5List<T>
    extends AbstractFlatList<T>
    implements ComparableList<T> {
        private final T t0;
        private final T t1;
        private final T t2;
        private final T t3;
        private final T t4;

        Flat5List(T t0, T t1, T t2, T t3, T t4) {
            this.t0 = t0;
            this.t1 = t1;
            this.t2 = t2;
            this.t3 = t3;
            this.t4 = t4;
        }

        public String toString() {
            return "[" + this.t0 + ", " + this.t1 + ", " + this.t2 + "," + this.t3 + ", " + this.t4 + "]";
        }

        @Override
        public T get(int index) {
            switch (index) {
                case 0: {
                    return this.t0;
                }
                case 1: {
                    return this.t1;
                }
                case 2: {
                    return this.t2;
                }
                case 3: {
                    return this.t3;
                }
                case 4: {
                    return this.t4;
                }
            }
            throw new IndexOutOfBoundsException("index " + index);
        }

        @Override
        public int size() {
            return 5;
        }

        @Override
        public Iterator<T> iterator() {
            return Arrays.asList(this.t0, this.t1, this.t2, this.t3, this.t4).iterator();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Flat5List) {
                Flat5List that = (Flat5List)o;
                return Objects.equals(this.t0, that.t0) && Objects.equals(this.t1, that.t1) && Objects.equals(this.t2, that.t2) && Objects.equals(this.t3, that.t3) && Objects.equals(this.t4, that.t4);
            }
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            int h = 1;
            h = h * 31 + Utilities.hash(this.t0);
            h = h * 31 + Utilities.hash(this.t1);
            h = h * 31 + Utilities.hash(this.t2);
            h = h * 31 + Utilities.hash(this.t3);
            h = h * 31 + Utilities.hash(this.t4);
            return h;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                if (this.t0 == null) {
                    return 0;
                }
                if (this.t1 == null) {
                    return 1;
                }
                if (this.t2 == null) {
                    return 2;
                }
                if (this.t3 == null) {
                    return 3;
                }
                if (this.t4 == null) {
                    return 4;
                }
            } else {
                if (this.t0.equals(o)) {
                    return 0;
                }
                if (this.t1.equals(o)) {
                    return 1;
                }
                if (this.t2.equals(o)) {
                    return 2;
                }
                if (this.t3.equals(o)) {
                    return 3;
                }
                if (this.t4.equals(o)) {
                    return 4;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o == null) {
                if (this.t4 == null) {
                    return 4;
                }
                if (this.t3 == null) {
                    return 3;
                }
                if (this.t2 == null) {
                    return 2;
                }
                if (this.t1 == null) {
                    return 1;
                }
                if (this.t0 == null) {
                    return 0;
                }
            } else {
                if (this.t4.equals(o)) {
                    return 4;
                }
                if (this.t3.equals(o)) {
                    return 3;
                }
                if (this.t2.equals(o)) {
                    return 2;
                }
                if (this.t1.equals(o)) {
                    return 1;
                }
                if (this.t0.equals(o)) {
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public <T2> T2[] toArray(T2[] a) {
            a[0] = this.t0;
            a[1] = this.t1;
            a[2] = this.t2;
            a[3] = this.t3;
            a[4] = this.t4;
            return a;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.t0, this.t1, this.t2, this.t3, this.t4};
        }

        @Override
        public int compareTo(List o) {
            return ComparableListImpl.compare(this, o);
        }
    }

    protected static class Flat4List<T>
    extends AbstractFlatList<T>
    implements ComparableList<T> {
        private final T t0;
        private final T t1;
        private final T t2;
        private final T t3;

        Flat4List(T t0, T t1, T t2, T t3) {
            this.t0 = t0;
            this.t1 = t1;
            this.t2 = t2;
            this.t3 = t3;
        }

        public String toString() {
            return "[" + this.t0 + ", " + this.t1 + ", " + this.t2 + "," + this.t3 + "]";
        }

        @Override
        public T get(int index) {
            switch (index) {
                case 0: {
                    return this.t0;
                }
                case 1: {
                    return this.t1;
                }
                case 2: {
                    return this.t2;
                }
                case 3: {
                    return this.t3;
                }
            }
            throw new IndexOutOfBoundsException("index " + index);
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public Iterator<T> iterator() {
            return Arrays.asList(this.t0, this.t1, this.t2, this.t3).iterator();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Flat4List) {
                Flat4List that = (Flat4List)o;
                return Objects.equals(this.t0, that.t0) && Objects.equals(this.t1, that.t1) && Objects.equals(this.t2, that.t2) && Objects.equals(this.t3, that.t3);
            }
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            int h = 1;
            h = h * 31 + Utilities.hash(this.t0);
            h = h * 31 + Utilities.hash(this.t1);
            h = h * 31 + Utilities.hash(this.t2);
            h = h * 31 + Utilities.hash(this.t3);
            return h;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                if (this.t0 == null) {
                    return 0;
                }
                if (this.t1 == null) {
                    return 1;
                }
                if (this.t2 == null) {
                    return 2;
                }
                if (this.t3 == null) {
                    return 3;
                }
            } else {
                if (this.t0.equals(o)) {
                    return 0;
                }
                if (this.t1.equals(o)) {
                    return 1;
                }
                if (this.t2.equals(o)) {
                    return 2;
                }
                if (this.t3.equals(o)) {
                    return 3;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o == null) {
                if (this.t3 == null) {
                    return 3;
                }
                if (this.t2 == null) {
                    return 2;
                }
                if (this.t1 == null) {
                    return 1;
                }
                if (this.t0 == null) {
                    return 0;
                }
            } else {
                if (this.t3.equals(o)) {
                    return 3;
                }
                if (this.t2.equals(o)) {
                    return 2;
                }
                if (this.t1.equals(o)) {
                    return 1;
                }
                if (this.t0.equals(o)) {
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public <T2> T2[] toArray(T2[] a) {
            a[0] = this.t0;
            a[1] = this.t1;
            a[2] = this.t2;
            a[3] = this.t3;
            return a;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.t0, this.t1, this.t2, this.t3};
        }

        @Override
        public int compareTo(List o) {
            return ComparableListImpl.compare(this, o);
        }
    }

    protected static class Flat3List<T>
    extends AbstractFlatList<T>
    implements ComparableList<T> {
        private final T t0;
        private final T t1;
        private final T t2;

        Flat3List(T t0, T t1, T t2) {
            this.t0 = t0;
            this.t1 = t1;
            this.t2 = t2;
        }

        public String toString() {
            return "[" + this.t0 + ", " + this.t1 + ", " + this.t2 + "]";
        }

        @Override
        public T get(int index) {
            switch (index) {
                case 0: {
                    return this.t0;
                }
                case 1: {
                    return this.t1;
                }
                case 2: {
                    return this.t2;
                }
            }
            throw new IndexOutOfBoundsException("index " + index);
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public Iterator<T> iterator() {
            return Arrays.asList(this.t0, this.t1, this.t2).iterator();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Flat3List) {
                Flat3List that = (Flat3List)o;
                return Objects.equals(this.t0, that.t0) && Objects.equals(this.t1, that.t1) && Objects.equals(this.t2, that.t2);
            }
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            int h = 1;
            h = h * 31 + Utilities.hash(this.t0);
            h = h * 31 + Utilities.hash(this.t1);
            h = h * 31 + Utilities.hash(this.t2);
            return h;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                if (this.t0 == null) {
                    return 0;
                }
                if (this.t1 == null) {
                    return 1;
                }
                if (this.t2 == null) {
                    return 2;
                }
            } else {
                if (this.t0.equals(o)) {
                    return 0;
                }
                if (this.t1.equals(o)) {
                    return 1;
                }
                if (this.t2.equals(o)) {
                    return 2;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o == null) {
                if (this.t2 == null) {
                    return 2;
                }
                if (this.t1 == null) {
                    return 1;
                }
                if (this.t0 == null) {
                    return 0;
                }
            } else {
                if (this.t2.equals(o)) {
                    return 2;
                }
                if (this.t1.equals(o)) {
                    return 1;
                }
                if (this.t0.equals(o)) {
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public <T2> T2[] toArray(T2[] a) {
            a[0] = this.t0;
            a[1] = this.t1;
            a[2] = this.t2;
            return a;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.t0, this.t1, this.t2};
        }

        @Override
        public int compareTo(List o) {
            return ComparableListImpl.compare(this, o);
        }
    }

    protected static class Flat2List<T>
    extends AbstractFlatList<T>
    implements ComparableList<T> {
        private final T t0;
        private final T t1;

        Flat2List(T t0, T t1) {
            this.t0 = t0;
            this.t1 = t1;
        }

        public String toString() {
            return "[" + this.t0 + ", " + this.t1 + "]";
        }

        @Override
        public T get(int index) {
            switch (index) {
                case 0: {
                    return this.t0;
                }
                case 1: {
                    return this.t1;
                }
            }
            throw new IndexOutOfBoundsException("index " + index);
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Iterator<T> iterator() {
            return Arrays.asList(this.t0, this.t1).iterator();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Flat2List) {
                Flat2List that = (Flat2List)o;
                return Objects.equals(this.t0, that.t0) && Objects.equals(this.t1, that.t1);
            }
            return Arrays.asList(this.t0, this.t1).equals(o);
        }

        @Override
        public int hashCode() {
            int h = 1;
            h = h * 31 + Utilities.hash(this.t0);
            h = h * 31 + Utilities.hash(this.t1);
            return h;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                if (this.t0 == null) {
                    return 0;
                }
                if (this.t1 == null) {
                    return 1;
                }
            } else {
                if (this.t0.equals(o)) {
                    return 0;
                }
                if (this.t1.equals(o)) {
                    return 1;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o == null) {
                if (this.t1 == null) {
                    return 1;
                }
                if (this.t0 == null) {
                    return 0;
                }
            } else {
                if (this.t1.equals(o)) {
                    return 1;
                }
                if (this.t0.equals(o)) {
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public <T2> T2[] toArray(T2[] a) {
            a[0] = this.t0;
            a[1] = this.t1;
            return a;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.t0, this.t1};
        }

        @Override
        public int compareTo(List o) {
            return ComparableListImpl.compare(this, o);
        }
    }

    protected static class Flat1List<T>
    extends AbstractFlatList<T>
    implements ComparableList<T> {
        private final T t0;

        Flat1List(T t0) {
            this.t0 = t0;
        }

        public String toString() {
            return "[" + this.t0 + "]";
        }

        @Override
        public T get(int index) {
            switch (index) {
                case 0: {
                    return this.t0;
                }
            }
            throw new IndexOutOfBoundsException("index " + index);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.singletonList(this.t0).iterator();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Flat1List) {
                Flat1List that = (Flat1List)o;
                return Objects.equals(this.t0, that.t0);
            }
            return Collections.singletonList(this.t0).equals(o);
        }

        @Override
        public int hashCode() {
            int h = 1;
            h = h * 31 + Utilities.hash(this.t0);
            return h;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null ? this.t0 == null : this.t0.equals(o)) {
                return 0;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o == null ? this.t0 == null : this.t0.equals(o)) {
                return 0;
            }
            return -1;
        }

        @Override
        public <T2> T2[] toArray(T2[] a) {
            a[0] = this.t0;
            return a;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.t0};
        }

        @Override
        public int compareTo(List o) {
            return ComparableListImpl.compare(this, o);
        }
    }

    public static abstract class AbstractFlatList<T>
    implements List<T>,
    RandomAccess {
        protected final List<T> asArrayList() {
            return Arrays.asList(this.toArray());
        }

        @Override
        public Iterator<T> iterator() {
            return this.asArrayList().iterator();
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.asArrayList().listIterator();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean add(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T set(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return this.asArrayList().listIterator(index);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return this.asArrayList().subList(fromIndex, toIndex);
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

