/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.function.Deterministic;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.NonDeterministic;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.runtime.Like;

@Deterministic
public class SqlFunctions {
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("0.0E0");
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    private static final Function1<List<Object>, Enumerable<Object>> LIST_AS_ENUMERABLE = new Function1<List<Object>, Enumerable<Object>>(){

        @Override
        public Enumerable<Object> apply(List<Object> list) {
            return Linq4j.asEnumerable(list);
        }
    };
    private static final ThreadLocal<Map<String, AtomicLong>> THREAD_SEQUENCES = new ThreadLocal<Map<String, AtomicLong>>(){

        @Override
        protected Map<String, AtomicLong> initialValue() {
            return new HashMap<String, AtomicLong>();
        }
    };

    private SqlFunctions() {
    }

    public static String substring(String s, int from, int for_) {
        return s.substring(from - 1, Math.min(from - 1 + for_, s.length()));
    }

    public static String substring(String s, int from) {
        return s.substring(from - 1);
    }

    public static String upper(String s) {
        return s.toUpperCase();
    }

    public static String lower(String s) {
        return s.toLowerCase();
    }

    public static String initcap(String s) {
        int len = s.length();
        boolean start = true;
        StringBuilder newS = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char curCh;
            char c = curCh = s.charAt(i);
            if (start) {
                if (c > '/' && c < ':') {
                    start = false;
                } else if (c > '@' && c < '[') {
                    start = false;
                } else if (c > '`' && c < '{') {
                    start = false;
                    curCh = (char)(c - 32);
                }
            } else if (c <= '/' || c >= ':') {
                if (c > '@' && c < '[') {
                    curCh = (char)(c + 32);
                } else if (c <= '`' || c >= '{') {
                    start = true;
                }
            }
            newS.append(curCh);
        }
        return newS.toString();
    }

    public static int charLength(String s) {
        return s.length();
    }

    public static String concat(String s0, String s1) {
        return s0 + s1;
    }

    public static ByteString concat(ByteString s0, ByteString s1) {
        return s0.concat(s1);
    }

    public static String rtrim(String s) {
        return SqlFunctions.trim_(s, false, true, ' ');
    }

    public static String ltrim(String s) {
        return SqlFunctions.trim_(s, true, false, ' ');
    }

    public static String trim(boolean leading, boolean trailing, String seek, String s) {
        return SqlFunctions.trim_(s, leading, trailing, seek.charAt(0));
    }

    private static String trim_(String s, boolean left, boolean right, char c) {
        int j2 = s.length();
        if (right) {
            while (true) {
                if (j2 == 0) {
                    return "";
                }
                if (s.charAt(j2 - 1) != c) break;
                --j2;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j2) {
                    return "";
                }
                if (s.charAt(i) != c) break;
                ++i;
            }
        }
        return s.substring(i, j2);
    }

    public static ByteString trim(ByteString s) {
        return SqlFunctions.trim_(s, true, true);
    }

    public static ByteString rtrim(ByteString s) {
        return SqlFunctions.trim_(s, false, true);
    }

    private static ByteString trim_(ByteString s, boolean left, boolean right) {
        int j2 = s.length();
        if (right) {
            while (true) {
                if (j2 == 0) {
                    return ByteString.EMPTY;
                }
                if (s.byteAt(j2 - 1) != 0) break;
                --j2;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j2) {
                    return ByteString.EMPTY;
                }
                if (s.byteAt(i) != 0) break;
                ++i;
            }
        }
        return s.substring(i, j2);
    }

    public static String overlay(String s, String r, int start) {
        if (s == null || r == null) {
            return null;
        }
        return s.substring(0, start - 1) + r + s.substring(start - 1 + r.length());
    }

    public static String overlay(String s, String r, int start, int length) {
        if (s == null || r == null) {
            return null;
        }
        return s.substring(0, start - 1) + r + s.substring(start - 1 + length);
    }

    public static ByteString overlay(ByteString s, ByteString r, int start) {
        if (s == null || r == null) {
            return null;
        }
        return s.substring(0, start - 1).concat(r).concat(s.substring(start - 1 + r.length()));
    }

    public static ByteString overlay(ByteString s, ByteString r, int start, int length) {
        if (s == null || r == null) {
            return null;
        }
        return s.substring(0, start - 1).concat(r).concat(s.substring(start - 1 + length));
    }

    public static boolean like(String s, String pattern) {
        String regex = Like.sqlToRegexLike(pattern, null);
        return Pattern.matches(regex, s);
    }

    public static boolean like(String s, String pattern, String escape) {
        String regex = Like.sqlToRegexLike(pattern, escape);
        return Pattern.matches(regex, s);
    }

    public static boolean similar(String s, String pattern) {
        String regex = Like.sqlToRegexSimilar(pattern, null);
        return Pattern.matches(regex, s);
    }

    public static boolean similar(String s, String pattern, String escape) {
        String regex = Like.sqlToRegexSimilar(pattern, escape);
        return Pattern.matches(regex, s);
    }

    public static boolean eq(Object b0, Object b1) {
        return b0.equals(b1);
    }

    public static boolean eq(BigDecimal b0, BigDecimal b1) {
        return b0.stripTrailingZeros().equals(b1.stripTrailingZeros());
    }

    public static boolean ne(Object b0, Object b1) {
        return !b0.equals(b1);
    }

    public static boolean ne(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) != 0;
    }

    public static boolean lt(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) < 0;
    }

    public static boolean lt(String b0, String b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean le(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) <= 0;
    }

    public static boolean le(String b0, String b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean gt(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) > 0;
    }

    public static boolean gt(String b0, String b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean ge(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) >= 0;
    }

    public static boolean ge(String b0, String b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static int plus(int b0, int b1) {
        return b0 + b1;
    }

    public static Integer plus(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 + b1);
    }

    public static Integer plus(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 + b1);
    }

    public static Integer plus(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 + b1);
    }

    public static Long plus(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 + b1.longValue());
    }

    public static Long plus(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() + b1);
    }

    public static BigDecimal plus(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.add(b1);
    }

    public static int minus(int b0, int b1) {
        return b0 - b1;
    }

    public static Integer minus(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 - b1);
    }

    public static Integer minus(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 - b1);
    }

    public static Integer minus(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 - b1);
    }

    public static Long minus(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 - b1.longValue());
    }

    public static Long minus(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() - b1);
    }

    public static BigDecimal minus(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.subtract(b1);
    }

    public static int divide(int b0, int b1) {
        return b0 / b1;
    }

    public static Integer divide(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 / b1);
    }

    public static Integer divide(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 / b1);
    }

    public static Integer divide(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 / b1);
    }

    public static Long divide(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 / b1.longValue());
    }

    public static Long divide(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() / b1);
    }

    public static BigDecimal divide(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.divide(b1, MathContext.DECIMAL64);
    }

    public static int multiply(int b0, int b1) {
        return b0 * b1;
    }

    public static Integer multiply(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 * b1);
    }

    public static Integer multiply(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 * b1);
    }

    public static Integer multiply(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 * b1);
    }

    public static Long multiply(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 * b1.longValue());
    }

    public static Long multiply(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() * b1);
    }

    public static BigDecimal multiply(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.multiply(b1);
    }

    public static double exp(double b0) {
        return Math.exp(b0);
    }

    public static double exp(long b0) {
        return Math.exp(b0);
    }

    public static double power(double b0, double b1) {
        return Math.pow(b0, b1);
    }

    public static double power(long b0, long b1) {
        return Math.pow(b0, b1);
    }

    public static double power(long b0, BigDecimal b1) {
        return Math.pow(b0, b1.doubleValue());
    }

    public static double ln(double d) {
        return Math.log(d);
    }

    public static double ln(long b0) {
        return Math.log(b0);
    }

    public static double ln(BigDecimal d) {
        return Math.log(d.doubleValue());
    }

    public static double log10(double b0) {
        return Math.log10(b0);
    }

    public static double log10(long b0) {
        return Math.log10(b0);
    }

    public static double log10(BigDecimal d) {
        return Math.log10(d.doubleValue());
    }

    public static byte mod(byte b0, byte b1) {
        return (byte)(b0 % b1);
    }

    public static short mod(short b0, short b1) {
        return (short)(b0 % b1);
    }

    public static int mod(int b0, int b1) {
        return b0 % b1;
    }

    public static long mod(long b0, long b1) {
        return b0 % b1;
    }

    public static BigDecimal mod(BigDecimal b0, int b1) {
        return SqlFunctions.mod(b0, BigDecimal.valueOf(b1));
    }

    public static int mod(int b0, BigDecimal b1) {
        return SqlFunctions.mod(b0, b1.intValue());
    }

    public static BigDecimal mod(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        return bigDecimals[1];
    }

    public static double floor(double b0) {
        return Math.floor(b0);
    }

    public static float floor(float b0) {
        return (float)Math.floor(b0);
    }

    public static BigDecimal floor(BigDecimal b0) {
        return b0.setScale(0, 3);
    }

    public static byte floor(byte b0, byte b1) {
        return (byte)SqlFunctions.floor((int)b0, (int)b1);
    }

    public static short floor(short b0, short b1) {
        return (short)SqlFunctions.floor((int)b0, (int)b1);
    }

    public static int floor(int b0, int b1) {
        int r = b0 % b1;
        if (r < 0) {
            r += b1;
        }
        return b0 - r;
    }

    public static long floor(long b0, long b1) {
        long r = b0 % b1;
        if (r < 0L) {
            r += b1;
        }
        return b0 - r;
    }

    public static BigDecimal floor(BigDecimal b0, int b1) {
        return SqlFunctions.floor(b0, BigDecimal.valueOf(b1));
    }

    public static int floor(int b0, BigDecimal b1) {
        return SqlFunctions.floor(b0, b1.intValue());
    }

    public static BigDecimal floor(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        BigDecimal r = bigDecimals[1];
        if (r.signum() < 0) {
            r = r.add(b1);
        }
        return b0.subtract(r);
    }

    public static double ceil(double b0) {
        return Math.ceil(b0);
    }

    public static float ceil(float b0) {
        return (float)Math.ceil(b0);
    }

    public static BigDecimal ceil(BigDecimal b0) {
        return b0.setScale(0, 2);
    }

    public static byte ceil(byte b0, byte b1) {
        return SqlFunctions.floor((byte)(b0 + b1 - 1), b1);
    }

    public static short ceil(short b0, short b1) {
        return SqlFunctions.floor((short)(b0 + b1 - 1), b1);
    }

    public static int ceil(int b0, int b1) {
        int r = b0 % b1;
        if (r > 0) {
            r -= b1;
        }
        return b0 - r;
    }

    public static long ceil(long b0, long b1) {
        return SqlFunctions.floor(b0 + b1 - 1L, b1);
    }

    public static BigDecimal ceil(BigDecimal b0, int b1) {
        return SqlFunctions.ceil(b0, BigDecimal.valueOf(b1));
    }

    public static int ceil(int b0, BigDecimal b1) {
        return SqlFunctions.ceil(b0, b1.intValue());
    }

    public static BigDecimal ceil(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        BigDecimal r = bigDecimals[1];
        if (r.signum() > 0) {
            r = r.subtract(b1);
        }
        return b0.subtract(r);
    }

    public static byte abs(byte b0) {
        return (byte)Math.abs(b0);
    }

    public static short abs(short b0) {
        return (short)Math.abs(b0);
    }

    public static int abs(int b0) {
        return Math.abs(b0);
    }

    public static long abs(long b0) {
        return Math.abs(b0);
    }

    public static float abs(float b0) {
        return Math.abs(b0);
    }

    public static double abs(double b0) {
        return Math.abs(b0);
    }

    public static BigDecimal abs(BigDecimal b0) {
        return b0.abs();
    }

    public static <T extends Comparable<T>> T lesser(T b0, T b1) {
        return b0 == null || b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T least(T b0, T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static boolean greater(boolean b0, boolean b1) {
        return b0 || b1;
    }

    public static boolean lesser(boolean b0, boolean b1) {
        return b0 && b1;
    }

    public static byte greater(byte b0, byte b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static byte lesser(byte b0, byte b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static char greater(char b0, char b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static char lesser(char b0, char b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static short greater(short b0, short b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static short lesser(short b0, short b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static int greater(int b0, int b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static int lesser(int b0, int b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static long greater(long b0, long b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static long lesser(long b0, long b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static float greater(float b0, float b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static float lesser(float b0, float b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static double greater(double b0, double b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static double lesser(double b0, double b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T greater(T b0, T b1) {
        return b0 == null || b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T greatest(T b0, T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static int compare(boolean x, boolean y) {
        return x == y ? 0 : (x ? 1 : -1);
    }

    public static String toString(float x) {
        if (x == 0.0f) {
            return "0E0";
        }
        BigDecimal bigDecimal = new BigDecimal(x, MathContext.DECIMAL32).stripTrailingZeros();
        String s = bigDecimal.toString();
        return s.replaceAll("0*E", "E").replace("E+", "E");
    }

    public static String toString(double x) {
        if (x == 0.0) {
            return "0E0";
        }
        BigDecimal bigDecimal = new BigDecimal(x, MathContext.DECIMAL64).stripTrailingZeros();
        String s = bigDecimal.toString();
        return s.replaceAll("0*E", "E").replace("E+", "E");
    }

    public static String toString(BigDecimal x) {
        String s = x.toString();
        if (s.startsWith("0")) {
            return s.substring(1);
        }
        if (s.startsWith("-0")) {
            return "-" + s.substring(2);
        }
        return s;
    }

    public static String toString(boolean x) {
        return x ? "TRUE" : "FALSE";
    }

    @NonDeterministic
    private static Object cannotConvert(Object o, Class toType) {
        throw new RuntimeException("Cannot convert " + o + " to " + toType);
    }

    public static boolean toBoolean(String s) {
        if ((s = SqlFunctions.trim_(s, true, true, ' ')).equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (s.equalsIgnoreCase("FALSE")) {
            return false;
        }
        throw new RuntimeException("Invalid character for cast");
    }

    public static boolean toBoolean(Number number) {
        return !number.equals(0);
    }

    public static boolean toBoolean(Object o) {
        return o instanceof Boolean ? (Boolean)o : (o instanceof Number ? SqlFunctions.toBoolean((Number)o) : (o instanceof String ? SqlFunctions.toBoolean((String)o) : (Boolean)SqlFunctions.cannotConvert(o, Boolean.TYPE)));
    }

    public static byte toByte(Object o) {
        return o instanceof Byte ? (Byte)o : (o instanceof Number ? SqlFunctions.toByte((Number)o) : Byte.parseByte(o.toString()));
    }

    public static byte toByte(Number number) {
        return number.byteValue();
    }

    public static char toChar(String s) {
        return s.charAt(0);
    }

    public static Character toCharBoxed(String s) {
        return Character.valueOf(s.charAt(0));
    }

    public static short toShort(String s) {
        return Short.parseShort(s.trim());
    }

    public static short toShort(Number number) {
        return number.shortValue();
    }

    public static short toShort(Object o) {
        return o instanceof Short ? (Short)o : (o instanceof Number ? SqlFunctions.toShort((Number)o) : (o instanceof String ? SqlFunctions.toShort((String)o) : (Short)SqlFunctions.cannotConvert(o, Short.TYPE)));
    }

    public static int toInt(java.util.Date v) {
        return SqlFunctions.toInt(v, LOCAL_TZ);
    }

    public static int toInt(java.util.Date v, TimeZone timeZone) {
        return (int)(SqlFunctions.toLong(v, timeZone) / 86400000L);
    }

    public static Integer toIntOptional(java.util.Date v) {
        return v == null ? null : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static Integer toIntOptional(java.util.Date v, TimeZone timeZone) {
        return v == null ? null : Integer.valueOf(SqlFunctions.toInt(v, timeZone));
    }

    public static long toLong(java.util.Date v) {
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static int toInt(Time v) {
        return (int)(SqlFunctions.toLong(v) % 86400000L);
    }

    public static Integer toIntOptional(Time v) {
        return v == null ? null : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static int toInt(String s) {
        return Integer.parseInt(s.trim());
    }

    public static int toInt(Number number) {
        return number.intValue();
    }

    public static int toInt(Object o) {
        return o instanceof Integer ? (Integer)o : (o instanceof Number ? SqlFunctions.toInt((Number)o) : (o instanceof String ? SqlFunctions.toInt((String)o) : (Integer)SqlFunctions.cannotConvert(o, Integer.TYPE)));
    }

    public static long toLong(Timestamp v) {
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static long toLong(java.util.Date v, TimeZone timeZone) {
        long time = v.getTime();
        return time + (long)timeZone.getOffset(time);
    }

    public static Long toLongOptional(java.util.Date v) {
        return v == null ? null : Long.valueOf(SqlFunctions.toLong(v, LOCAL_TZ));
    }

    public static Long toLongOptional(Timestamp v, TimeZone timeZone) {
        if (v == null) {
            return null;
        }
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static long toLong(String s) {
        if (s.startsWith("199") && s.contains(":")) {
            return Timestamp.valueOf(s).getTime();
        }
        return Long.parseLong(s.trim());
    }

    public static long toLong(Number number) {
        return number.longValue();
    }

    public static long toLong(Object o) {
        return o instanceof Long ? (Long)o : (o instanceof Number ? SqlFunctions.toLong((Number)o) : (o instanceof String ? SqlFunctions.toLong((String)o) : (Long)SqlFunctions.cannotConvert(o, Long.TYPE)));
    }

    public static float toFloat(String s) {
        return Float.parseFloat(s.trim());
    }

    public static float toFloat(Number number) {
        return number.floatValue();
    }

    public static float toFloat(Object o) {
        return o instanceof Float ? ((Float)o).floatValue() : (o instanceof Number ? SqlFunctions.toFloat((Number)o) : (o instanceof String ? SqlFunctions.toFloat((String)o) : ((Float)SqlFunctions.cannotConvert(o, Float.TYPE)).floatValue()));
    }

    public static double toDouble(String s) {
        return Double.parseDouble(s.trim());
    }

    public static double toDouble(Number number) {
        return number.doubleValue();
    }

    public static double toDouble(Object o) {
        return o instanceof Double ? (Double)o : (o instanceof Number ? SqlFunctions.toDouble((Number)o) : (o instanceof String ? SqlFunctions.toDouble((String)o) : (Double)SqlFunctions.cannotConvert(o, Double.TYPE)));
    }

    public static BigDecimal toBigDecimal(String s) {
        return new BigDecimal(s.trim());
    }

    public static BigDecimal toBigDecimal(Number number) {
        return number instanceof BigDecimal ? (BigDecimal)number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : (number instanceof Long ? new BigDecimal(number.longValue()) : new BigDecimal(number.doubleValue())));
    }

    public static BigDecimal toBigDecimal(Object o) {
        return o instanceof Number ? SqlFunctions.toBigDecimal((Number)o) : SqlFunctions.toBigDecimal(o.toString());
    }

    public static Date internalToDate(int v) {
        long t = (long)v * 86400000L;
        return new Date(t - (long)LOCAL_TZ.getOffset(t));
    }

    public static Date internalToDate(Integer v) {
        return v == null ? null : SqlFunctions.internalToDate((int)v);
    }

    public static Time internalToTime(int v) {
        return new Time(v - LOCAL_TZ.getOffset(v));
    }

    public static Time internalToTime(Integer v) {
        return v == null ? null : SqlFunctions.internalToTime((int)v);
    }

    public static Timestamp internalToTimestamp(long v) {
        return new Timestamp(v - (long)LOCAL_TZ.getOffset(v));
    }

    public static Timestamp internalToTimestamp(Long v) {
        return v == null ? null : SqlFunctions.internalToTimestamp((long)v);
    }

    public static String truncate(String s, int maxLength) {
        return s == null ? null : (s.length() > maxLength ? s.substring(0, maxLength) : s);
    }

    public static ByteString truncate(ByteString s, int maxLength) {
        return s == null ? null : (s.length() > maxLength ? s.substring(0, maxLength) : s);
    }

    public static int position(String seek, String s) {
        return s.indexOf(seek) + 1;
    }

    public static int position(ByteString seek, ByteString s) {
        return s.indexOf(seek) + 1;
    }

    public static long round(long v, long x) {
        return SqlFunctions.truncate(v + x / 2L, x);
    }

    public static long truncate(long v, long x) {
        long remainder = v % x;
        if (remainder < 0L) {
            remainder += x;
        }
        return v - remainder;
    }

    public static int round(int v, int x) {
        return SqlFunctions.truncate(v + x / 2, x);
    }

    public static int truncate(int v, int x) {
        int remainder = v % x;
        if (remainder < 0) {
            remainder += x;
        }
        return v - remainder;
    }

    @NonDeterministic
    public static long currentTimestamp(DataContext root) {
        return (Long)DataContext.Variable.CURRENT_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int currentTime(DataContext root) {
        int time = (int)(SqlFunctions.currentTimestamp(root) % 86400000L);
        if (time < 0) {
            time = (int)((long)time + 86400000L);
        }
        return time;
    }

    @NonDeterministic
    public static int currentDate(DataContext root) {
        long timestamp = SqlFunctions.currentTimestamp(root);
        int date = (int)(timestamp / 86400000L);
        int time = (int)(timestamp % 86400000L);
        if (time < 0) {
            --date;
        }
        return date;
    }

    @NonDeterministic
    public static long localTimestamp(DataContext root) {
        return (Long)DataContext.Variable.LOCAL_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int localTime(DataContext root) {
        return (int)(SqlFunctions.localTimestamp(root) % 86400000L);
    }

    public static Object arrayItem(List list, int item) {
        if (item < 1 || item > list.size()) {
            return null;
        }
        return list.get(item - 1);
    }

    public static Object mapItem(Map map2, Object item) {
        return map2.get(item);
    }

    public static Object item(Object object, Object index) {
        if (object instanceof Map) {
            return ((Map)object).get(index);
        }
        if (object instanceof List && index instanceof Number) {
            List list = (List)object;
            return list.get(((Number)index).intValue());
        }
        return null;
    }

    public static boolean isTrue(Boolean b) {
        return b != null && b != false;
    }

    public static boolean isFalse(Boolean b) {
        return b != null && b == false;
    }

    public static boolean isNotTrue(Boolean b) {
        return b == null || b == false;
    }

    public static boolean isNotFalse(Boolean b) {
        return b == null || b != false;
    }

    public static Boolean not(Boolean b) {
        return b == null ? null : Boolean.valueOf(b == false);
    }

    public static List arrayToList(Array a) {
        if (a == null) {
            return null;
        }
        try {
            return Primitive.asList(a.getArray());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @NonDeterministic
    public static long sequenceCurrentValue(String key) {
        return SqlFunctions.getAtomicLong(key).get();
    }

    @NonDeterministic
    public static long sequenceNextValue(String key) {
        return SqlFunctions.getAtomicLong(key).incrementAndGet();
    }

    private static AtomicLong getAtomicLong(String key) {
        Map<String, AtomicLong> map2 = THREAD_SEQUENCES.get();
        AtomicLong atomic = map2.get(key);
        if (atomic == null) {
            atomic = new AtomicLong();
            map2.put(key, atomic);
        }
        return atomic;
    }

    public static List slice(List list) {
        return list;
    }

    public static Object element(List list) {
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw new RuntimeException("more than one value");
    }

    public static <E> Function1<List<E>, Enumerable<E>> listToEnumerable() {
        return LIST_AS_ENUMERABLE;
    }

    public static Object[] array(Object ... args) {
        return args;
    }
}

