/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.flink.shaded.calcite.com.google.common.base.Preconditions;

public class SqlDialect {
    public static final SqlDialect DUMMY = DatabaseProduct.UNKNOWN.getDialect();
    public static final SqlDialect CALCITE = DatabaseProduct.CALCITE.getDialect();
    private final String identifierQuoteString;
    private final String identifierEndQuoteString;
    private final String identifierEscapedQuote;
    private final DatabaseProduct databaseProduct;
    private final NullCollation nullCollation;
    private static final char[] HEXITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static SqlDialect create(DatabaseMetaData databaseMetaData) {
        NullCollation nullCollation;
        DatabaseProduct databaseProduct;
        String databaseProductName;
        String identifierQuoteString;
        block12: {
            String databaseProductVersion;
            try {
                identifierQuoteString = databaseMetaData.getIdentifierQuoteString();
            }
            catch (SQLException e) {
                throw FakeUtil.newInternal(e, "while quoting identifier");
            }
            try {
                databaseProductName = databaseMetaData.getDatabaseProductName();
            }
            catch (SQLException e) {
                throw FakeUtil.newInternal(e, "while detecting database product");
            }
            try {
                databaseProductVersion = databaseMetaData.getDatabaseProductVersion();
            }
            catch (SQLException e) {
                throw FakeUtil.newInternal(e, "while detecting database version");
            }
            databaseProduct = SqlDialect.getProduct(databaseProductName, databaseProductVersion);
            try {
                if (databaseMetaData.nullsAreSortedAtEnd()) {
                    nullCollation = NullCollation.LAST;
                    break block12;
                }
                if (databaseMetaData.nullsAreSortedAtStart()) {
                    nullCollation = NullCollation.FIRST;
                    break block12;
                }
                if (databaseMetaData.nullsAreSortedLow()) {
                    nullCollation = NullCollation.LOW;
                    break block12;
                }
                if (databaseMetaData.nullsAreSortedHigh()) {
                    nullCollation = NullCollation.HIGH;
                    break block12;
                }
                throw new IllegalArgumentException("cannot deduce null collation");
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("cannot deduce null collation", e);
            }
        }
        return new SqlDialect(databaseProduct, databaseProductName, identifierQuoteString, nullCollation);
    }

    @Deprecated
    public SqlDialect(DatabaseProduct databaseProduct, String databaseProductName, String identifierQuoteString) {
        this(databaseProduct, databaseProductName, identifierQuoteString, NullCollation.HIGH);
    }

    public SqlDialect(DatabaseProduct databaseProduct, String databaseProductName, String identifierQuoteString, NullCollation nullCollation) {
        this.nullCollation = nullCollation;
        Preconditions.checkNotNull(this.nullCollation);
        Preconditions.checkNotNull(databaseProductName);
        this.databaseProduct = Preconditions.checkNotNull(databaseProduct);
        if (identifierQuoteString != null && (identifierQuoteString = identifierQuoteString.trim()).equals("")) {
            identifierQuoteString = null;
        }
        this.identifierQuoteString = identifierQuoteString;
        this.identifierEndQuoteString = identifierQuoteString == null ? null : (identifierQuoteString.equals("[") ? "]" : identifierQuoteString);
        this.identifierEscapedQuote = identifierQuoteString == null ? null : this.identifierEndQuoteString + this.identifierEndQuoteString;
    }

    public static DatabaseProduct getProduct(String productName, String productVersion) {
        String upperProductName;
        switch (upperProductName = productName.toUpperCase().trim()) {
            case "ACCESS": {
                return DatabaseProduct.ACCESS;
            }
            case "APACHE DERBY": {
                return DatabaseProduct.DERBY;
            }
            case "DBMS:CLOUDSCAPE": {
                return DatabaseProduct.DERBY;
            }
            case "HIVE": {
                return DatabaseProduct.HIVE;
            }
            case "INGRES": {
                return DatabaseProduct.INGRES;
            }
            case "INTERBASE": {
                return DatabaseProduct.INTERBASE;
            }
            case "LUCIDDB": {
                return DatabaseProduct.LUCIDDB;
            }
            case "ORACLE": {
                return DatabaseProduct.ORACLE;
            }
            case "PHOENIX": {
                return DatabaseProduct.PHOENIX;
            }
            case "MYSQL (INFOBRIGHT)": {
                return DatabaseProduct.INFOBRIGHT;
            }
            case "MYSQL": {
                return DatabaseProduct.MYSQL;
            }
            case "REDSHIFT": {
                return DatabaseProduct.REDSHIFT;
            }
        }
        if (productName.startsWith("DB2")) {
            return DatabaseProduct.DB2;
        }
        if (upperProductName.contains("FIREBIRD")) {
            return DatabaseProduct.FIREBIRD;
        }
        if (productName.startsWith("Informix")) {
            return DatabaseProduct.INFORMIX;
        }
        if (upperProductName.contains("NETEZZA")) {
            return DatabaseProduct.NETEZZA;
        }
        if (upperProductName.contains("PARACCEL")) {
            return DatabaseProduct.PARACCEL;
        }
        if (productName.startsWith("HP Neoview")) {
            return DatabaseProduct.NEOVIEW;
        }
        if (upperProductName.contains("POSTGRE")) {
            return DatabaseProduct.POSTGRESQL;
        }
        if (upperProductName.contains("SQL SERVER")) {
            return DatabaseProduct.MSSQL;
        }
        if (upperProductName.contains("SYBASE")) {
            return DatabaseProduct.SYBASE;
        }
        if (upperProductName.contains("TERADATA")) {
            return DatabaseProduct.TERADATA;
        }
        if (upperProductName.contains("HSQL")) {
            return DatabaseProduct.HSQLDB;
        }
        if (upperProductName.contains("H2")) {
            return DatabaseProduct.H2;
        }
        if (upperProductName.contains("VERTICA")) {
            return DatabaseProduct.VERTICA;
        }
        return DatabaseProduct.UNKNOWN;
    }

    public String quoteIdentifier(String val) {
        if (this.identifierQuoteString == null) {
            return val;
        }
        String val2 = val.replaceAll(this.identifierEndQuoteString, this.identifierEscapedQuote);
        return this.identifierQuoteString + val2 + this.identifierEndQuoteString;
    }

    public StringBuilder quoteIdentifier(StringBuilder buf, String val) {
        if (this.identifierQuoteString == null) {
            buf.append(val);
            return buf;
        }
        String val2 = val.replaceAll(this.identifierEndQuoteString, this.identifierEscapedQuote);
        buf.append(this.identifierQuoteString);
        buf.append(val2);
        buf.append(this.identifierEndQuoteString);
        return buf;
    }

    public StringBuilder quoteIdentifier(StringBuilder buf, List<String> identifiers) {
        int i = 0;
        for (String identifier : identifiers) {
            if (i++ > 0) {
                buf.append('.');
            }
            this.quoteIdentifier(buf, identifier);
        }
        return buf;
    }

    public boolean identifierNeedsToBeQuoted(String val) {
        return !Pattern.compile("^[A-Z_$0-9]+").matcher(val).matches();
    }

    public String quoteStringLiteral(String val) {
        if (SqlDialect.containsNonAscii(val)) {
            StringBuilder buf = new StringBuilder();
            this.quoteStringLiteralUnicode(buf, val);
            return buf.toString();
        }
        val = FakeUtil.replace(val, "'", "''");
        return "'" + val + "'";
    }

    private static boolean containsNonAscii(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c < '\u0080') continue;
            return true;
        }
        return false;
    }

    public void quoteStringLiteralUnicode(StringBuilder buf, String val) {
        buf.append("u&'");
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c < ' ' || c >= '\u0080') {
                buf.append('\\');
                buf.append(HEXITS[c >> 12 & 0xF]);
                buf.append(HEXITS[c >> 8 & 0xF]);
                buf.append(HEXITS[c >> 4 & 0xF]);
                buf.append(HEXITS[c & 0xF]);
                continue;
            }
            if (c == '\'' || c == '\\') {
                buf.append(c);
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        buf.append("'");
    }

    public String unquoteStringLiteral(String val) {
        if (val != null && val.charAt(0) == '\'' && val.charAt(val.length() - 1) == '\'') {
            if (val.length() > 2) {
                val = FakeUtil.replace(val, "''", "'");
                return val.substring(1, val.length() - 1);
            }
            return "";
        }
        return val;
    }

    protected boolean allowsAs() {
        switch (this.databaseProduct) {
            case ORACLE: 
            case HIVE: {
                return false;
            }
        }
        return true;
    }

    protected boolean requiresAliasForFromItems() {
        return this.getDatabaseProduct() == DatabaseProduct.POSTGRESQL;
    }

    public String quoteTimestampLiteral(Timestamp timestamp) {
        SimpleDateFormat format = new SimpleDateFormat("'TIMESTAMP' ''yyyy-MM-DD HH:mm:SS''");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(timestamp);
    }

    public DatabaseProduct getDatabaseProduct() {
        return this.databaseProduct;
    }

    public boolean supportsCharSet() {
        switch (this.databaseProduct) {
            case ORACLE: 
            case MYSQL: 
            case H2: 
            case HSQLDB: 
            case PHOENIX: 
            case POSTGRESQL: {
                return false;
            }
        }
        return true;
    }

    public boolean supportsOffsetFetch() {
        switch (this.databaseProduct) {
            case HIVE: 
            case MYSQL: 
            case REDSHIFT: {
                return false;
            }
        }
        return true;
    }

    public NullCollation getNullCollation() {
        return this.nullCollation;
    }

    public RelFieldCollation.NullDirection defaultNullDirection(RelFieldCollation.Direction direction) {
        switch (direction) {
            case ASCENDING: 
            case STRICTLY_ASCENDING: {
                return this.getNullCollation().last(false) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
            }
            case DESCENDING: 
            case STRICTLY_DESCENDING: {
                return this.getNullCollation().last(true) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
            }
        }
        return RelFieldCollation.NullDirection.UNSPECIFIED;
    }

    public static enum DatabaseProduct {
        ACCESS("Access", "\"", NullCollation.HIGH),
        CALCITE("Apache Calcite", "\"", NullCollation.HIGH),
        MSSQL("Microsoft SQL Server", "[", NullCollation.HIGH),
        MYSQL("MySQL", "`", NullCollation.HIGH),
        ORACLE("Oracle", "\"", NullCollation.HIGH),
        DERBY("Apache Derby", null, NullCollation.HIGH),
        DB2("IBM DB2", null, NullCollation.HIGH),
        FIREBIRD("Firebird", null, NullCollation.HIGH),
        H2("H2", "\"", NullCollation.HIGH),
        HIVE("Apache Hive", null, NullCollation.HIGH),
        INFORMIX("Informix", null, NullCollation.HIGH),
        INGRES("Ingres", null, NullCollation.HIGH),
        LUCIDDB("LucidDB", "\"", NullCollation.HIGH),
        INTERBASE("Interbase", null, NullCollation.HIGH),
        PHOENIX("Phoenix", "\"", NullCollation.HIGH),
        POSTGRESQL("PostgreSQL", "\"", NullCollation.HIGH),
        NETEZZA("Netezza", "\"", NullCollation.HIGH),
        INFOBRIGHT("Infobright", "`", NullCollation.HIGH),
        NEOVIEW("Neoview", null, NullCollation.HIGH),
        SYBASE("Sybase", null, NullCollation.HIGH),
        TERADATA("Teradata", "\"", NullCollation.HIGH),
        HSQLDB("Hsqldb", null, NullCollation.HIGH),
        VERTICA("Vertica", "\"", NullCollation.HIGH),
        SQLSTREAM("SQLstream", "\"", NullCollation.HIGH),
        PARACCEL("Paraccel", "\"", NullCollation.HIGH),
        REDSHIFT("Redshift", "\"", NullCollation.HIGH),
        UNKNOWN("Unknown", "`", NullCollation.HIGH);

        private SqlDialect dialect = null;
        private String databaseProductName;
        private String quoteString;
        private final NullCollation nullCollation;

        private DatabaseProduct(String databaseProductName, String quoteString, NullCollation nullCollation) {
            this.databaseProductName = databaseProductName;
            this.quoteString = quoteString;
            this.nullCollation = nullCollation;
        }

        public SqlDialect getDialect() {
            if (this.dialect == null) {
                this.dialect = new SqlDialect(this, this.databaseProductName, this.quoteString, this.nullCollation);
            }
            return this.dialect;
        }
    }

    public static class FakeUtil {
        public static Error newInternal(Throwable e, String s) {
            String message = "Internal error: \u0000" + s;
            AssertionError ae = new AssertionError((Object)message);
            ((Throwable)((Object)ae)).initCause(e);
            return ae;
        }

        public static String replace(String s, String find, String replace) {
            int found = s.indexOf(find);
            if (found == -1) {
                return s;
            }
            StringBuilder sb = new StringBuilder(s.length());
            int start = 0;
            while (true) {
                if (start < found) {
                    sb.append(s.charAt(start));
                    ++start;
                    continue;
                }
                if (found == s.length()) break;
                sb.append(replace);
                found = s.indexOf(find, start += find.length());
                if (found != -1) continue;
                found = s.length();
            }
            return sb.toString();
        }
    }
}

